/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceAbortEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceCompleteEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFailedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceProgressEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.query.EventOrder;
import com.raplix.rolloutexpress.event.query.MultiDifferenceFoundQuery;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.DiffTasksBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DiffTasksHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_VIEW = "error.diffTasks.view";
    public static final String MSG_ERROR_CANCEL = "error.diffTasks.cancel";
    public static final String MSG_ERROR_STOP = "error.diffTasks.stop";
    public static final String MSG_ERROR_FOUND_ERRORS = "error.diffTasks.foundErrors";
    public static final String MSG_ERROR_CANCEL_REQUESTED_MAJOR = "error.diffTasks.cancelRequested.major";
    public static final String MSG_ERROR_CANCEL_REQUESTED_MINOR = "error.diffTasks.cancelRequested.minor";
    public static final String MSG_ERROR_JOB_CANCELLED = "error.diffTasks.jobCancelled";
    public static final String MSG_ERROR_NO_SETTINGS_ID = "error.diffTasks.noSettingsId";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = DiffTasksHandleAction.assertGetParam(request, "mode");
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        bean.setIncomingMode(mode);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(Thread.currentThread().toString() + " coming through DiffTasksHandleAction: " + mode, this);
        }
        if (mode.equals("view")) {
            this.handleView(request, servletInfo);
        } else if (mode.equals("flatview")) {
            this.handleFlatView(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("stop")) {
            this.handleStop(request, servletInfo);
        } else if (mode.equals("expand")) {
            this.handleExpand(request, servletInfo);
        } else if (mode.equals("render")) {
            this.handleRender(request, servletInfo);
        } else if (mode.equals("poll")) {
            this.handlePoll(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to DiffTasksHandleAction.");
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(Thread.currentThread().toString() + " off to " + servletInfo.getDestPage(), this);
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        String mode = DiffTasksHandleAction.assertGetParam(request, "mode");
        DiffTasksBean bean = null;
        if (mode.equals("view") || mode.equals("flatview")) {
            DifferenceDBInterface diffDB = DiffTasksHandleAction.getApplication().getDifferenceDBInterface();
            DifferenceInterface diffInf = DiffTasksHandleAction.getApplication().getDifferenceInterface();
            NotificationRPCInterface notificationMan = DiffTasksHandleAction.getApplication().getNotificationInterface();
            InstallDBManager installDB = DiffTasksHandleAction.getApplication().getInstallDBManager();
            bean = new DiffTasksBean(diffDB, diffInf, notificationMan, installDB);
        } else {
            String id = request.getParameter("id");
            bean = (DiffTasksBean)request.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected Bean not found.");
            }
        }
        return bean;
    }

    public String getDefaultPage() {
        return "/diffs.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = DiffTasksHandleAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through DiffTasksHandleAction: " + mode, this);
        }
        if (mode.equals("view") || mode.equals("flatview") || mode.equals("refresh")) {
            return MSG_ERROR_VIEW;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("stop")) {
            return MSG_ERROR_STOP;
        }
        if (mode.equals("expand") || mode.equals("render") || mode.equals("poll")) {
            return MSG_ERROR_VIEW;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to DiffTasksHandleAction.");
    }

    protected void handleExpand(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        if (bean.getIsFlatView()) {
            bean.setIsFlatView(false);
            this.refreshCurrentStatus(bean, servletInfo.getErrors(), "view");
        }
        this.refreshCurrentStatus(bean, servletInfo.getErrors(), "expand");
        String path = request.getParameter("directoryName");
        bean.setPath(path);
        servletInfo.setDestPage("/diffTaskDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/Diffs");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleStop(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        bean.stopDiff();
        this.refreshCurrentStatus(bean, servletInfo.getErrors(), "stop");
        if (bean.getCompletedPercentageValue() >= 100) {
            bean.setTotalDifferenceCount(bean.getDifferenceCount());
            servletInfo.setDestPage("/diffTaskDetails.jsp");
        } else {
            servletInfo.setDestPage("/diffProgress.jsp");
        }
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRender(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        bean.loadPermissions();
        this.refreshCurrentStatus(bean, servletInfo.getErrors(), "render");
        servletInfo.setDestPage("/diffProgressTop.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handlePoll(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        this.refreshCurrentStatus(bean, servletInfo.getErrors(), "poll");
        servletInfo.setDestPage("/diffProgressBottom.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleView(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        String jobid = DiffTasksHandleAction.assertGetParam(request, "jobid");
        bean.setJobID(jobid);
        bean.setIsFlatView(false);
        String settingsID = null;
        if (request.getParameter("settingsid") != null) {
            settingsID = request.getParameter("settingsid");
        } else {
            settingsID = this.getSettingIDFromJobID(jobid);
            if (settingsID == null) {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_VIEW);
                servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SETTINGS_ID);
                servletInfo.setDestPage("/errorhome.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
        }
        bean.loadDiffSettings(settingsID);
        this.refreshCurrentStatus(bean, servletInfo.getErrors(), "view");
        if (bean.getCompletedPercentageValue() >= 100) {
            bean.setTotalDifferenceCount(bean.getDifferenceCount());
            servletInfo.setDestPage("/diffTaskDetails.jsp");
        } else {
            servletInfo.setDestPage("/diffProgress.jsp");
        }
        servletInfo.setShouldRedirect(false);
    }

    protected void handleFlatView(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean dtb = (DiffTasksBean)servletInfo.getBean();
        String jobid = DiffTasksHandleAction.assertGetParam(request, "jobid");
        dtb.setJobID(jobid);
        dtb.setIsFlatView(true);
        String sort = DiffTasksHandleAction.assertGetParam(request, "sortName");
        dtb.setSelectedSort(sort);
        String settingsID = this.getSettingIDFromJobID(jobid);
        if (settingsID == null) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_VIEW);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SETTINGS_ID);
            servletInfo.setDestPage("/errorhome.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        dtb.loadDiffSettings(settingsID);
        this.refreshCurrentStatus(dtb, servletInfo.getErrors(), "flatview");
        if (dtb.getCompletedPercentageValue() >= 100) {
            servletInfo.setDestPage("/diffTaskDetails.jsp");
        } else {
            servletInfo.setDestPage("/diffProgress.jsp");
        }
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DiffTasksBean bean = (DiffTasksBean)servletInfo.getBean();
        bean.setForceRefresh(false);
        this.refreshCurrentStatus(bean, servletInfo.getErrors(), "refresh");
        if (bean.getCompletedPercentageValue() >= 100) {
            bean.setTotalDifferenceCount(bean.getDifferenceCount());
            servletInfo.setDestPage("/diffTaskDetails.jsp");
        } else {
            servletInfo.setDestPage("/diffProgress.jsp");
        }
        servletInfo.setShouldRedirect(false);
    }

    private void refreshCurrentStatus(DiffTasksBean bean, ServletErrors errors, String mode) throws RaplixException {
        int status = this.determineStatus(bean);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(Thread.currentThread().toString() + " Refresh status: " + status + " mode: " + mode, this);
        }
        String jobID = bean.getJobID();
        DifferenceJobID jobIDObj = new DifferenceJobID(jobID);
        while (status == 0) {
            int pctComplete;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Taking actions for an unfinished diff", this);
            }
            if ((pctComplete = this.determineCompletedPercentage(bean)) < 100) break;
            status = this.determineStatus(bean);
        }
        if (status == 1) {
            ROXDifferenceFoundEvent[] results;
            ROXEvent[] errorMsgs;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug(Thread.currentThread().toString() + " Taking actions for a finished diff", this);
            }
            bean.setCompletedPercentageValue(100);
            if (!mode.equals("render") && (errorMsgs = this.checkError(bean)) != null) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Diff reported some errors", this);
                }
                for (int i = 0; i < errorMsgs.length; ++i) {
                    ROXDifferenceFailedEvent failedEvent = (ROXDifferenceFailedEvent)errorMsgs[i];
                    errors.addMinorError(failedEvent);
                }
                if (errors.isSeverityPresent(Severity.ERROR)) {
                    errors.setMajorErrorKey(MSG_ERROR_FOUND_ERRORS);
                }
            }
            if (mode.equals("refresh") || mode.equals("view") || mode.equals("stop")) {
                ROXDifferenceFoundEvent prototype = new ROXDifferenceFoundEvent();
                prototype.setDifferenceJobID(jobIDObj);
                ROXEvent[] matchingEvents = this.singlePrototypeNotificationQuery(prototype);
                results = new ROXDifferenceFoundEvent[matchingEvents.length];
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Recieved " + results.length + " differences!", this);
                }
                for (int i = 0; i < results.length; ++i) {
                    results[i] = (ROXDifferenceFoundEvent)matchingEvents[i];
                }
                bean.setResults(results);
            } else if (mode.equals("flatview")) {
                MultiDifferenceFoundQuery mdfq = MultiDifferenceFoundQuery.allDifferencesFound(jobIDObj);
                if (bean.getSelectedSort().equals("path")) {
                    mdfq.setObjectOrder(EventOrder.BY_PATH_ASC);
                } else {
                    mdfq.setObjectOrder(EventOrder.BY_TYPE_ASC);
                }
                ROXEvent[] matchingEvents = mdfq.select();
                results = new ROXDifferenceFoundEvent[matchingEvents.length];
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Recieved " + results.length + " differences!", this);
                }
                for (int i = 0; i < results.length; ++i) {
                    results[i] = (ROXDifferenceFoundEvent)matchingEvents[i];
                }
                bean.setResults(results);
                bean.setTotalDifferenceCount(bean.getFlatViewTotalDifferences());
            }
        } else if (status == 2) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Taking actions for an abort-requested diff", this);
            }
            this.determineCompletedPercentage(bean);
            errors.setMajorErrorKey(MSG_ERROR_CANCEL_REQUESTED_MAJOR);
            errors.addMinorErrorKey(MSG_ERROR_CANCEL_REQUESTED_MINOR);
            if (bean.getStatus() != 2) {
                bean.setForceRefresh(true);
            }
        } else if (status == 3) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Taking actions for an aborted diff", this);
            }
            bean.setCompletedPercentageValue(100);
            if (!mode.equals("render")) {
                errors.setMajorErrorKey(MSG_ERROR_JOB_CANCELLED);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(Thread.currentThread().toString() + " DTB status: " + status, this);
        }
        bean.setStatus(status);
    }

    private int determineStatus(DiffTasksBean bean) throws RaplixException {
        boolean finished = this.checkFinished(bean);
        boolean aborted = this.checkAborted(bean);
        boolean abortRequested = this.checkAbortRequested(bean);
        if (aborted) {
            return 3;
        }
        if (finished) {
            return 1;
        }
        if (abortRequested) {
            return 2;
        }
        return 0;
    }

    private int determineCompletedPercentage(DiffTasksBean bean) throws RaplixException {
        ROXDifferenceProgressEvent prototype = new ROXDifferenceProgressEvent();
        prototype.setDifferenceJobID(new DifferenceJobID(bean.getJobID()));
        ROXEvent[] matchingEvents = this.singlePrototypeNotificationQuery(prototype);
        int percentageComplete = 0;
        if (matchingEvents.length == 1) {
            ROXDifferenceProgressEvent progressEv = (ROXDifferenceProgressEvent)matchingEvents[0];
            percentageComplete = (int)progressEv.getProgress();
            bean.setCompletedPercentageValue(percentageComplete);
        }
        return percentageComplete;
    }

    private boolean checkFinished(DiffTasksBean bean) throws RaplixException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to check if job has finished", this);
        }
        ROXDifferenceCompleteEvent completeEvent = new ROXDifferenceCompleteEvent();
        completeEvent.setDifferenceJobID(new DifferenceJobID(bean.getJobID()));
        ROXEvent[] matchingEvents = this.singlePrototypeNotificationQuery(completeEvent);
        if (matchingEvents.length == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Did not recieve a finished event", this);
            }
            return false;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Recieved a finished event", this);
        }
        return true;
    }

    private boolean checkAborted(DiffTasksBean bean) throws RaplixException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to check if job has aborted", this);
        }
        ROXDifferenceAbortEvent abortEvent = new ROXDifferenceAbortEvent();
        abortEvent.setDifferenceJobID(new DifferenceJobID(bean.getJobID()));
        ROXEvent[] matchingEvents = this.singlePrototypeNotificationQuery(abortEvent);
        if (matchingEvents.length == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Did not recieve a aborted event", this);
            }
            return false;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Recieved a aborted event", this);
        }
        return true;
    }

    private boolean checkAbortRequested(DiffTasksBean bean) throws RaplixException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to check if job has abort-requested", this);
        }
        ROXDifferenceAbortRequestedEvent abortReqEvent = new ROXDifferenceAbortRequestedEvent();
        abortReqEvent.setDifferenceJobID(new DifferenceJobID(bean.getJobID()));
        ROXEvent[] matchingEvents = this.singlePrototypeNotificationQuery(abortReqEvent);
        if (matchingEvents.length == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Did not recieve a abort-requested event", this);
            }
            return false;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Recieved a abort-requested event", this);
        }
        return true;
    }

    private ROXEvent[] checkError(DiffTasksBean bean) throws RaplixException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to check if job has failed", this);
        }
        ROXDifferenceFailedEvent fEvent = new ROXDifferenceFailedEvent();
        fEvent.setDifferenceJobID(new DifferenceJobID(bean.getJobID()));
        fEvent.setSeverity(0);
        ROXEvent[] matchingEvents = this.singlePrototypeNotificationQuery(fEvent);
        if (matchingEvents.length == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Did not recieve a failed event", this);
            }
            return null;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Recieved a failed event", this);
        }
        return matchingEvents;
    }

    private String getSettingIDFromJobID(String jobID) throws RaplixException {
        ROXDifferenceStartEvent startedEventProto = new ROXDifferenceStartEvent();
        startedEventProto.setDifferenceJobID(new DifferenceJobID(jobID));
        ROXEvent[] startedEventArray = this.singlePrototypeNotificationQuery(startedEventProto);
        if (startedEventArray.length == 0) {
            return null;
        }
        ROXDifferenceStartEvent startedEvent = (ROXDifferenceStartEvent)startedEventArray[0];
        return startedEvent.getDifferenceSettingsID().toString();
    }

    private ROXEvent[] singlePrototypeNotificationQuery(ROXEvent inEvent) throws RaplixException {
        NotificationRPCInterface notMan = DiffTasksHandleAction.getApplication().getNotificationInterface();
        Vector<ROXEvent> prototypes = new Vector<ROXEvent>();
        prototypes.add(inEvent);
        try {
            Vector matchingEvents = notMan.query(prototypes);
            return matchingEvents.toArray(new ROXEvent[0]);
        }
        catch (EmptyQueryException e) {
            return new ROXEvent[0];
        }
    }
}

