/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceJob;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.DiffsBean;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.data.DiffResultsObject;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.util.logger.Logger;

public class DiffTasksBean
extends DiffsBean {
    private static final String SORT_LABEL_BY_PATH = "label.diffs.sort.pathname";
    private static final String SORT_LABEL_BY_TYPE = "label.diffs.sort.differencetype";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";
    public static final String SORT_BY_PATH = "path";
    public static final String SORT_BY_TYPE = "type";
    protected String mJobID = "";
    protected String mSrcHostSetName = "";
    protected String mSrcComponentName = "";
    protected String mSrcInstallPath = "";
    protected DiffResultsObject mResults = null;
    protected String mCurrPath = "";
    protected int mPercentageComplete = 0;
    protected String mTotalDifferenceCount = "0";
    protected int mStatus;
    protected boolean mForceRefresh = false;
    private boolean mIsFlatView = false;
    private boolean mIsUserTaskOwner = true;
    public static final int STATUS_PROGRESS = 0;
    public static final int STATUS_COMPLETE = 1;
    public static final int STATUS_ABORT_REQUESTED = 2;
    public static final int STATUS_ABORTED = 3;
    private String mSelectedSort = "path";

    public DiffTasksBean(DifferenceDBInterface diffDB, DifferenceInterface diffInf, NotificationRPCInterface notInf, InstallDBManager installDB) {
        super(diffDB, diffInf, notInf, installDB);
    }

    public void loadDiffSettings(String id) throws RaplixException {
        super.loadDiffSettings(id);
        if (this.getSrcHostSetID() != null && !this.getSrcHostSetID().toString().trim().equals(EMPTY_STRING)) {
            this.mSrcHostSetName = HostSetsBean.getSummaryHostSetByID(this.getSrcHostSetID()).getName();
        }
        if (this.getSrcInstalledComponentID() != null && !this.getSrcInstalledComponentID().toString().trim().equals(EMPTY_STRING)) {
            InstalledComponent theInstalledComponent = new InstalledComponentID(this.getSrcInstalledComponentID()).getByIDQuery().select();
            Component comp = theInstalledComponent.getComponentID().getByIDQuery().select();
            this.mSrcComponentName = comp.getFullName();
            this.mSrcInstallPath = theInstalledComponent.getInstallPath();
        }
    }

    public String getID() {
        return this.getJobID();
    }

    public String getSettingsID() {
        return super.getID();
    }

    public String getJobID() {
        return this.mJobID;
    }

    public String getSrcHostSetName() {
        return this.mSrcHostSetName;
    }

    public String getSrcComponentName() {
        return this.mSrcComponentName;
    }

    public String getSrcInstallPath() {
        return this.mSrcInstallPath;
    }

    public String[] getPath() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getPath();
    }

    public String[] getSubdirectories() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getSubDirectories();
    }

    public String[] getSubdirectoryTypes() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getSubDirectoryTypes();
    }

    public String[] getSubdirectoryCounts() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getSubdirectoryCounts();
    }

    public String[] getDifferenceFilenames() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getDifferenceFilenames();
    }

    public String[] getFileCounts() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getFileCounts();
    }

    public int getCurrentDifferenceIndex() {
        if (this.mResults == null) {
            return -1;
        }
        return this.mResults.getCurrentDifferenceIndex();
    }

    public String getCurrentDifference() {
        if (this.mResults == null) {
            return EMPTY_STRING;
        }
        return this.mResults.getCurrentDifference();
    }

    public String[] getAllCurrentDifferences() {
        if (this.mResults == null) {
            return new String[0];
        }
        return this.mResults.getAllCurrentDifferences();
    }

    public String[] getAllDifferencePaths() {
        if (this.mResults == null) {
            return new String[0];
        }
        return this.mResults.getAllDifferencePaths();
    }

    public int[] getAllDifferenceSizes() {
        if (this.mResults == null) {
            return new int[0];
        }
        return this.mResults.getAllDifferenceSizes();
    }

    public String getDifferenceCount() {
        if (this.mResults == null) {
            return EMPTY_STRING;
        }
        return this.mResults.getDifferenceCount();
    }

    public String getTotalDifferenceCount() {
        return this.mTotalDifferenceCount;
    }

    public String getFlatViewTotalDifferences() {
        if (this.mResults == null) {
            return EMPTY_STRING;
        }
        return String.valueOf(this.mResults.getTotalDifferences());
    }

    public String[] getPathTypes() {
        if (this.mResults == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.mResults.getPathTypes();
    }

    public String getPercentageComplete() {
        return EMPTY_STRING + this.mPercentageComplete;
    }

    public boolean getIsFlatView() {
        return this.mIsFlatView;
    }

    public boolean getIsUserTaskOwner() {
        return this.mIsUserTaskOwner;
    }

    public String[] getSortValues() {
        return new String[]{SORT_BY_PATH, SORT_BY_TYPE};
    }

    public String[] getSortLabels() {
        return new String[]{ApplicationResources.getMessage(SORT_LABEL_BY_PATH), ApplicationResources.getMessage(SORT_LABEL_BY_TYPE)};
    }

    public String getSelectedSort() {
        return this.mSelectedSort;
    }

    public void setSelectedSort(String inSort) {
        this.mSelectedSort = inSort;
    }

    public void setIsFlatView(boolean flatView) {
        this.mIsFlatView = flatView;
    }

    public synchronized void setResults(ROXDifferenceFoundEvent[] results) {
        this.mResults = new DiffResultsObject(this.mInstallDB);
        this.mResults.setStyle(this.getStyle());
        if (this.getIsFlatView()) {
            this.mResults.loadFlatResults(results, this.getDiffDB());
        } else if (this.getStyle().equals("repo2repo")) {
            this.mResults.loadModel2ModelResults(results, this.getDiffDB());
        } else if (this.getStyle().equals("repo2inst")) {
            this.mResults.loadModel2InstallResults(results, this.getDiffDB());
        } else {
            this.mResults.loadInstall2InstallResults(results, this.getDiffDB());
        }
    }

    public void setJobID(String in) {
        this.mJobID = in;
    }

    public void setTotalDifferenceCount(String in) {
        this.mTotalDifferenceCount = in;
    }

    public void setPath(String inPath) {
        this.mResults.setPath(inPath);
        this.mResults.setCurrentDifferenceStr(this.getDiffDB());
    }

    public void setCompletedPercentageValue(int inPercent) {
        int inFiveDiv = inPercent / 5;
        this.mPercentageComplete = inFiveDiv * 5;
    }

    public void setStatus(int status) {
        this.mStatus = status;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.mForceRefresh = forceRefresh;
    }

    public int getCompletedPercentageValue() {
        return this.mPercentageComplete;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public String getStatusAsString() {
        return new Integer(this.mStatus).toString();
    }

    public String getForceRefreshAsString() {
        if (this.mForceRefresh) {
            return "true";
        }
        return "false";
    }

    public void stopDiff() throws RaplixException {
        this.mDiffInf.halt(new DifferenceJobID(this.getJobID()));
    }

    public void loadPermissions() throws RaplixException {
        DifferenceJobID jobID = new DifferenceJobID(this.mJobID);
        DifferenceJob dj = jobID.getByIDQuery().select();
        this.mIsUserTaskOwner = PermissionChecker.hasTaskOwnerPermission(dj);
    }

    public void debugObject(String inStage) {
        block3: {
            try {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("About to debug a DiffTasksBean", this);
                }
                super.debugObject(inStage);
                this.debugValue(this.getPercentageComplete(), "getPercentageComplete");
                this.debugValue(this.getName(), "getName");
                this.debugValue(this.getDescription(), "getDescription");
                this.debugArray(this.getPath(), "getOldPath");
                this.debugArray(this.getSubdirectories(), "getSubdirectories");
                this.debugArray(this.getDifferenceFilenames(), "getDifferenceFilenames");
                this.debugValue(EMPTY_STRING + this.getCurrentDifferenceIndex(), "getCurrentDifferenceIndex");
                this.debugValue(this.getCurrentDifference(), "getCurrentDifference");
            }
            catch (Exception e) {
                if (!Logger.isDebugEnabled(this)) break block3;
                Logger.debug("Exception in debugObject(): " + e.toString(), this);
            }
        }
    }
}

