/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.DeleteChildrenHelper;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import org.apache.struts.util.MessageResources;

public class DiffDeleteNode
extends UITreeNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;
    private static final String MSG_RUN_HISTORY_RECORDS = "diff.delete.runhistory";
    private DifferenceSettingsID mDiffID = null;
    private String mName = "";
    private String mDescription = "";
    private boolean mIsUndeletable = false;
    private int mNumDeletableRelatedItems = 0;
    private int mRowLevel = 0;
    private String mPrologue = "";
    private String mContents = "";
    private MessageResources messages = ApplicationResources.getMessageResources();

    public int getNumDeletableRelatedItems() {
        return this.mNumDeletableRelatedItems;
    }

    public DiffDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        this.mType = UITreeNodeType.LEAF;
        DeleteSessionCandidateStatus status = candidate.getStatus();
        this.mIsUndeletable = status.equals(DeleteSessionCandidateStatus.IN_USE) || status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
        DifferenceSettingsID diffID = (DifferenceSettingsID)candidate.getParent().getObjectID();
        DifferenceSettings settings = diffID.getByIDQuery().select();
        this.mDiffID = diffID;
        this.mName = settings.getName();
        this.mDescription = settings.getDescription();
        this.preRender();
    }

    public void getDescendents(DeleteSessionCandidate candidate) {
        if (this.mIsUndeletable) {
            PersistenceManagerException pme = (PersistenceManagerException)candidate.getException();
            if (pme != null) {
                String errMsg = pme.getMessage();
                DeleteConfirmNode confirmNode = new DeleteConfirmNode(errMsg, 2, 2);
                this.addChild(confirmNode);
            }
        } else if (candidate.getChildren() != null) {
            DeleteChildrenHelper dch = new DeleteChildrenHelper(this, 2, this.mNumDeletableRelatedItems, candidate.getChildren(), "diffDelete");
            this.mNumDeletableRelatedItems = dch.getNumDeletableRelatedItems();
        }
    }

    public void finishGetDescendants() {
        if (this.mNumDeletableRelatedItems > 0) {
            String depMsg = this.messages.getMessage(MSG_RUN_HISTORY_RECORDS, (Object)(this.mNumDeletableRelatedItems + ""));
            DeleteConfirmNode confirmNode = new DeleteConfirmNode(depMsg, 0, 2);
            this.addChild(confirmNode);
        }
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String editURI = UriUtil.diffDetailsURI(this.mDiffID.toString());
        String nameLink = Util.standardLink(editURI, "Show comparison details", this.mName, "name=\"nameLink-" + this.mDiffID + "\"");
        String descLink = Util.standardLink(editURI, "Show comparison details", this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        String rowspanStr = "rowspan=\"" + this.getVisibleChildCount() + "\"";
        this.mPrologue = "<tr>\n" + Util.introStandardCell(rowspanStr, this.mRowLevel) + Util.standardCellStart(0, "nowrap", this.mRowLevel);
        return this.mPrologue + sb + this.mContents;
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

