/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsIDSet;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceSettingsQuery;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.event.rule.RuleIDSet;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskIDSet;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.DeleteSessionID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.DiffDeleteNode;
import com.raplix.rolloutexpress.ui.web.NotRuleDeleteNode;
import com.raplix.rolloutexpress.ui.web.PlanDeleteNode;
import com.raplix.rolloutexpress.ui.web.PlanRunHistoryNode;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UserGroupsBean;
import com.raplix.rolloutexpress.ui.web.UserGroupsDeleteNode;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDeleteNode;
import com.raplix.rolloutexpress.ui.web.compx.services.ServicesDeleteNode;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypeDeleteNode;
import com.raplix.rolloutexpress.ui.web.folders.FolderDeleteNode;
import com.raplix.rolloutexpress.ui.web.hosts.HostDeleteNode;
import com.raplix.rolloutexpress.ui.web.hosts.HostSearchesDeleteNode;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetDeleteNode;
import com.raplix.rolloutexpress.ui.web.hosts.HostTypeDeleteNode;
import com.raplix.rolloutexpress.ui.web.plugins.PluginDeleteNode;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DeleteProgressBean
extends ServletBean {
    private String mName = "";
    private String mObjectType = "";
    private UserManager mUserMgr = null;
    private GroupManager mGroupMgr = null;
    private PermissionManager mPermMgr = null;
    private RuleMetaDataManager mRuleMetaDataMgr = null;
    private String[] mCategoryIDs = new String[0];
    private String[] mCategoryNames = new String[0];
    private String[] mCategoryDescriptions = new String[0];
    private String mMode = "";
    private String mDeleteSessionID = "";
    private String mDeleteStatus = "";
    private String mSingleDeleteID = "";
    private String mReferrerURL = "";
    private int mDeletePercentageComplete = 0;
    private int mNumDeleteCandidates = 0;
    private int mNumUndeletableCandidates = 0;
    private int mNumDeletableRelatedItems = 0;
    private boolean[] mIsCandidateUndeletable = new boolean[0];
    private String[] mCandidateStatusMessages = new String[0];
    private UITree[] mDeleteConfirmTrees = new UITree[0];
    private DeleteSessionCandidateStatus[] mCandidateStatuses = new DeleteSessionCandidateStatus[0];

    public String getName() {
        return this.mName;
    }

    public String getObjectType() {
        return this.mObjectType;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getDeleteSessionID() {
        return this.mDeleteSessionID;
    }

    public String getDeleteStatus() {
        return this.mDeleteStatus;
    }

    public String getReferrerURL() {
        return this.mReferrerURL;
    }

    public String getSingleDeleteID() {
        return this.mSingleDeleteID;
    }

    public int getDeletePercentageComplete() {
        return this.mDeletePercentageComplete;
    }

    public int getNumDeleteCandidates() {
        return this.mNumDeleteCandidates;
    }

    public int getNumUndeletableCandidates() {
        return this.mNumUndeletableCandidates;
    }

    public int getNumDeletableRelatedItems() {
        return this.mNumDeletableRelatedItems;
    }

    public boolean[] getIsCandidateUndeletable() {
        return this.mIsCandidateUndeletable;
    }

    public String[] getCandidateStatusMessages() {
        return this.mCandidateStatusMessages;
    }

    public UITree[] getDeleteConfirmTrees() {
        return this.mDeleteConfirmTrees;
    }

    public String[] getCategoryIDs() {
        return this.mCategoryIDs;
    }

    public String[] getCategoryNames() {
        return this.mCategoryNames;
    }

    public String[] getCategoryDescriptions() {
        return this.mCategoryDescriptions;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setObjectType(String objectType) {
        this.mObjectType = objectType;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setDeleteSessionID(String id) {
        this.mDeleteSessionID = id;
    }

    public void setDeleteStatus(String status) {
        this.mDeleteStatus = status;
    }

    public void setReferrerURL(String url) {
        this.mReferrerURL = url;
    }

    public void setSingleDeleteID(String id) {
        this.mSingleDeleteID = id;
    }

    public void setDeletePercentageComplete(double percent) {
        this.mDeletePercentageComplete = new Double(percent * 100.0).intValue() / 5 * 5;
    }

    public RuleMetaDataManager getRuleMetaDataManager() {
        return this.mRuleMetaDataMgr;
    }

    public PermissionManager getPermissionManager() {
        return this.mPermMgr;
    }

    public UserManager getUserManager() {
        return this.mUserMgr;
    }

    public GroupManager getGroupManager() {
        return this.mGroupMgr;
    }

    public void setRuleMetaDataManager(RuleMetaDataManager ruleMetaDataMgr) {
        this.mRuleMetaDataMgr = ruleMetaDataMgr;
    }

    public void setPermissionManager(PermissionManager permMgr) {
        this.mPermMgr = permMgr;
    }

    public void setUserManager(UserManager userMgr) {
        this.mUserMgr = userMgr;
    }

    public void setGroupManager(GroupManager groupMgr) {
        this.mGroupMgr = groupMgr;
    }

    public String delete(String[] ids) throws RaplixException {
        Vector<ObjectID> idList = new Vector<ObjectID>();
        for (int i = 0; i < ids.length; ++i) {
            if ("host".equals(this.mObjectType)) {
                idList.addElement(new HostID(ids[i]));
                continue;
            }
            if ("hostType".equals(this.mObjectType)) {
                idList.addElement(new HostTypeID(ids[i]));
                continue;
            }
            if ("hostset".equals(this.mObjectType)) {
                idList.addElement(new HostSetID(ids[i]));
                continue;
            }
            if ("hostsearch".equals(this.mObjectType)) {
                idList.addElement(new HostSearchID(ids[i]));
                continue;
            }
            if ("diff".equals(this.mObjectType)) {
                Vector<DifferenceSettingsID> allVersionIDs = new Vector<DifferenceSettingsID>();
                DifferenceSettingsID id = new DifferenceSettingsID(ids[i]);
                DifferenceSettings[] allVersions = MultiDifferenceSettingsQuery.allVersionsOf(id).select();
                for (int j = 0; j < allVersions.length; ++j) {
                    allVersionIDs.addElement(allVersions[j].getID());
                }
                idList.addAll(allVersionIDs);
                continue;
            }
            if ("usergroup".equals(this.mObjectType)) {
                idList.addElement(new GroupID(ids[i]));
                continue;
            }
            if ("planRunHistory".equals(this.mObjectType)) {
                idList.addElement(new TaskID(ids[i]));
                continue;
            }
            if ("folder".equals(this.mObjectType)) {
                idList.addElement(new FolderID(ids[i]));
                continue;
            }
            if ("plugin".equals(this.mObjectType)) {
                idList.addElement(new PluginID(ids[i]));
                continue;
            }
            if ("componentType".equals(this.mObjectType)) {
                idList.addElement(new ComponentTypeRefID(ids[i]));
                continue;
            }
            if ("systemServices".equals(this.mObjectType)) {
                idList.addElement(new SystemServiceRefID(ids[i]));
                continue;
            }
            if ("notificationRule".equals(this.mObjectType)) {
                idList.addElement(new RuleID(ids[i]));
                continue;
            }
            if (!"categories".equals(this.mObjectType)) continue;
            idList.addElement(new CategoryID(ids[i]));
        }
        if ("host".equals(this.mObjectType)) {
            return HostID.delete(new HostIDSet(idList)).toString();
        }
        if ("hostType".equals(this.mObjectType)) {
            return HostTypeID.delete(new HostTypeIDSet(idList)).toString();
        }
        if ("hostset".equals(this.mObjectType)) {
            return HostSetID.delete(new HostSetIDSet(idList)).toString();
        }
        if ("hostsearch".equals(this.mObjectType)) {
            HostSearchIDSet idSet = new HostSearchIDSet();
            idSet.addAll(idList);
            return HostSearchID.delete(idSet).toString();
        }
        if ("diff".equals(this.mObjectType)) {
            return DifferenceSettingsID.delete(new DifferenceSettingsIDSet(idList)).toString();
        }
        if ("usergroup".equals(this.mObjectType)) {
            return GroupID.delete(new GroupIDSet(idList)).toString();
        }
        if ("planRunHistory".equals(this.mObjectType)) {
            return TaskID.delete(new TaskIDSet(idList)).toString();
        }
        if ("folder".equals(this.mObjectType)) {
            return FolderID.delete(new FolderIDSet(idList)).toString();
        }
        if ("plugin".equals(this.mObjectType)) {
            return PluginID.delete(new PluginIDSet(idList)).toString();
        }
        if ("componentType".equals(this.mObjectType)) {
            return ComponentTypeRefID.delete(new ComponentTypeRefIDSet(idList)).toString();
        }
        if ("systemServices".equals(this.mObjectType)) {
            return SystemServiceRefID.delete(new SystemServiceRefIDSet(idList)).toString();
        }
        if ("notificationRule".equals(this.mObjectType)) {
            RuleIDSet idSet = new RuleIDSet();
            idSet.addAll(idList);
            return RuleID.delete(idSet).toString();
        }
        if ("categories".equals(this.mObjectType)) {
            return CategoryID.delete(new CategoryIDSet(idList)).toString();
        }
        return null;
    }

    public String delete(String[] ids, boolean allVersions) throws RaplixException {
        Vector idList = new Vector();
        for (int i = 0; i < ids.length; ++i) {
            int j;
            StandardObject[] versionTree;
            Vector<VersionedObjectID> allVersionIDs = new Vector<VersionedObjectID>();
            if ("component".equals(this.mObjectType)) {
                ComponentID componentID = new ComponentID(ids[i]);
                if (allVersions) {
                    versionTree = componentID.getAllVersionsQuery().selectSummaryView();
                    for (j = 0; j < versionTree.length; ++j) {
                        allVersionIDs.add(((SummaryComponent)versionTree[j]).getID());
                    }
                } else {
                    allVersionIDs.add(componentID);
                }
            } else if ("plan".equals(this.mObjectType)) {
                ExecutionPlanID planID = new ExecutionPlanID(ids[i]);
                if (allVersions) {
                    versionTree = planID.getAllVersionsQuery().selectSummaryView();
                    for (j = 0; j < versionTree.length; ++j) {
                        allVersionIDs.add(((SummaryExecutionPlan)versionTree[j]).getID());
                    }
                } else {
                    allVersionIDs.add(planID);
                }
            }
            idList.addAll(allVersionIDs);
        }
        if ("component".equals(this.mObjectType)) {
            ComponentIDSet idSet = new ComponentIDSet(idList);
            return ComponentID.delete(idSet).toString();
        }
        if ("plan".equals(this.mObjectType)) {
            ExecutionPlanIDSet idSet = new ExecutionPlanIDSet(idList);
            return ExecutionPlanID.delete(idSet).toString();
        }
        return null;
    }

    public void generateConfirmationList() throws RaplixException {
        DiffDeleteNode diffNode;
        UITree tree;
        DeleteSessionID sessionID = new DeleteSessionID(this.mDeleteSessionID);
        Collection coll = sessionID.getDeleteCandidates();
        Hashtable<DifferenceSettingsID, DiffDeleteNode> latestVersionHash = new Hashtable<DifferenceSettingsID, DiffDeleteNode>();
        int i = 0;
        Iterator<Object> items = coll.iterator();
        if ("categories".equals(this.mObjectType)) {
            this.mCategoryIDs = new String[coll.size()];
            this.mCategoryNames = new String[coll.size()];
            this.mCategoryDescriptions = new String[coll.size()];
        } else {
            this.mDeleteConfirmTrees = new UITree[coll.size()];
        }
        while (items.hasNext()) {
            UITreeNode node;
            DeleteSessionCandidate candidate = (DeleteSessionCandidate)items.next();
            tree = new UITree();
            if ("host".equals(this.mObjectType)) {
                node = new HostDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("plugin".equals(this.mObjectType)) {
                node = new PluginDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate, ApplicationResources.getMessage("plugins.delCandidate.header"));
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("hostType".equals(this.mObjectType)) {
                node = new HostTypeDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("hostset".equals(this.mObjectType)) {
                node = new HostSetDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("hostsearch".equals(this.mObjectType)) {
                node = new HostSearchesDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("folder".equals(this.mObjectType)) {
                node = new FolderDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("usergroup".equals(this.mObjectType)) {
                node = new UserGroupsDeleteNode(candidate, new UserGroupsBean(this.getUserManager(), this.getGroupManager(), this.getPermissionManager()).getGroupManager());
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((UserGroupsDeleteNode)node).getDescendents(candidate);
            } else if ("component".equals(this.mObjectType)) {
                node = new ComponentDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("componentType".equals(this.mObjectType)) {
                node = new ComponentTypeDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((ComponentTypeDeleteNode)node).getDescendents(candidate);
            } else if ("systemServices".equals(this.mObjectType)) {
                node = new ServicesDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((ServicesDeleteNode)node).getDescendents(candidate);
            } else if ("plan".equals(this.mObjectType)) {
                node = new PlanDeleteNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
                this.mNumDeletableRelatedItems += ((StandardObjectDeleteNode)node).getNumDeletableRelatedItems();
            } else if ("planRunHistory".equals(this.mObjectType)) {
                node = new PlanRunHistoryNode(candidate);
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((StandardObjectDeleteNode)node).getDescendents(candidate);
            } else if ("notificationRule".equals(this.mObjectType)) {
                node = new NotRuleDeleteNode(candidate, this.getRuleMetaDataManager());
                tree.setRoot(node);
                this.mDeleteConfirmTrees[i] = tree;
                ((NotRuleDeleteNode)node).getDescendents(candidate);
            } else if ("categories".equals(this.mObjectType)) {
                CategoryID categoryID = (CategoryID)candidate.getParent().getObjectID();
                Category category = categoryID.getByIDQuery().select();
                this.mCategoryIDs[i] = category.getID().toString();
                this.mCategoryNames[i] = category.getName();
                this.mCategoryDescriptions[i] = category.getDescription();
            } else if ("diff".equals(this.mObjectType)) {
                try {
                    DifferenceSettingsID settingsID = (DifferenceSettingsID)candidate.getParent().getObjectID();
                    DifferenceSettings settings = settingsID.getByIDQuery().select();
                    DifferenceSettingsID latestSettingsID = (DifferenceSettingsID)settings.retrieveLatest().getObjectID();
                    diffNode = (DiffDeleteNode)latestVersionHash.get(latestSettingsID);
                    if (diffNode == null) {
                        diffNode = new DiffDeleteNode(candidate);
                        latestVersionHash.put(latestSettingsID, diffNode);
                    }
                    diffNode.getDescendents(candidate);
                }
                catch (NoResultsFoundException nsfe) {
                    // empty catch block
                }
            }
            ++i;
        }
        if ("diff".equals(this.mObjectType)) {
            Collection allDiffs = latestVersionHash.values();
            items = allDiffs.iterator();
            this.mDeleteConfirmTrees = new UITree[allDiffs.size()];
            i = 0;
            while (items.hasNext()) {
                diffNode = (DiffDeleteNode)items.next();
                this.mNumDeletableRelatedItems += diffNode.getNumDeletableRelatedItems();
                diffNode.finishGetDescendants();
                tree = new UITree();
                tree.setRoot(diffNode);
                this.mDeleteConfirmTrees[i] = tree;
                ++i;
            }
            this.refreshStatusList(this.removePriorVersions(sessionID.getDeleteCandidates()));
            return;
        }
        if (!"categories".equals(this.mObjectType)) {
            this.refreshStatusList(null);
            return;
        }
    }

    private Collection removePriorVersions(Collection candidates) throws RaplixException {
        Iterator dsIDs = candidates.iterator();
        Vector latestVersions = new Vector(candidates);
        while (dsIDs.hasNext()) {
            try {
                DifferenceSettings settings;
                DifferenceSettingsID latestID;
                DeleteSessionCandidate candidate = (DeleteSessionCandidate)dsIDs.next();
                DifferenceSettingsID settingsID = (DifferenceSettingsID)candidate.getParent().getObjectID();
                if (settingsID.equals(latestID = (DifferenceSettingsID)(settings = settingsID.getByIDQuery().select()).retrieveLatest().getObjectID())) continue;
                latestVersions.remove(candidate);
            }
            catch (NoResultsFoundException nsfe) {}
        }
        return latestVersions;
    }

    private void refreshStatusList(Collection coll) throws RaplixException {
        if (coll == null) {
            coll = new DeleteSessionID(this.mDeleteSessionID).getDeleteCandidates();
        }
        this.mNumDeleteCandidates = coll.size();
        this.mNumUndeletableCandidates = 0;
        this.mIsCandidateUndeletable = new boolean[this.mNumDeleteCandidates];
        this.mCandidateStatusMessages = new String[this.mNumDeleteCandidates];
        this.mCandidateStatuses = new DeleteSessionCandidateStatus[this.mNumDeleteCandidates];
        int i = 0;
        Iterator items = coll.iterator();
        while (items.hasNext()) {
            DeleteSessionCandidate candidate = (DeleteSessionCandidate)items.next();
            DeleteSessionCandidateStatus status = candidate.getStatus();
            boolean inUse = status.equals(DeleteSessionCandidateStatus.IN_USE);
            boolean notDeletable = status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
            if (inUse || notDeletable) {
                ++this.mNumUndeletableCandidates;
            }
            this.mIsCandidateUndeletable[i] = inUse || notDeletable;
            this.mCandidateStatusMessages[i] = candidate.getException() == null ? "" : candidate.getException().getMessage();
            this.mCandidateStatuses[i] = status;
            ++i;
        }
    }

    public void refreshDeleteStatus() throws RaplixException {
        DeleteSessionID sessionID = new DeleteSessionID(this.mDeleteSessionID);
        this.setDeletePercentageComplete(sessionID.getProgress());
        this.setDeleteStatus(sessionID.getStatus().toString());
        if ("diff".equals(this.mObjectType)) {
            this.refreshStatusList(this.removePriorVersions(sessionID.getDeleteCandidates()));
        } else if ("categories".equals(this.mObjectType)) {
            this.mNumDeleteCandidates = sessionID.getDeleteCandidates().size();
        } else {
            this.refreshStatusList(null);
        }
    }

    public void cancelDelete() throws RaplixException {
        DeleteSessionID sessionID = new DeleteSessionID(this.mDeleteSessionID);
        sessionID.cancel();
        this.refreshDeleteStatus();
    }

    public void confirmDelete() throws RaplixException {
        DeleteSessionID sessionID = new DeleteSessionID(this.mDeleteSessionID);
        sessionID.confirm();
        this.refreshDeleteStatus();
        this.setDeletePercentageComplete(0.0);
    }

    public boolean anyDeleteFailuresOrWarnings(ServletErrors errors) {
        boolean anyFailure = false;
        for (int i = 0; i < this.mCandidateStatuses.length; ++i) {
            if (this.mCandidateStatuses[i].equals(DeleteSessionCandidateStatus.DELETION_FAILED)) {
                anyFailure = true;
                continue;
            }
            if (!this.mCandidateStatuses[i].equals(DeleteSessionCandidateStatus.COMPLETE_WARNING)) continue;
            errors.addMinorError(this.mCandidateStatusMessages[i], Severity.WARN);
        }
        return anyFailure;
    }

    public String getBreadCrumbAction(String objectType) {
        String breadCrumbAction = "";
        if ("host".equals(objectType)) {
            breadCrumbAction = "/Hosts";
        } else if ("hostType".equals(objectType)) {
            breadCrumbAction = "/HostTypes";
        } else if ("hostset".equals(objectType)) {
            breadCrumbAction = "/HostSets";
        } else if ("hostsearch".equals(objectType)) {
            breadCrumbAction = "/HostSearches";
        } else if ("diff".equals(objectType)) {
            breadCrumbAction = "/Diffs";
        } else if ("usergroup".equals(objectType)) {
            breadCrumbAction = "/UserGroups";
        } else if ("plan".equals(objectType)) {
            breadCrumbAction = "/Plans";
        } else if ("planRunHistory".equals(objectType)) {
            breadCrumbAction = "/Home";
        } else if ("folder".equals(objectType)) {
            breadCrumbAction = "/Folders";
        } else if ("plugin".equals(objectType)) {
            breadCrumbAction = "/Plugins";
        } else if ("component".equals(objectType)) {
            breadCrumbAction = "/Components";
        } else if ("componentType".equals(objectType)) {
            breadCrumbAction = "/ComponentTypes";
        } else if ("systemServices".equals(objectType)) {
            breadCrumbAction = "/Services";
        } else if ("notificationRule".equals(objectType)) {
            breadCrumbAction = "/NotificationRules";
        } else if ("categories".equals(objectType)) {
            breadCrumbAction = "/Categories";
        }
        return breadCrumbAction;
    }

    public String getBreadCrumbTooltip(String objectType) {
        String breadCrumbTooltip = "";
        if ("host".equals(objectType)) {
            breadCrumbTooltip = "View hosts";
        } else if ("hostType".equals(objectType)) {
            breadCrumbTooltip = "View host types";
        } else if ("hostset".equals(objectType)) {
            breadCrumbTooltip = "View host sets";
        } else if ("hostsearch".equals(objectType)) {
            breadCrumbTooltip = "View host searches";
        } else if ("diff".equals(objectType)) {
            breadCrumbTooltip = "View comparisons";
        } else if ("usergroup".equals(objectType)) {
            breadCrumbTooltip = "View user groups";
        } else if ("plan".equals(objectType)) {
            breadCrumbTooltip = "View plans";
        } else if ("planRunHistory".equals(objectType)) {
            breadCrumbTooltip = "View run history";
        } else if ("folder".equals(objectType)) {
            breadCrumbTooltip = "View folders";
        } else if ("plugin".equals(objectType)) {
            breadCrumbTooltip = "View plug-ins";
        } else if ("component".equals(objectType)) {
            breadCrumbTooltip = "View components";
        } else if ("componentType".equals(objectType)) {
            breadCrumbTooltip = "View component types";
        } else if ("systemServices".equals(objectType)) {
            breadCrumbTooltip = "View system services";
        } else if ("notificationRule".equals(objectType)) {
            breadCrumbTooltip = "View notification rules";
        } else if ("categories".equals(objectType)) {
            breadCrumbTooltip = "View categories";
        }
        return breadCrumbTooltip;
    }

    public String getBreadCrumbName(String objectType) {
        String breadCrumbName = "";
        if ("host".equals(objectType)) {
            breadCrumbName = "hosts";
        } else if ("hostType".equals(objectType)) {
            breadCrumbName = "host types";
        } else if ("hostset".equals(objectType)) {
            breadCrumbName = "host sets";
        } else if ("hostsearch".equals(objectType)) {
            breadCrumbName = "host searches";
        } else if ("diff".equals(objectType)) {
            breadCrumbName = "comparisons";
        } else if ("usergroup".equals(objectType)) {
            breadCrumbName = "user groups";
        } else if ("plan".equals(objectType)) {
            breadCrumbName = "plans";
        } else if ("planRunHistory".equals(objectType)) {
            breadCrumbName = "run history";
        } else if ("folder".equals(objectType)) {
            breadCrumbName = "folders";
        } else if ("plugin".equals(objectType)) {
            breadCrumbName = "plug-ins";
        } else if ("component".equals(objectType)) {
            breadCrumbName = "components";
        } else if ("componentType".equals(objectType)) {
            breadCrumbName = "component types";
        } else if ("systemServices".equals(objectType)) {
            breadCrumbName = "system services";
        } else if ("notificationRule".equals(objectType)) {
            breadCrumbName = "notification rules";
        } else if ("categories".equals(objectType)) {
            breadCrumbName = "categories";
        }
        return breadCrumbName;
    }

    public String getSingularSuffix(String objectType) {
        String singularSuffix = "";
        if ("host".equals(objectType)) {
            singularSuffix = "host";
        } else if ("hostType".equals(objectType)) {
            singularSuffix = "host type";
        } else if ("hostset".equals(objectType)) {
            singularSuffix = "host set";
        } else if ("hostsearch".equals(objectType)) {
            singularSuffix = "host search";
        } else if ("diff".equals(objectType)) {
            singularSuffix = "comparison";
        } else if ("usergroup".equals(objectType)) {
            singularSuffix = "user group";
        } else if ("plan".equals(objectType)) {
            singularSuffix = "plan";
        } else if ("planRunHistory".equals(objectType)) {
            singularSuffix = "plan run history";
        } else if ("folder".equals(objectType)) {
            singularSuffix = "folder";
        } else if ("plugin".equals(objectType)) {
            singularSuffix = "plug-in";
        } else if ("component".equals(objectType)) {
            singularSuffix = "component";
        } else if ("componentType".equals(objectType)) {
            singularSuffix = "component type";
        } else if ("systemServices".equals(objectType)) {
            singularSuffix = "system service";
        } else if ("notificationRule".equals(objectType)) {
            singularSuffix = "notification rule";
        } else if ("categories".equals(objectType)) {
            singularSuffix = "category";
        }
        return singularSuffix;
    }

    public String getPluralSuffix(String objectType) {
        String pluralSuffix = "";
        if ("host".equals(objectType)) {
            pluralSuffix = "hosts";
        } else if ("hostType".equals(objectType)) {
            pluralSuffix = "host types";
        } else if ("hostset".equals(objectType)) {
            pluralSuffix = "host sets";
        } else if ("hostsearch".equals(objectType)) {
            pluralSuffix = "host searches";
        } else if ("diff".equals(objectType)) {
            pluralSuffix = "comparisons";
        } else if ("usergroup".equals(objectType)) {
            pluralSuffix = "user groups";
        } else if ("plan".equals(objectType)) {
            pluralSuffix = "plans";
        } else if ("planRunHistory".equals(objectType)) {
            pluralSuffix = "plan run histories";
        } else if ("folder".equals(objectType)) {
            pluralSuffix = "folders";
        } else if ("plugin".equals(objectType)) {
            pluralSuffix = "plug-ins";
        } else if ("component".equals(objectType)) {
            pluralSuffix = "components";
        } else if ("componentType".equals(objectType)) {
            pluralSuffix = "component types";
        } else if ("systemServices".equals(objectType)) {
            pluralSuffix = "system services";
        } else if ("notificationRule".equals(objectType)) {
            pluralSuffix = "notification rules";
        } else if ("categories".equals(objectType)) {
            pluralSuffix = "categories";
        }
        return pluralSuffix;
    }

    public String getHiddenFormAction(String objectType) {
        String hiddenFormAction = "";
        if ("host".equals(objectType)) {
            hiddenFormAction = "/HostDetails";
        } else if ("hostType".equals(objectType)) {
            hiddenFormAction = "/HostTypeDetails";
        } else if ("hostset".equals(objectType)) {
            hiddenFormAction = "/HostSetDetails";
        } else if ("hostsearch".equals(objectType)) {
            hiddenFormAction = "/HostSearchDetails";
        } else if ("diff".equals(objectType)) {
            hiddenFormAction = "/DiffDetails";
        } else if ("usergroup".equals(objectType)) {
            hiddenFormAction = "/UserGroupDetails";
        } else if ("plan".equals(objectType)) {
            hiddenFormAction = "/PlanDetails";
        } else if ("planRunHistory".equals(objectType)) {
            hiddenFormAction = "/PlanRunHistoryDetails";
        } else if ("folder".equals(objectType)) {
            hiddenFormAction = "/FolderDetails";
        } else if ("plugin".equals(objectType)) {
            hiddenFormAction = "/PluginDetails";
        } else if ("component".equals(objectType)) {
            hiddenFormAction = "/ComponentDetails";
        } else if ("componentType".equals(objectType)) {
            hiddenFormAction = "/ComponentTypeDetails";
        } else if ("systemServices".equals(objectType)) {
            hiddenFormAction = "/Services";
        } else if ("notificationRule".equals(objectType)) {
            hiddenFormAction = "/NotificationRules";
        } else if ("categories".equals(objectType)) {
            hiddenFormAction = "/Categories";
        }
        return hiddenFormAction;
    }

    public String[] getHeaderRowLabels(String objectType) {
        String[] headerRowLabels = null;
        if ("host".equals(objectType)) {
            headerRowLabels = new String[]{"host", "ms, ld, ra, virtual", "host type", "OS", "version", "description"};
        } else if ("hostType".equals(objectType)) {
            headerRowLabels = new String[]{"host type", "description"};
        } else if ("hostset".equals(objectType)) {
            headerRowLabels = new String[]{"host set", "description"};
        } else if ("hostsearch".equals(objectType)) {
            headerRowLabels = new String[]{"host search", "description"};
        } else if ("diff".equals(objectType)) {
            headerRowLabels = new String[]{"comparison", "description"};
        } else if ("usergroup".equals(objectType)) {
            headerRowLabels = new String[]{"user group", "description"};
        } else if ("plan".equals(objectType)) {
            headerRowLabels = new String[]{"plan", "version", "description"};
        } else if ("planRunHistory".equals(objectType)) {
            headerRowLabels = new String[]{"plan", "version", "completed"};
        } else if ("folder".equals(objectType)) {
            headerRowLabels = new String[]{"folder", "description"};
        } else if ("plugin".equals(objectType)) {
            headerRowLabels = new String[]{"plug-in", "version", "menu order", "description"};
        } else if ("component".equals(objectType)) {
            headerRowLabels = new String[]{"component", "type", "version", "label", "description"};
        } else if ("componentType".equals(objectType)) {
            headerRowLabels = new String[]{"component type", "menu group", "menu order", "indent", "description", "defining component", "version"};
        } else if ("systemServices".equals(objectType)) {
            headerRowLabels = new String[]{"system service", "description", "defining component", "version"};
        } else if ("notificationRule".equals(objectType)) {
            headerRowLabels = new String[]{"notification rule", "description"};
        } else if ("categories".equals(objectType)) {
            headerRowLabels = new String[]{"category", "description"};
        }
        return headerRowLabels;
    }
}

