/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.DeleteProgressBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.NotRulesBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.UserGroupsBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class DeleteProgressAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_DELETE_FAILED = "error.delete.deleteFailed";
    public static final String MSG_ERROR_DELETE_OBJECT_DELETED = "error.delete.objectDeleted";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = DeleteProgressAction.assertGetParam(request, "mode");
        String objectType = DeleteProgressAction.assertGetParam(request, "objectType");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through DeleteProgressAction:" + mode, this);
        }
        if (mode.equals("delete")) {
            this.handleDelete(request, servletInfo);
        } else if (mode.equals("prepare")) {
            this.handlePrepare(request, servletInfo);
        } else if (mode.equals("deleteprepared")) {
            this.handleDeletePrepared(request, servletInfo);
        } else if (mode.equals("refreshDetails")) {
            this.handleRefreshDetails(request, servletInfo);
        } else if (mode.equals("deleteconfirmed")) {
            this.handleDeleteConfirmed(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("deletenotconfirmed")) {
            this.handleDeleteNotConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
    }

    private void handleDelete(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String[] ids;
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        String mcID = request.getParameter("mcid");
        String sessionID = null;
        boolean allVersions = false;
        if (mcID != null) {
            String allVersionsStr;
            MultiCheckbox in = new MultiCheckbox("bulk", request);
            ids = in.getSelected();
            if (("plan".equals(bean.getObjectType()) || "component".equals(bean.getObjectType())) && (allVersionsStr = request.getParameter("allVersions")) != null && allVersionsStr.equals("true")) {
                allVersions = true;
            }
        } else {
            String objectID = DeleteProgressAction.assertGetParam(request, "id");
            ids = new String[]{objectID};
            if (!"planRunHistory".equals(bean.getObjectType())) {
                bean.setSingleDeleteID(objectID);
            }
        }
        if (ids.length == 0) {
            this.handleList(request, servletInfo, this.getMajorMessageKey(bean.getObjectType()), this.getNoSelectionMessageKey(bean.getObjectType()));
            return;
        }
        sessionID = "plan".equals(bean.getObjectType()) || "component".equals(bean.getObjectType()) ? bean.delete(ids, allVersions) : bean.delete(ids);
        if ("planRunHistory".equals(bean.getObjectType())) {
            bean.setReferrerURL(DeleteProgressAction.assertGetParam(request, "referrerURL"));
        }
        bean.setDeleteSessionID(sessionID);
        bean.setMode("prepare");
        servletInfo.setDestPage("/deleteProgress.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handlePrepare(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        this.setBeanValues(request, bean);
        bean.refreshDeleteStatus();
        if (bean.getDeletePercentageComplete() == 100) {
            this.handleDeletePrepared(request, servletInfo);
            return;
        }
        bean.setMode("prepare");
        servletInfo.setDestPage("/deleteProgress.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleDeletePrepared(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        this.readFromRequest(request, bean);
        this.setBeanValues(request, bean);
        try {
            bean.generateConfirmationList();
            bean.setMode("deleteprepared");
            servletInfo.setDestPage("/deleteConfirm.jsp");
            servletInfo.setSaveInSession(true);
        }
        catch (NoResultsFoundException ex) {
            String majorErrorKey = this.getMajorMessageKey(bean.getObjectType());
            String minorErrorKey = MSG_ERROR_DELETE_OBJECT_DELETED;
            this.handleList(request, servletInfo, majorErrorKey, minorErrorKey);
        }
    }

    private void handleRefreshDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        this.readFromRequest(request, bean);
        this.setBeanValues(request, bean);
        UITree[] trees = bean.getDeleteConfirmTrees();
        String treeID = DeleteProgressAction.assertGetParam(request, "treeID");
        for (int i = 0; i < trees.length; ++i) {
            if (!treeID.equals(trees[i].getID())) continue;
            trees[i].handleRequest(request);
        }
        bean.setMode("deleteprepared");
        servletInfo.setDestPage("/deleteConfirm.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleDeleteConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        this.setBeanValues(request, bean);
        try {
            bean.confirmDelete();
            bean.setMode("refresh");
        }
        catch (RaplixException ex) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorMessageKey(bean.getObjectType()));
            servletInfo.getErrors().addMinorError(ex.getMessage());
            this.handleDeletePrepared(request, servletInfo);
            return;
        }
        servletInfo.setDestPage("/deleteProgress.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        this.setBeanValues(request, bean);
        bean.refreshDeleteStatus();
        if (bean.getDeletePercentageComplete() == 100) {
            String majorErrorKey = null;
            String minorErrorKey = null;
            if (bean.anyDeleteFailuresOrWarnings(servletInfo.getErrors())) {
                majorErrorKey = this.getMajorMessageKey(bean.getObjectType());
                minorErrorKey = MSG_ERROR_DELETE_FAILED;
            }
            this.handleList(request, servletInfo, majorErrorKey, minorErrorKey);
            return;
        }
        bean.setMode("refresh");
        servletInfo.setDestPage("/deleteProgress.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleDeleteNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        String objectType = DeleteProgressAction.assertGetParam(request, "objectType");
        this.setBeanValues(request, bean);
        bean.cancelDelete();
        bean.setMode("deletenotconfirmed");
        if ("categories".equals(objectType)) {
            this.handleList(request, servletInfo);
            return;
        }
        if ("planRunHistory".equals(objectType)) {
            servletInfo.setDestPage(bean.getReferrerURL());
            servletInfo.setShouldRedirect(true);
            return;
        }
        String objectID = bean.getSingleDeleteID();
        String detailsURI = null;
        if (!"".equals(objectID)) {
            block21: {
                try {
                    if ("host".equals(objectType)) {
                        new HostID(objectID).getByIDQuery().selectExists();
                        detailsURI = UriUtil.hostDetailsURI(objectID);
                        break block21;
                    }
                    if ("hostType".equals(objectType)) {
                        new HostTypeID(objectID).getByIDQuery().selectSummaryView();
                        detailsURI = UriUtil.hostTypeEditURI(objectID);
                        break block21;
                    }
                    if ("hostset".equals(objectType)) {
                        new HostSetID(objectID).getByIDQuery().selectSummaryView();
                        detailsURI = UriUtil.hostSetEditURI(objectID);
                        break block21;
                    }
                    if ("hostsearch".equals(objectType)) {
                        new HostSearchID(objectID).getByIDQuery().selectSummaryView();
                        detailsURI = UriUtil.hostSearchEditURI(objectID);
                        break block21;
                    }
                    if ("diff".equals(objectType)) {
                        new DifferenceSettingsID(objectID).getByIDQuery().select();
                        detailsURI = UriUtil.diffDetailsURI(objectID);
                        break block21;
                    }
                    if ("usergroup".equals(objectType)) {
                        UserGroupsBean ugBean = new UserGroupsBean(bean.getUserManager(), bean.getGroupManager(), bean.getPermissionManager());
                        try {
                            ugBean.getGroupManager().getGroup(new GroupID(objectID));
                        }
                        catch (RaplixException re) {
                            this.handleList(request, servletInfo);
                            return;
                        }
                        detailsURI = UriUtil.groupEditURI(objectID);
                        break block21;
                    }
                    if ("plan".equals(objectType)) {
                        new ExecutionPlanID(objectID).getByIDQuery().selectSummaryView();
                        detailsURI = UriUtil.planDetailsURI(objectID);
                        break block21;
                    }
                    if ("folder".equals(objectType)) {
                        new FolderID(objectID).getByIDQuery().selectExists();
                        detailsURI = UriUtil.folderDetailsURI(objectID);
                        break block21;
                    }
                    if ("plugin".equals(objectType)) {
                        new PluginID(objectID).getByIDQuery().selectSummaryView();
                        detailsURI = UriUtil.pluginDetailsURI(objectID);
                        break block21;
                    }
                    if ("component".equals(objectType)) {
                        new ComponentID(objectID).getByIDQuery().selectSummaryView();
                        detailsURI = UriUtil.componentDetailsURI(objectID);
                        break block21;
                    }
                    if ("componentType".equals(objectType)) {
                        new ComponentTypeRefID(objectID).getByIDQuery().selectReadOnlyView();
                        detailsURI = UriUtil.componentTypeDetailsURI(objectID);
                        break block21;
                    }
                    if ("systemServices".equals(objectType)) {
                        new SystemServiceRefID(objectID).getByIDQuery().select();
                        detailsURI = UriUtil.serviceDetailsURI(objectID);
                        break block21;
                    }
                    if (!"notificationRule".equals(objectType)) break block21;
                    NotRulesBean nrBean = new NotRulesBean(bean.getRuleMetaDataManager());
                    try {
                        nrBean.getRuleMetaDataManager().retrieveRule(new RuleID(objectID));
                    }
                    catch (RaplixException re) {
                        this.handleList(request, servletInfo);
                        return;
                    }
                    detailsURI = UriUtil.ruleDetailsURI(objectID);
                }
                catch (NoResultsFoundException nrfe) {
                    this.handleList(request, servletInfo);
                    return;
                }
            }
            servletInfo.setDestPage(detailsURI);
            servletInfo.setShouldRedirect(true);
            return;
        }
        this.handleList(request, servletInfo);
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo, String majorErrorKey, String minorErrorKey) throws RaplixException {
        DeleteProgressBean bean = (DeleteProgressBean)servletInfo.getBean();
        String objectType = DeleteProgressAction.assertGetParam(request, "objectType");
        String listURI = this.getControlPage(objectType) + "?" + "mode" + "=" + "list";
        if (majorErrorKey != null) {
            listURI = listURI + "&majorErrorKey=" + majorErrorKey;
        }
        if (minorErrorKey != null) {
            listURI = listURI + "&minorErrorKey=" + minorErrorKey;
        }
        servletInfo.setDestPage(listURI);
        servletInfo.setShouldRedirect(true);
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        this.handleList(request, servletInfo, null, null);
    }

    private void setBeanValues(HttpServletRequest request, DeleteProgressBean bean) {
        bean.setDeleteSessionID(DeleteProgressAction.assertGetParam(request, "deleteSessionID"));
        if ("planRunHistory".equals(bean.getObjectType())) {
            bean.setReferrerURL(DeleteProgressAction.assertGetParam(request, "referrerURL"));
        } else {
            bean.setSingleDeleteID(DeleteProgressAction.assertGetParam(request, "singleDelete"));
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        DeleteProgressBean bean;
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "list";
        }
        if (mode.equals("refreshDetails")) {
            String id = DeleteProgressAction.assertGetParam(request, "id");
            bean = (DeleteProgressBean)request.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected 'DeleteProgressBean' not found.");
            }
        } else {
            bean = new DeleteProgressBean();
            this.readFromRequest(request, bean);
        }
        return bean;
    }

    private void readFromRequest(HttpServletRequest request, DeleteProgressBean bean) {
        bean.setObjectType(DeleteProgressAction.assertGetParam(request, "objectType"));
        if (bean.getObjectType().equals("usergroup")) {
            bean.setUserManager(DeleteProgressAction.getApplication().getUserManager());
            bean.setGroupManager(DeleteProgressAction.getApplication().getUserGroupManager());
            bean.setPermissionManager(DeleteProgressAction.getApplication().getUserPermissionManager());
        }
        if (bean.getObjectType().equals("notificationRule")) {
            bean.setRuleMetaDataManager(DeleteProgressAction.getApplication().getRuleMetaDataManager());
        }
    }

    private String getNoSelectionMessageKey(String objectType) {
        String msgKey = "";
        if ("host".equals(objectType)) {
            msgKey = "error.hosts.noselection";
        } else if ("hostType".equals(objectType)) {
            msgKey = "error.hostTypes.noselection";
        } else if ("hostset".equals(objectType)) {
            msgKey = "error.hostSets.noselection";
        } else if ("hostsearch".equals(objectType)) {
            msgKey = "error.hostSearches.noselection";
        } else if ("diff".equals(objectType)) {
            msgKey = "error.diffs.noselection";
        } else if ("usergroup".equals(objectType)) {
            msgKey = "error.userGroups.noselection";
        } else if ("plan".equals(objectType)) {
            msgKey = "error.plans.noselection";
        } else if ("planRunHistory".equals(objectType)) {
            msgKey = "error.planrunhistory.noselection";
        } else if ("folder".equals(objectType)) {
            msgKey = "error.folders.noselection";
        } else if ("plugin".equals(objectType)) {
            msgKey = "error.plugins.noselection";
        } else if ("component".equals(objectType)) {
            msgKey = "error.components.noselection";
        } else if ("componentType".equals(objectType)) {
            msgKey = "error.componentTypes.noselection";
        } else if ("systemServices".equals(objectType)) {
            msgKey = "error.services.noselection";
        } else if ("notificationRule".equals(objectType)) {
            msgKey = "error.noteRules.noselection";
        } else if ("categories".equals(objectType)) {
            msgKey = "error.categories.noselection";
        }
        return msgKey;
    }

    private String getControlPage(String objectType) {
        String controlPage = null;
        if ("host".equals(objectType)) {
            controlPage = "/Hosts";
        } else if ("hostType".equals(objectType)) {
            controlPage = "/HostTypes";
        } else if ("hostset".equals(objectType)) {
            controlPage = "/HostSets";
        } else if ("hostsearch".equals(objectType)) {
            controlPage = "/HostSearches";
        } else if ("diff".equals(objectType)) {
            controlPage = "/Diffs";
        } else if ("usergroup".equals(objectType)) {
            controlPage = "/UserGroups";
        } else if ("plan".equals(objectType)) {
            controlPage = "/Plans";
        } else if ("planRunHistory".equals(objectType)) {
            controlPage = "/PlanRunAllPlans";
        } else if ("folder".equals(objectType)) {
            controlPage = "/Folders";
        } else if ("plugin".equals(objectType)) {
            controlPage = "/Plugins";
        } else if ("component".equals(objectType)) {
            controlPage = "/Components";
        } else if ("componentType".equals(objectType)) {
            controlPage = "/ComponentTypes";
        } else if ("systemServices".equals(objectType)) {
            controlPage = "/Services";
        } else if ("notificationRule".equals(objectType)) {
            controlPage = "/NotificationRules";
        } else if ("categories".equals(objectType)) {
            controlPage = "/Categories";
        }
        return controlPage;
    }

    private String getMajorMessageKey(String objectType) {
        String msgKey = "";
        if ("host".equals(objectType)) {
            msgKey = "error.hosts.delete.major";
        } else if ("hostType".equals(objectType)) {
            msgKey = "error.hostTypes.delete.major";
        } else if ("hostset".equals(objectType)) {
            msgKey = "error.hostSets.delete.major";
        } else if ("hostsearch".equals(objectType)) {
            msgKey = "error.hostSearches.delete.major";
        } else if ("diff".equals(objectType)) {
            msgKey = "error.diffs.delete.major";
        } else if ("usergroup".equals(objectType)) {
            msgKey = "error.userGroups.delete.major";
        } else if ("plan".equals(objectType)) {
            msgKey = "error.plans.delete.major";
        } else if ("planRunHistory".equals(objectType)) {
            msgKey = "error.planrunhistory.delete.major";
        } else if ("folder".equals(objectType)) {
            msgKey = "error.folders.delete.major";
        } else if ("plugin".equals(objectType)) {
            msgKey = "error.plugins.delete.major";
        } else if ("component".equals(objectType)) {
            msgKey = "error.components.delete.major";
        } else if ("componentType".equals(objectType)) {
            msgKey = "error.componentTypes.delete.major";
        } else if ("systemServices".equals(objectType)) {
            msgKey = "error.services.delete.major";
        } else if ("notificationRule".equals(objectType)) {
            msgKey = "error.noteRules.delete.major";
        } else if ("categories".equals(objectType)) {
            msgKey = "error.categories.delete";
        }
        return msgKey;
    }

    public String getDefaultPage() {
        return "/deleteConfirm.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = DeleteProgressAction.assertGetParam(inRequest, "mode");
        String objectType = DeleteProgressAction.assertGetParam(inRequest, "objectType");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("getMajorError with mode: " + mode, this);
        }
        if (mode.equals("delete") || mode.equals("prepare") || mode.equals("deleteprepared") || mode.equals("refreshDetails") || mode.equals("deleteconfirmed") || mode.equals("refresh")) {
            return this.getMajorMessageKey(objectType);
        }
        if (mode.equals("deletenotconfirmed")) {
            return "error.delete.deleteNotConfirmed";
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to DeleteProgressAction.");
    }
}

