/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.Util;

public class DeleteConfirmNode
extends UITreeNode {
    private String mContents = "";
    private int mColspan = 1;
    private int mRowLevel = 0;
    private String mVersion = null;
    private String versionKey = "ui.cdb.rsrc.cib.VERSION";

    public DeleteConfirmNode(String message, int criticalityLevel, int colspan) {
        this(message, null, criticalityLevel, colspan);
    }

    public DeleteConfirmNode(String message, String version, int criticalityLevel, int colspan) {
        this.mType = UITreeNodeType.LEAF;
        this.mContents = message;
        this.mColspan = colspan;
        this.mRowLevel = criticalityLevel;
        this.mVersion = version;
    }

    public DeleteConfirmNode(UsingObject blocker, int criticalityLevel, int colspan) {
        this.mType = UITreeNodeType.LEAF;
        this.mContents = Util.getInUseMessage(blocker);
        this.mColspan = colspan;
        this.mRowLevel = criticalityLevel;
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        StringBuffer prologue = new StringBuffer();
        prologue.append("<tr>\n");
        prologue.append(Util.standardCellStart(0, "colspan =\"" + this.mColspan + "\"", this.mRowLevel));
        sb.insert(0, prologue.toString());
        sb.append(this.mContents);
        if (this.mVersion != null) {
            ROXMessage rm = new ROXMessage(this.versionKey);
            sb.append(" " + rm.getMessageString() + " " + this.mVersion);
        }
        sb.append(Util.standardCellEnd());
        sb.append("</tr>");
        return sb.toString();
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

