/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import org.apache.struts.util.MessageResources;

public class DeleteChildrenHelper {
    public static final String PLUGIN_DELETE = "pluginDelete";
    public static final String FOLDER_DELETE = "folderDelete";
    public static final String HOST_DELETE = "hostDelete";
    public static final String HOST_TYPE_DELETE = "hostTypeDelete";
    public static final String HOST_SET_DELETE = "hostSetDelete";
    public static final String HOST_SEARCHES_DELETE = "hostSearchesDelete";
    public static final String DIFF_DELETE = "diffDelete";
    public static final String COMPONENT_DELETE = "componentDelete";
    public static final String PLAN_DELETE = "planDelete";
    public static final String PLAN_RUN_HISTORY_DELETE = "planRunHistoryDelete";
    private static final String MSG_DEP_COMPONENT = "delete.dependent.component";
    private static final String MSG_DEP_COMPONENT_TYPE = "delete.dependent.componentType";
    private static final String MSG_DEP_SYSTEM_SERVICE = "delete.dependent.systemService";
    private static final String MSG_DEP_FOLDER = "delete.dependent.folder";
    private static final String MSG_DEP_PLAN = "delete.dependent.plan";
    private static final String MSG_DEP_AUTOGENPLAN = "delete.dependent.autogenplan";
    private static final String MSG_DEP_HOST = "delete.dependent.host";
    private static final String MSG_DEP_VIRTUALHOST = "delete.dependent.virtualhost";
    private static final String MSG_DEP_HOST_SEARCH = "delete.dependent.hostSearch";
    private static final String MSG_DEP_HOST_SET = "delete.dependent.hostSet";
    private static final String MSG_DEP_HOST_TYPE = "delete.dependent.hostType";
    private static final String MSG_DEP_RUN_HISTORY_RECORD = "delete.dependent.runhistoryrecord";
    private static final String MSG_DEP_RUN_HISTORY_RECORDS = "delete.dependent.runhistoryrecords";
    private MessageResources mMessages = ApplicationResources.getMessageResources();
    private int mNumDeletableRelatedItems = 0;
    private int mDeleteConfirmColspan = 0;
    private UITreeNode mDeleteNode;
    private HasObjectID[] mChildren;
    private String mDeleteContext;
    private String mHeaderMessage;

    public DeleteChildrenHelper(UITreeNode inDeleteNode, int inDeleteConfirmColspan, int inNumDeletableRelatedItems, HasObjectID[] inChildren, String inDeleteContext) {
        this(inDeleteNode, inDeleteConfirmColspan, inNumDeletableRelatedItems, inChildren, inDeleteContext, null);
    }

    public DeleteChildrenHelper(UITreeNode inDeleteNode, int inDeleteConfirmColspan, int inNumDeletableRelatedItems, HasObjectID[] inChildren, String inDeleteContext, String headerMessage) {
        this.mDeleteNode = inDeleteNode;
        this.mDeleteConfirmColspan = inDeleteConfirmColspan;
        this.mNumDeletableRelatedItems = inNumDeletableRelatedItems;
        this.mChildren = inChildren;
        this.mDeleteContext = inDeleteContext;
        this.mHeaderMessage = headerMessage;
        this.processChildren();
    }

    private void processChildren() {
        if (this.mHeaderMessage != null) {
            DeleteConfirmNode headerNode = new DeleteConfirmNode(this.mHeaderMessage, 0, this.mDeleteConfirmColspan);
            this.mDeleteNode.addChild(headerNode);
            this.mDeleteNode = headerNode;
        }
        int numRunHistoryRecords = 0;
        for (int j = 0; j < this.mChildren.length; ++j) {
            String name;
            ObjectID childID = this.mChildren[j].getObjectID();
            String msg = "";
            String version = null;
            if (childID instanceof ComponentID) {
                name = ((SummaryComponent)this.mChildren[j]).getFullName();
                msg = this.mMessages.getMessage(MSG_DEP_COMPONENT, (Object)name);
                version = ((SummaryComponent)this.mChildren[j]).getVersionNumber().getAsString();
            } else if (childID instanceof ExecutionPlanID) {
                name = ((SummaryExecutionPlan)this.mChildren[j]).getFullName();
                version = ((SummaryExecutionPlan)this.mChildren[j]).getVersionNumber().getAsString();
                msg = this.mDeleteContext.equals(COMPONENT_DELETE) ? this.mMessages.getMessage(MSG_DEP_AUTOGENPLAN, (Object)name) : this.mMessages.getMessage(MSG_DEP_PLAN, (Object)name);
            } else if (childID instanceof FolderID) {
                name = ((SummaryFolder)this.mChildren[j]).getFullPathString();
                msg = this.mMessages.getMessage(MSG_DEP_FOLDER, (Object)name);
            } else if (childID instanceof HostID) {
                name = ((SummaryHost)this.mChildren[j]).getName();
                msg = this.mDeleteContext.equals(HOST_DELETE) ? this.mMessages.getMessage(MSG_DEP_VIRTUALHOST, (Object)name) : this.mMessages.getMessage(MSG_DEP_HOST, (Object)name);
            } else if (childID instanceof HostSetID) {
                name = ((SummaryHostSet)this.mChildren[j]).getName();
                msg = this.mMessages.getMessage(MSG_DEP_HOST_SET, (Object)name);
            } else if (childID instanceof HostSearchID) {
                name = ((SummaryHostSearch)this.mChildren[j]).getName();
                msg = this.mMessages.getMessage(MSG_DEP_HOST_SEARCH, (Object)name);
            } else if (childID instanceof HostTypeID) {
                name = ((SummaryHostType)this.mChildren[j]).getName();
                msg = this.mMessages.getMessage(MSG_DEP_HOST_TYPE, (Object)name);
            } else if (childID instanceof ComponentTypeRefID) {
                name = ((ComponentTypeRef)this.mChildren[j]).getName();
                msg = this.mMessages.getMessage(MSG_DEP_COMPONENT_TYPE, (Object)name);
            } else if (childID instanceof SystemServiceRefID) {
                name = ((SystemServiceRef)this.mChildren[j]).getName();
                msg = this.mMessages.getMessage(MSG_DEP_SYSTEM_SERVICE, (Object)name);
            }
            if (msg.equals("")) {
                if (childID instanceof TaskID) {
                    ++numRunHistoryRecords;
                    ++this.mNumDeletableRelatedItems;
                    continue;
                }
                if (!(this.mChildren[j] instanceof UsingObject)) continue;
                ++this.mNumDeletableRelatedItems;
                continue;
            }
            DeleteConfirmNode node = new DeleteConfirmNode(msg, version, 0, this.mDeleteConfirmColspan);
            this.mDeleteNode.addChild(node);
            ++this.mNumDeletableRelatedItems;
        }
        if (numRunHistoryRecords > 0) {
            String depMsg = this.mMessages.getMessage(MSG_DEP_RUN_HISTORY_RECORD, (Object)(numRunHistoryRecords + ""));
            if (numRunHistoryRecords > 1) {
                depMsg = this.mMessages.getMessage(MSG_DEP_RUN_HISTORY_RECORDS, (Object)(numRunHistoryRecords + ""));
            }
            DeleteConfirmNode node = new DeleteConfirmNode(depMsg, 0, this.mDeleteConfirmColspan);
            this.mDeleteNode.addChild(node);
        }
    }

    public int getNumDeletableRelatedItems() {
        return this.mNumDeletableRelatedItems;
    }
}

