/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.IIDifferencePath;
import com.raplix.rolloutexpress.difference.MIDifferencePath;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.data.DiffResultsObject;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import java.util.StringTokenizer;

public class ComparisonUtils {
    private static final String PATH_SEPARATOR = ":";
    private static final char SV_SEPARATOR = '|';
    private static final char SV_ENCAPSULATOR = '\"';
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";

    public static String differenceSettingsToPSV(DifferenceSettings ds, InstallDBManager installDB) throws RaplixException {
        SummaryHost host;
        int type = ds.getDiffStyle();
        int scope = ds.getDiffScope();
        String typestring = null;
        String scopestring = null;
        String reference = null;
        String comparison = null;
        if (type == 0) {
            typestring = ApplicationResources.getMessage("label.diffs.style.model2model");
            scopestring = "";
            reference = HostsBean.getSummaryHostByID(ds.getSrcHostID()).getName();
            comparison = HostsBean.getSummaryHostByID(ds.getDstHostID()).getName();
        } else if (type == 1) {
            typestring = ApplicationResources.getMessage("label.diffs.style.model2install");
            if (scope == 3) {
                scopestring = "Host Set";
                reference = HostSetsBean.getSummaryHostSetByID(ds.getDstHostSetID()).getName();
                comparison = "";
            } else if (scope == 2) {
                scopestring = "Host";
                host = HostsBean.getSummaryHostByID(ds.getDstHostID());
                reference = host.getName() + PATH_SEPARATOR + ds.getSrcDir();
                comparison = "";
            } else if (scope == 0) {
                scopestring = "Component";
                InstalledComponent ic = ds.getInstalledComponentID().getByIDQuery().select();
                Component component = ic.getComponentID().getByIDQuery().select();
                SummaryHost host2 = HostsBean.getSummaryHostByID(ds.getSrcHostID());
                reference = component.getName() + PATH_SEPARATOR + ic.getInstallPath();
                comparison = host2.getName();
            } else {
                scopestring = "Undefined";
                reference = "Undefined";
                comparison = "Undefined";
            }
        } else if (type == 2) {
            typestring = ApplicationResources.getMessage("label.diffs.style.install2install");
            scopestring = "";
            host = HostsBean.getSummaryHostByID(ds.getSrcHostID());
            reference = host.getName() + PATH_SEPARATOR + ds.getSrcDir();
            host = HostsBean.getSummaryHostByID(ds.getDstHostID());
            comparison = host.getName() + PATH_SEPARATOR + ds.getDstDir();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ComparisonUtils.makeSVline(new String[]{"comparison", ds.getName()}));
        sb.append(ComparisonUtils.makeSVline(new String[]{"description", ds.getDescription()}));
        sb.append(ComparisonUtils.makeSVline(new String[]{"style of comparison", typestring}));
        sb.append(ComparisonUtils.makeSVline(new String[]{"scope", scopestring}));
        sb.append(ComparisonUtils.makeSVline(new String[]{"reference", reference}));
        sb.append(ComparisonUtils.makeSVline(new String[]{"comparison", comparison}));
        return sb.toString();
    }

    public static String differenceStatusToPSV() {
        return "";
    }

    public static String differenceHeaderToPSV(ROXEvent[] evs) {
        int numDiffs = 0;
        for (int i = 0; i < evs.length; ++i) {
            numDiffs += DiffResultsObject.getDiffSize((ROXDifferenceFoundEvent)evs[i]);
        }
        return ComparisonUtils.makeSVline(new String[]{"differences", "" + numDiffs});
    }

    public static String differenceHeadingToPSV() {
        return ComparisonUtils.makeSVline(new String[]{""}) + ComparisonUtils.makeSVline(new String[]{"type", "reference path", "reference file", "reference contents", "comparison path", "comparison file", "comparison contents"});
    }

    public static String differenceToPSV(ROXEvent evs, DifferenceSettings ds, InstallDBManager installDB) throws RaplixException {
        ROXDifferenceFoundEvent ev = (ROXDifferenceFoundEvent)evs;
        Difference diff = ev.getDifference();
        String diffMsg = "";
        String path = "";
        String file = "";
        switch (ds.getDiffStyle()) {
            case 0: {
                path = "";
                file = "";
                break;
            }
            case 1: {
                MIDifferencePath midp = new MIDifferencePath();
                midp.inflate(ev.getDifferencePath());
                path = midp.getHostName() + PATH_SEPARATOR + midp.getComponentName();
                file = midp.getFilePath();
                if (midp.getDisplayName() == null) break;
                file = midp.getDisplayName();
                break;
            }
            case 2: {
                IIDifferencePath iidp = new IIDifferencePath();
                iidp.inflate(ev.getDifferencePath());
                path = "";
                file = iidp.getFilePath();
            }
        }
        String srcPathString = path;
        String srcFileString = file;
        String srcString = diff.getSourceVal();
        String dstPathString = path;
        String dstFileString = file;
        String dstString = diff.getDestVal();
        switch (diff.getType()) {
            case 400: {
                diffMsg = "module not loaded";
                break;
            }
            case 401: {
                diffMsg = "module locations differ";
                break;
            }
            case 402: {
                diffMsg = "directive missing";
                break;
            }
            case 403: {
                diffMsg = "directive mismatch";
                break;
            }
            case 404: {
                diffMsg = "configuration group missing";
                break;
            }
            case 405: {
                diffMsg = "group directive missing";
                break;
            }
            case 406: {
                diffMsg = "group directive mismatch";
                break;
            }
            case 300: {
                diffMsg = "files are different lengths";
                break;
            }
            case 301: {
                diffMsg = "file binaries are different";
                srcString = "first changed byte: #" + diff.getSourceOrder();
                break;
            }
            case 302: {
                diffMsg = "file lengths and binaries are different";
                srcString = "first changed byte: #" + diff.getSourceOrder();
                break;
            }
            case 500: {
                if (diff.getSourceVal() == null) {
                    diffMsg = diff.getIdentifier() + ": missing from source";
                    srcString = "(#" + diff.getDestOrder() + ")";
                    break;
                }
                if (diff.getDestVal() == null) {
                    diffMsg = diff.getIdentifier() + ": missing from destination";
                    dstString = "(#" + diff.getSourceOrder() + ")";
                    break;
                }
                diffMsg = diff.getIdentifier() + " differs";
                srcString = "(#" + diff.getSourceOrder() + ")";
                dstString = "(#" + diff.getDestOrder() + ")";
                break;
            }
            case 0: {
                diffMsg = "file missing";
                break;
            }
            case 9: {
                diffMsg = "symbolic link missing";
                break;
            }
            case 1: {
                diffMsg = "directory missing";
                break;
            }
            case 2: {
                diffMsg = "file sizes are different";
                srcString = "" + diff.getSourceOrder();
                dstString = "" + diff.getDestOrder();
                break;
            }
            case 10: {
                diffMsg = "symbolic links point to different files or directories";
                break;
            }
            case 4: {
                if (diff.getSourceVal() != null) {
                    diffMsg = "component missing at source path in destination";
                    srcString = ComparisonUtils.installedComponentToString(diff.getSourceVal(), installDB);
                    srcPathString = ComparisonUtils.installedComponentToPath(diff.getSourceVal(), installDB);
                    break;
                }
                diffMsg = "component missing at destination path in source";
                dstString = ComparisonUtils.installedComponentToString(diff.getDestVal(), installDB);
                dstPathString = ComparisonUtils.installedComponentToPath(diff.getDestVal(), installDB);
                break;
            }
            case 3: {
                if (diff.getSourceVal() != null) {
                    diffMsg = "component missing from destination";
                    srcString = ComparisonUtils.installedComponentToString(diff.getSourceVal(), installDB);
                    srcPathString = ComparisonUtils.installedComponentToPath(diff.getSourceVal(), installDB);
                    break;
                }
                diffMsg = "component missing from source";
                dstString = ComparisonUtils.installedComponentToString(diff.getDestVal(), installDB);
                dstPathString = ComparisonUtils.installedComponentToPath(diff.getDestVal(), installDB);
                break;
            }
            case 5: {
                diffMsg = "component version mismatch";
                srcString = ComparisonUtils.installedComponentToString(diff.getSourceVal(), installDB);
                srcPathString = ComparisonUtils.installedComponentToPath(diff.getSourceVal(), installDB);
                dstString = ComparisonUtils.installedComponentToString(diff.getDestVal(), installDB);
                dstPathString = ComparisonUtils.installedComponentToPath(diff.getDestVal(), installDB);
                break;
            }
            case 7: {
                diffMsg = "component ownership changed";
                srcString = ComparisonUtils.installedComponentToString(diff.getSourceVal(), installDB);
                srcPathString = ComparisonUtils.installedComponentToPath(diff.getSourceVal(), installDB);
                dstString = ComparisonUtils.installedComponentsToString(diff.getDestVal(), installDB);
                dstPathString = ComparisonUtils.installedComponentsToPath(diff.getDestVal(), installDB);
                break;
            }
            case 6: {
                diffMsg = "text file differences";
                break;
            }
            case 8: {
                diffMsg = "text file differences";
                break;
            }
            case 200: {
                diffMsg = "key missing";
                break;
            }
            case 201: {
                diffMsg = "missing values for key";
                break;
            }
            case 202: {
                diffMsg = "value type mismatch (String vs. List) on key: " + diff.getSourceVal();
                break;
            }
            case 203: {
                diffMsg = "value mismatch";
                break;
            }
            case 600: {
                if (diff.getSourceVal() == null) {
                    diffMsg = diff.getIdentifier() + ": missing from source";
                    break;
                }
                if (diff.getDestVal() == null) {
                    diffMsg = diff.getIdentifier() + ": missing from destination";
                    break;
                }
                diffMsg = diff.getIdentifier() + " differs";
                break;
            }
            case 100: {
                diffMsg = "attribute missing";
                break;
            }
            case 101: {
                diffMsg = "attribute mismatch";
                break;
            }
            case 102: {
                diffMsg = "node missing";
                break;
            }
            case 103: {
                diffMsg = "different node names";
                break;
            }
            case 104: {
                diffMsg = "different node types";
                break;
            }
            case 105: {
                diffMsg = "different node values";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + diff.getType());
            }
        }
        return ComparisonUtils.makeSVline(new String[]{diffMsg, srcPathString, srcFileString, srcString, dstPathString, dstFileString, dstString});
    }

    private static String installedComponentToString(String icID, InstallDBManager installDB) throws RaplixException {
        InstalledComponent ic = new InstalledComponentID(icID).getByIDQuery().select();
        Component comp = ic.getComponentID().getByIDQuery().select();
        return comp.getName() + " " + comp.getVersionNumber().getAsString();
    }

    private static String installedComponentsToString(String icIDs, InstallDBManager installDB) throws RaplixException {
        StringTokenizer st = new StringTokenizer(icIDs, COMMA_SEPARATOR);
        StringBuffer buildList = new StringBuffer("");
        while (st.hasMoreTokens()) {
            String icID = st.nextToken();
            String build = ComparisonUtils.installedComponentToString(icID, installDB);
            buildList.append(build);
            if (!st.hasMoreTokens()) continue;
            buildList.append(SEMICOLON_SEPARATOR);
        }
        return buildList.toString();
    }

    private static String installedComponentToPath(String icID, InstallDBManager installDB) throws RaplixException {
        InstalledComponent ic = new InstalledComponentID(icID).getByIDQuery().select();
        return ic.getInstallPath();
    }

    private static String installedComponentsToPath(String icIDs, InstallDBManager installDB) throws RaplixException {
        StringTokenizer st = new StringTokenizer(icIDs, COMMA_SEPARATOR);
        StringBuffer pathList = new StringBuffer("");
        while (st.hasMoreTokens()) {
            String icID = st.nextToken();
            String build = ComparisonUtils.installedComponentToPath(icID, installDB);
            pathList.append(build);
            if (!st.hasMoreTokens()) continue;
            pathList.append(SEMICOLON_SEPARATOR);
        }
        return pathList.toString();
    }

    public static String differenceResultsToPSV(ROXEvent[] evs, DifferenceSettings ds, InstallDBManager installDB) throws RaplixException {
        StringBuffer sb = new StringBuffer();
        sb.append(ComparisonUtils.differenceSettingsToPSV(ds, installDB));
        sb.append(ComparisonUtils.differenceStatusToPSV());
        sb.append(ComparisonUtils.differenceHeaderToPSV(evs));
        sb.append(ComparisonUtils.differenceHeadingToPSV());
        for (int i = 0; i < evs.length; ++i) {
            sb.append(ComparisonUtils.differenceToPSV(evs[i], ds, installDB));
        }
        if (evs.length == 0) {
            sb.append(ComparisonUtils.makeSVline(new String[]{"No differences found"}));
        }
        return sb.toString();
    }

    private static String makeSVline(String[] strings) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            buf.append(ComparisonUtils.escapeSVstring(strings[i]));
            if (i >= strings.length - 1) continue;
            buf.append('|');
        }
        buf.append("\r\n");
        return buf.toString();
    }

    private static String escapeSVstring(String in) {
        if (in == null) {
            in = "";
        }
        StringBuffer sb = new StringBuffer(in);
        boolean requiresEncapsulation = false;
        for (int i = 0; i < sb.length(); ++i) {
            char j = sb.charAt(i);
            if (j == '\"' || j == '|') {
                requiresEncapsulation = true;
            }
            if (j == '\"') {
                sb.insert(i++, '\"');
            }
            if (j == '\r') {
                sb.setCharAt(i, ' ');
                requiresEncapsulation = true;
            }
            if (j != '\n') continue;
            sb.setCharAt(i, ' ');
            requiresEncapsulation = true;
        }
        if (requiresEncapsulation) {
            sb.insert(0, '\"');
            sb.append('\"');
        }
        return sb.toString();
    }
}

