/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.ui.web.ComparisonUtils;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComparisonDownloadAction
extends LoggedOnServlet {
    public static final String MSG_ERROR = "error.diffs.list";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block4: {
            DifferenceDBInterface diffDB = ComparisonDownloadAction.getApplication().getDifferenceDBInterface();
            InstallDBManager installDB = ComparisonDownloadAction.getApplication().getInstallDBManager();
            try {
                String mode = ComparisonDownloadAction.assertGetParam(request, "mode");
                String jobsid = ComparisonDownloadAction.assertGetParam(request, "diffjobsid");
                ROXDifferenceFoundEvent dfe = new ROXDifferenceFoundEvent();
                dfe.setDifferenceJobID(new DifferenceJobID(jobsid));
                ROXEvent[] evs = this.singlePrototypeNotificationQuery(dfe);
                DifferenceSettings ds = diffDB.getDifferenceSettings(new DifferenceSettingsID(this.getSettingIDFromJobID(jobsid)));
                if (mode.equals("filenameaddeddownload")) {
                    response.setContentType("application/octet-stream; charset=UTF-8");
                    PrintWriter out = new PrintWriter(response.getWriter());
                    String psvfile = ComparisonUtils.differenceResultsToPSV(evs, ds, installDB);
                    out.print(psvfile);
                    break block4;
                }
                if (mode.equals("download")) {
                    String url = "/ComparisonDownload/" + Util.encodeURL(ds.getName()) + ".psv?mode=" + "filenameaddeddownload" + "&" + "diffjobsid" + "=" + jobsid;
                    response.sendRedirect(url);
                    break block4;
                }
                throw new RaplixException(new IllegalArgumentException("Invalid mode passed to ComparisonDownload."));
            }
            catch (RaplixException e) {
                ServletErrors errors = new ServletErrors();
                Logger.debug("Exception caught in ComparisonDownload: " + e.getMessage(), e, this);
                errors.setMajorErrorKey("error.comparison.download");
                errors.addMinorError(e.getMessage());
                request.setAttribute("session.errormessage", (Object)errors);
                this.forwardRequest(request, response, "/errorhome.jsp");
            }
        }
    }

    private String getSettingIDFromJobID(String jobID) throws RaplixException {
        ROXDifferenceStartEvent startedEventProto = new ROXDifferenceStartEvent();
        startedEventProto.setDifferenceJobID(new DifferenceJobID(jobID));
        ROXEvent[] startedEventArray = this.singlePrototypeNotificationQuery(startedEventProto);
        if (startedEventArray.length == 0) {
            return null;
        }
        ROXDifferenceStartEvent startedEvent = (ROXDifferenceStartEvent)startedEventArray[0];
        return startedEvent.getDifferenceSettingsID().toString();
    }

    private ROXEvent[] singlePrototypeNotificationQuery(ROXEvent inEvent) throws RaplixException {
        NotificationRPCInterface notMan = ComparisonDownloadAction.getApplication().getNotificationInterface();
        Vector<ROXEvent> prototypes = new Vector<ROXEvent>();
        prototypes.add(inEvent);
        try {
            Vector matchingEvents = notMan.query(prototypes);
            return matchingEvents.toArray(new ROXEvent[0]);
        }
        catch (EmptyQueryException e) {
            return new ROXEvent[0];
        }
    }

    public String getMajorError(HttpServletRequest inRequest) {
        return MSG_ERROR;
    }
}

