/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.CachedFolderTreeNode;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UIFolderNode;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChangePathBean
extends ServletBean {
    private String mFilePath = "/";
    private String mOriginalPath = "/";
    private String mFolderID = FolderID.ROOT_FOLDER_ID.toString();
    private boolean mCloseWindow = false;
    private UITree mTree = null;
    private String mLaunchMode = "navigate";
    private String mObjectType = "folders";

    public boolean getCloseWindow() {
        return this.mCloseWindow;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public String getOriginalPath() {
        return this.mOriginalPath;
    }

    public String getFolderID() {
        return this.mFolderID;
    }

    public UITree getTree() {
        return this.mTree;
    }

    public String getLaunchMode() {
        return this.mLaunchMode;
    }

    public String getObjectType() {
        return this.mObjectType;
    }

    public void setCloseWindow(boolean closeWindow) {
        this.mCloseWindow = closeWindow;
    }

    public void setFilePath(String filePath) {
        this.mFilePath = filePath;
    }

    public void setOriginalPath(String originalPath) {
        this.mOriginalPath = originalPath;
    }

    public void setFolderID(String folderID) {
        this.mFolderID = folderID;
    }

    public void setTree(UITree tree) {
        this.mTree = tree;
    }

    public void setLaunchMode(String launchMode) {
        this.mLaunchMode = launchMode;
    }

    public void setObjectType(String objectType) {
        this.mObjectType = objectType;
    }

    protected static UIFolderNode verifyNode(UIFolderNode checkNode) {
        while (!checkNode.toString().equals("/")) {
            if (ChangePathBean.testOneFolder(checkNode.toString())) {
                return checkNode;
            }
            checkNode = checkNode.getParent();
        }
        return checkNode;
    }

    public static String verifyFilePath(String filePath) {
        boolean openSuccess = true;
        StringBuffer testFolder = new StringBuffer("");
        String cumulativeFilePath = "/";
        StringTokenizer st = new StringTokenizer(filePath, "/", true);
        while (st.hasMoreTokens() && openSuccess) {
            String oneToken = st.nextToken();
            testFolder.append(oneToken);
            if (!oneToken.equals("/")) continue;
            if (ChangePathBean.testOneFolder(testFolder.toString())) {
                cumulativeFilePath = testFolder.toString();
                continue;
            }
            openSuccess = false;
        }
        return cumulativeFilePath;
    }

    public static String verifyFolderID(String folderID) {
        FolderID cumulativeFolderID;
        block3: {
            cumulativeFolderID = FolderID.ROOT_FOLDER_ID;
            try {
                if (new FolderID(folderID).getByIDQuery().selectExists()) {
                    cumulativeFolderID = new FolderID(folderID);
                }
            }
            catch (RaplixException ex) {
                if (!Logger.isDebugEnabled(ChangePathBean.class)) break block3;
                Logger.debug("*** verifyFolderID ***", ChangePathBean.class);
                Logger.debug("folderID: " + folderID + " not found", ChangePathBean.class);
            }
        }
        return cumulativeFolderID.toString();
    }

    protected static boolean testOneFolder(String folderPath) {
        boolean exists = false;
        try {
            if (SingleFolderQuery.byPath(folderPath).selectExists()) {
                exists = true;
            }
        }
        catch (PersistenceManagerException e) {
            exists = false;
        }
        catch (RPCException e) {
            exists = false;
        }
        return exists;
    }

    protected static String filePathToTreePath(String filePath) throws RaplixException {
        StringBuffer treePath = new StringBuffer(UITree.PATH_ROOT_STRING);
        String[] pathPieces = StringUtil.split(filePath, "/", "");
        CachedFolderTreeNode folder = new CachedFolderTreeNode(FolderID.ROOT_FOLDER_ID.getByIDQuery().selectSummaryView());
        folder.retrieveChildren();
        for (int i = 0; i < pathPieces.length; ++i) {
            String onePath = pathPieces[i];
            if (onePath.equals("")) continue;
            CachedFolderTreeNode[] children = folder.getChildren();
            for (int j = 0; j < children.length; ++j) {
                if (!children[j].getFolder().getName().equals(onePath)) continue;
                folder = children[j];
                treePath.append(UITree.PATH_SEPARATOR_STRING + j);
            }
        }
        return treePath.toString();
    }

    public static String folderIDtoFilePath(String folderID) throws RaplixException {
        return new FolderID(folderID).getByIDQuery().selectSummaryView().getFullPathString();
    }

    public static String filePathToFolderID(String filePath) throws RaplixException {
        if (filePath == null || filePath.equals("/")) {
            return FolderID.ROOT_FOLDER_ID.toString();
        }
        return SingleFolderQuery.byPath(filePath).selectSummaryView().getID().toString();
    }

    public static String[] getFolderPathIDs(FolderID folderID) throws RaplixException {
        Vector<String> folderIDList = new Vector<String>();
        while (!folderID.equals(FolderID.ROOT_FOLDER_ID)) {
            folderIDList.add(folderID.toString());
            folderID = folderID.getByIDQuery().selectSummaryView().getParentFolderID();
        }
        folderIDList.add(FolderID.ROOT_FOLDER_ID.toString());
        Collections.reverse(folderIDList);
        return folderIDList.toArray(new String[0]);
    }

    public static String[] getFolderPathNames(FolderID folderID) throws RaplixException {
        Vector<String> folderNameList = new Vector<String>();
        while (!folderID.equals(FolderID.ROOT_FOLDER_ID)) {
            SummaryFolder folder = folderID.getByIDQuery().selectSummaryView();
            String folderName = folder.getName();
            folderNameList.add(folderName);
            folderID = folder.getParentFolderID();
        }
        folderNameList.add("[top]");
        Collections.reverse(folderNameList);
        return folderNameList.toArray(new String[0]);
    }
}

