/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UIFolderNode;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ChangePathAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String FILE_PATH_PREFIX = "[top]";
    public static final String MSG_PATH_ERROR = "error.changePath.badPath";
    public static final String MSG_PATH_NOT_EXISTS_ERROR = "error.changePath.notExists";
    public static final String MSG_ERROR_LIST = "error.changePath.list";
    public static final String MSG_ERROR_APPLY = "error.changePath.applyPath";

    public static void updatePathAndView(HttpServletRequest request) {
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        spb.trackString(Preference.FILE_PATH, request);
        spb.trackBoolean(Preference.FLAT_VIEW, request);
    }

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = ChangePathAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ChangePathAction:" + mode, this);
        }
        if (mode.equals("init")) {
            this.handleInit(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("changepath")) {
            this.handleAttemptClose(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
    }

    private void handleAttemptClose(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String displayFilePath;
        ChangePathBean cpb = (ChangePathBean)servletInfo.getBean();
        this.readFromRequest(request, cpb);
        String attemptedFilePath = displayFilePath = ChangePathAction.assertGetParam(request, "filePathText");
        if (!attemptedFilePath.endsWith("/")) {
            attemptedFilePath = attemptedFilePath + "/";
        }
        String actualFilePath = ChangePathBean.verifyFilePath(attemptedFilePath);
        String folderID = ChangePathBean.filePathToFolderID(actualFilePath);
        cpb.setFilePath(actualFilePath);
        cpb.setFolderID(folderID);
        if (actualFilePath.equals(attemptedFilePath)) {
            cpb.setCloseWindow(true);
        } else {
            servletInfo.getErrors().setMajorErrorKey(MSG_PATH_ERROR);
            servletInfo.getErrors().addMinorErrorKey(MSG_PATH_NOT_EXISTS_ERROR, Util.preserveSpace(displayFilePath));
            UITree tree = cpb.getTree();
            UIFolderNode root = (UIFolderNode)tree.getRoot();
            root.remakeTree();
            String treePath = ChangePathBean.filePathToTreePath(cpb.getFilePath());
            tree.fullExpandPath(treePath);
            UITreeNode markNode = tree.findNode(treePath);
            tree.setMarkedNode(markNode);
        }
        servletInfo.setDestPage("/changePath.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleInit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ChangePathBean cpb = (ChangePathBean)servletInfo.getBean();
        this.readFromRequest(request, cpb);
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.trackString(Preference.FILE_PATH, request);
        String filePath = ChangePathBean.folderIDtoFilePath(folderID);
        cpb.setFilePath(filePath);
        cpb.setOriginalPath(filePath);
        cpb.setFolderID(folderID);
        String treePath = ChangePathBean.filePathToTreePath(cpb.getFilePath());
        UITree tree = new UITree();
        UIFolderNode root = new UIFolderNode(UITreeNodeType.BRANCH_CLOSED, FolderID.ROOT_FOLDER_ID);
        tree.setRoot(root);
        root.remakeTree();
        tree.fullExpandPath(treePath);
        UITreeNode markNode = tree.findNode(treePath);
        tree.setMarkedNode(markNode);
        request.getSession().setAttribute("session.foldertree.id", (Object)tree);
        cpb.setTree(tree);
        servletInfo.setDestPage("/changePath.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        boolean nodeError;
        ChangePathBean cpb = (ChangePathBean)servletInfo.getBean();
        this.readFromRequest(request, cpb);
        UITree tree = cpb.getTree();
        String filePath = ChangePathAction.assertGetParam(request, "filePathText");
        String treePath = ChangePathAction.assertGetParam(request, "treePath");
        String treeAction = ChangePathAction.assertGetParam(request, "treeAction");
        UIFolderNode actionNode = (UIFolderNode)tree.findNode(treePath);
        UIFolderNode actualNode = ChangePathBean.verifyNode(actionNode);
        boolean bl = nodeError = actualNode != actionNode;
        if (nodeError) {
            servletInfo.getErrors().setMajorErrorKey(MSG_PATH_ERROR);
            servletInfo.getErrors().addMinorErrorKey(MSG_PATH_NOT_EXISTS_ERROR, actionNode.toString());
        }
        if ((treeAction.equals("open") || treeAction.equals("close")) && !nodeError) {
            tree.handleRequest(request);
        } else if (treeAction.equals("select")) {
            filePath = actualNode.toString();
            tree.setMarkedNode(actualNode);
        }
        cpb.setFilePath(filePath);
        ((UIFolderNode)tree.getRoot()).remakeTree();
        servletInfo.setDestPage("/changePath.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void readFromRequest(HttpServletRequest request, ChangePathBean cpb) {
        cpb.setLaunchMode(ChangePathAction.assertGetParam(request, "launchMode"));
        cpb.setObjectType(ChangePathAction.assertGetParam(request, "objectType"));
        if (request.getParameter("originalPath") != null) {
            cpb.setOriginalPath(request.getParameter("originalPath"));
        }
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = ChangePathAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("ChangePathAction::getMajorError with mode: " + mode, this);
        }
        if (mode.equals("init") || mode.equals("refresh")) {
            return MSG_ERROR_LIST;
        }
        if (mode.equals("changepath")) {
            return MSG_ERROR_APPLY;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to ComponentsAction.");
    }

    public String getDefaultPage() {
        return "/changePath.jsp";
    }

    public ServletBean createBean(HttpServletRequest request) {
        ChangePathBean cpb = new ChangePathBean();
        HttpSession session = request.getSession();
        UITree tree = (UITree)session.getAttribute("session.foldertree.id");
        if (tree != null) {
            cpb.setTree(tree);
        }
        return cpb;
    }

    protected boolean isPopup(HttpServletRequest request) {
        return true;
    }
}

