/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ROXServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ChangePasswordAction
extends ROXServlet {
    public static final String MSG_ERROR_MAJOR = "error.changePassword.major";
    public static final String MSG_ERROR_BAD_NEW_PASSWORD = "error.changePassword.badNewPassword";
    public static final String MSG_ERROR_BAD_CONFIRM_PASSWORD = "error.changePassword.badConfirmPassword";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletErrors errors = new ServletErrors();
        try {
            String login = request.getParameter("login");
            if (login == null) {
                Logger.debug("login is null, forwarding to: /changePassword.jsp", this);
                this.forwardRequest(request, response, "/changePassword.jsp");
                return;
            }
            String password = ChangePasswordAction.assertGetParam(request, "currentpassword1");
            String newPassword1 = ChangePasswordAction.assertGetParam(request, "newpassword1");
            String newPassword2 = ChangePasswordAction.assertGetParam(request, "newpassword2");
            SessionManager sessionManager = ChangePasswordAction.getApplication().getUserSessionManager();
            UserManager userMgr = ChangePasswordAction.getApplication().getUserManager();
            if (newPassword1.equals("") || !newPassword1.equals(newPassword2)) {
                Logger.debug("Login failed, new password not confirmed", this);
                errors.setMajorErrorKey(MSG_ERROR_MAJOR);
                if (newPassword1.equals("")) {
                    errors.addMinorErrorKey(MSG_ERROR_BAD_NEW_PASSWORD);
                } else {
                    errors.addMinorErrorKey(MSG_ERROR_BAD_CONFIRM_PASSWORD);
                }
                request.setAttribute("error.location", (Object)errors);
                request.setAttribute("request.beanid", (Object)login);
                Logger.debug("forwarding to: /changePassword.jsp", this);
                this.forwardRequest(request, response, "/changePassword.jsp");
                return;
            }
            try {
                userMgr.changePassword(login, password, newPassword1);
            }
            catch (UserDBException e) {
                Logger.debug("Login failed, login and password not authenticated", this);
                errors.setMajorErrorKey(MSG_ERROR_MAJOR);
                errors.addMinorError(e.getMessage());
                request.setAttribute("error.location", (Object)errors);
                request.setAttribute("request.beanid", (Object)login);
                Logger.debug("forwarding to: /changePassword.jsp", this);
                this.forwardRequest(request, response, "/changePassword.jsp");
                return;
            }
            Logger.debug("Successfully changed password for " + login, this);
            Logger.debug("Forwarding to /Login", this);
            response.sendRedirect("/Login");
            return;
        }
        catch (RaplixException e) {
            Logger.debug("Exception caught in ChangePassword: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/changePassword.jsp");
            return;
        }
    }
}

