/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.utilities.commands;

import com.raplix.rolloutexpress.systemmodel.plandb.TransformType;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandBase;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.util.file.TransformFactory;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.ReaderWrapper;
import com.raplix.util.unicode.UnicodeOutputStreamWriter;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Vector;

public class ApplyTransform
extends CommandBase
implements OutputCommand {
    private static CommandHelp sHelp = new ApplyTransformHelp();
    private Closer mCloser = new Closer();
    private ReaderWrapper mInput;
    private TransformType mType;
    private ReaderWrapper mTransform;
    private OutputStream mOutput;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$utilities$commands$ApplyTransform;

    public void setOutputStream(OutputStream output) {
        this.mOutput = output;
    }

    public void setInput(ReaderWrapper input) {
        this.mInput = input;
        this.mCloser.register(this.mInput);
    }

    public ReaderWrapper getInput() {
        return this.mInput;
    }

    public void setType(TransformType type) {
        this.mType = type;
    }

    public TransformType getType() {
        return this.mType;
    }

    public void setTransform(ReaderWrapper transform) {
        this.mTransform = transform;
        this.mCloser.register(this.mTransform);
    }

    public ReaderWrapper getTransform() {
        return this.mTransform;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        if (this.mOutput == null) {
            this.setOutputStream(System.out);
        }
        Reader reader = this.getInput().getReader();
        UnicodeOutputStreamWriter writer = new UnicodeOutputStreamWriter(this.mOutput, reader);
        TransformFactory.getTransform(this.getType().toString(), this.getTransform().getReader()).apply(reader, writer);
        writer.flush();
    }

    public void cleanup() {
        super.cleanup();
        this.mCloser.closeAll();
    }

    protected static class ApplyTransformHelp
    extends CommandHelpBase {
        private static final String COMMAND_PREFIX = "KEY:ui.util.xfm";
        private static final String MSG_INPUT_DESC = "KEY:ui.util.xfm.INPUT_DESC";
        private static final String MSG_TYPE_DESC = "KEY:ui.util.xfm.TYPE_DESC";
        private static final String MSG_TRANSFORM_DESC = "KEY:ui.util.xfm.TRANSFORM_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.util.xfm.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("input", MSG_INPUT_DESC, "in"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("type", MSG_TYPE_DESC));
            map.addElement(new CommandHelpBase.RequiredArgInfo("transform", MSG_TRANSFORM_DESC, "xfm"));
            return map;
        }

        ApplyTransformHelp() {
            super(class$com$raplix$rolloutexpress$ui$utilities$commands$ApplyTransform == null ? (class$com$raplix$rolloutexpress$ui$utilities$commands$ApplyTransform = ApplyTransform.class$("com.raplix.rolloutexpress.ui.utilities.commands.ApplyTransform")) : class$com$raplix$rolloutexpress$ui$utilities$commands$ApplyTransform, MSG_COMMAND_DESC);
        }
    }
}

