/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.formatters;

import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.HashedString;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SingleSessionVarDescriptorQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.userdb.converters.Permission2DisplayName;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;

public final class UserUtil {
    private static final String ANONYMOUS_USER = "ui.udb.format.ANONYMOUS_USER";
    private static final String USER_FORMAT_PREFIX = "ui.udb.format.u.";
    private static final String USER_ID_HEADER = "ui.udb.format.u.ID_HEADER";
    private static final String USER_USERNAME_HEADER = "ui.udb.format.u.USERNAME_HEADER";
    private static final String USER_PASSWORD_HEADER = "ui.udb.format.u.PASSWORD_HEADER";
    private static final String USER_GROUPS_HEADER = "ui.udb.format.u.GROUPS_HEADER";
    private static final String USER_IS_HIDDEN_HEADER = "ui.udb.format.u.IS_HIDDEN_HEADER";
    private static final String USER_IS_ACTIVE_HEADER = "ui.udb.format.u.IS_ACTIVE_HEADER";
    private static final String USER_AUTHENTICATION_METHOD = "ui.udb.format.u.AUTHENTICATION_METHOD";
    private static final String USER_LOGIN_STATUS = "ui.udb.format.u.LOGIN_STATUS";
    private static final String USER_VALID_LOGIN_STATUS = "ui.udb.format.u.VALID_LOGIN_STATUS";
    private static final String USER_INVALID_LOGIN_STATUS = "ui.udb.format.u.INVALID_LOGIN_STATUS";
    private static final String GROUP_FORMAT_PREFIX = "ui.udb.format.g.";
    private static final String GROUP_ID_HEADER = "ui.udb.format.g.ID_HEADER";
    private static final String GROUP_NAME_HEADER = "ui.udb.format.g.NAME_HEADER";
    private static final String GROUP_DESCRIPTION_HEADER = "ui.udb.format.g.DESCRIPTION_HEADER";
    private static final String GROUP_USERS_HEADER = "ui.udb.format.g.USERS_HEADER";
    private static final String GROUP_PERMISSIONS_HEADER = "ui.udb.format.g.PERMISSIONS_HEADER";
    private static final String GROUP_PARENTS_HEADER = "ui.udb.format.g.PARENTS_HEADER";
    private static final String GROUP_CHILDREN_HEADER = "ui.udb.format.g.CHILDREN_HEADER";
    private static final String PERMISSION_FORMAT_PREFIX = "ui.udb.format.p.";
    private static final String PERMISSION_ID_HEADER = "ui.udb.format.p.ID_HEADER";
    private static final String PERMISSION_DISPLAY_NAME_HEADER = "ui.udb.format.p.DISPLAY_NAME_HEADER";
    private static final String PERMISSION_NAME_HEADER = "ui.udb.format.p.NAME_HEADER";
    private static final String PERMISSION_CLASS_NAME_HEADER = "ui.udb.format.p.CLASS_NAME_HEADER";
    private static final String PERMISSION_ACTIONS_HEADER = "ui.udb.format.p.ACTIONS_HEADER";
    private static final String PERMISSION_GROUPS_HEADER = "ui.udb.format.p.GROUPS_HEADER";
    private static final String SESSION_VAR_FORMAT_PREFIX = "ui.udb.format.sv.";
    private static final String SESSION_VAR_NAME_HEADER = "ui.udb.format.sv.NAME_HEADER";
    private static final String SESSION_VAR_DESC_HEADER = "ui.udb.format.sv.DESC_HEADER";
    private static final String SESSION_VAR_VALUE_HEADER = "ui.udb.format.sv.VALUE_HEADER";
    private static final String SESSION_VAR_ISSECURE_HEADER = "ui.udb.format.sv.ISSECURE_HEADER";
    private static final String LOGIN_CONFIGURATION_FORMAT_PREFIX = "ui.udb.format.l.";
    private static final String LOGIN_CONFIGURATION_NAME_HEADER = "ui.udb.format.l.NAME_HEADER";
    private static final String LOGIN_CONFIGURATION_AUTHENTICATION_TYPE_HEADER = "ui.udb.format.l.AUTHENTICATION_TYPE_HEADER";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission;

    private UserUtil() {
    }

    public static void deepWrite(PrintWriter pw, User u, String prefix) throws Exception {
        UserUtil.detailedWrite(pw, u, prefix);
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_GROUPS_HEADER) + ": ");
        UserUtil.detailedWrite(pw, u.getGroups(), prefix + " ");
    }

    public static void detailedWrite(PrintWriter pw, User u, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_ID_HEADER) + ": " + u.getUserID());
        UserUtil.summaryWrite(pw, u, prefix);
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_AUTHENTICATION_METHOD) + ": " + u.getLoginConfiguration());
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_PASSWORD_HEADER) + ": " + (u.getPassword() == null ? new HashedString("") : u.getPassword()));
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_IS_HIDDEN_HEADER) + ": " + new Boolean(u.getVisibility().equals(Visibility.HIDDEN)));
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_IS_ACTIVE_HEADER) + ": " + u.getActive());
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_LOGIN_STATUS) + ": " + UserUtil.getLoginStatus(u.getLoginConfiguration()));
    }

    public static void summaryWrite(PrintWriter pw, User u, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(USER_USERNAME_HEADER) + ": " + u.getUsername());
    }

    public static void deepWrite(PrintWriter pw, Group g, String prefix) throws Exception {
        UserUtil.detailedWrite(pw, g, prefix);
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_USERS_HEADER) + ": ");
        UserUtil.detailedWrite(pw, g.getUsers(), prefix + " ");
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_PERMISSIONS_HEADER) + ": ");
        UserUtil.nonFolderWrite(pw, g.getPermissions(), prefix + " ");
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_PARENTS_HEADER) + ": ");
        UserUtil.detailedWrite(pw, g.getParentGroups(), prefix + " ");
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_CHILDREN_HEADER) + ": ");
        UserUtil.detailedWrite(pw, g.getChildGroups(), prefix + " ");
    }

    public static void detailedWrite(PrintWriter pw, Group g, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_ID_HEADER) + ": " + g.getGroupID());
        UserUtil.summaryWrite(pw, g, prefix);
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_DESCRIPTION_HEADER) + ": " + g.getDescription());
    }

    public static void summaryWrite(PrintWriter pw, Group g, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(GROUP_NAME_HEADER) + ": " + g.getName());
    }

    public static void deepWrite(PrintWriter pw, Permission p, String prefix) throws Exception {
        UserUtil.detailedWrite(pw, p, prefix);
        pw.print(prefix);
        pw.println(UserUtil.toText(PERMISSION_GROUPS_HEADER) + ": ");
        UserUtil.detailedWrite(pw, p.getGroups(), prefix + " ");
    }

    public static void detailedWrite(PrintWriter pw, Permission p, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(PERMISSION_ID_HEADER) + ": " + p.getPermissionID());
        UserUtil.summaryWrite(pw, p, prefix);
        pw.print(prefix);
        pw.println(UserUtil.toText(PERMISSION_CLASS_NAME_HEADER) + ": " + p.getClassName());
        pw.print(prefix);
        pw.println(UserUtil.toText(PERMISSION_NAME_HEADER) + ": " + p.getName());
        pw.print(prefix);
        pw.println(UserUtil.toText(PERMISSION_ACTIONS_HEADER) + ": " + p.getActions());
    }

    public static void summaryWrite(PrintWriter pw, Permission p, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(PERMISSION_DISPLAY_NAME_HEADER) + ": " + Permission2DisplayName.convert(p));
    }

    public static void detailedWrite(PrintWriter pw, User[] ua, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, UserUtil.toText(USER_ID_HEADER)), new Column(15, 0, UserUtil.toText(USER_USERNAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < ua.length; ++i) {
            data[0] = ua[i].getUserID().toString();
            data[1] = ua[i].getUsername();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void detailedWrite(PrintWriter pw, Group[] ga, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, UserUtil.toText(GROUP_ID_HEADER)), new Column(15, 0, UserUtil.toText(GROUP_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < ga.length; ++i) {
            data[0] = ga[i].getGroupID().toString();
            data[1] = ga[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void detailedWrite(PrintWriter pw, Permission[] pa, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, UserUtil.toText(PERMISSION_ID_HEADER)), new Column(25, 0, UserUtil.toText(PERMISSION_DISPLAY_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < pa.length; ++i) {
            data[0] = pa[i].getPermissionID().toString();
            data[1] = Permission2DisplayName.convert(pa[i]);
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void nonFolderWrite(PrintWriter pw, Permission[] pa, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, UserUtil.toText(PERMISSION_ID_HEADER)), new Column(25, 0, UserUtil.toText(PERMISSION_DISPLAY_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < pa.length; ++i) {
            if (pa[i].getClassName().equals((class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission == null ? UserUtil.class$("com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission") : class$com$raplix$rolloutexpress$systemmodel$userdb$FolderPermission).getName())) continue;
            data[0] = pa[i].getPermissionID().toString();
            data[1] = Permission2DisplayName.convert(pa[i]);
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, UserID userID, String prefix) throws Exception {
        if (userID == null) {
            pw.print(prefix);
            pw.println(UserUtil.toText(ANONYMOUS_USER));
        } else {
            User user = (User)UserUtil.convert(userID, User.class);
            UserUtil.detailedWrite(pw, new User[]{user}, prefix);
        }
    }

    public static void detailedWrite(PrintWriter pw, SessionVariable sv, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(UserUtil.toText(SESSION_VAR_NAME_HEADER) + ": " + sv.getName());
        pw.print(prefix);
        pw.print(UserUtil.toText(SESSION_VAR_DESC_HEADER) + ": ");
        try {
            SessionVarDescriptor svd = SingleSessionVarDescriptorQuery.byName(sv.getName()).select();
            pw.println(svd.getDescription());
        }
        catch (NoResultsFoundException nrfe) {
            pw.println();
        }
        pw.print(prefix);
        pw.print(UserUtil.toText(SESSION_VAR_VALUE_HEADER) + ": ");
        if (!sv.getSecure()) {
            pw.println(sv.getValue());
        } else {
            pw.println("********");
        }
        pw.print(prefix);
        pw.println(UserUtil.toText(SESSION_VAR_ISSECURE_HEADER) + ": " + sv.getSecure());
    }

    public static void detailedWrite(PrintWriter pw, SessionVariable[] sv, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(30, 0, UserUtil.toText(SESSION_VAR_NAME_HEADER)), new Column(30, 0, UserUtil.toText(SESSION_VAR_VALUE_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < sv.length; ++i) {
            data[0] = sv[i].getName();
            data[1] = sv[i].getValue();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void detailedWrite(PrintWriter pw, LoginConfiguration[] lc, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(55, 0, UserUtil.toText(LOGIN_CONFIGURATION_NAME_HEADER)), new Column(20, 0, UserUtil.toText(LOGIN_CONFIGURATION_AUTHENTICATION_TYPE_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < lc.length; ++i) {
            data[0] = lc[i].getName();
            data[1] = new Boolean(lc[i].includesInternal()).toString();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    private static Object convert(Object inObj, Class cls) throws Exception {
        return Context.getConverterHandler().convert(inObj, cls);
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }

    private static String getLoginStatus(String loginConfiguration) throws Exception {
        LoginConfiguration[] loginConfigurations = Context.getSessionManager().getLoginConfigurations();
        for (int i = 0; i < loginConfigurations.length; ++i) {
            if (!loginConfigurations[i].getName().equals(loginConfiguration)) continue;
            return UserUtil.toText(USER_VALID_LOGIN_STATUS);
        }
        return UserUtil.toText(USER_INVALID_LOGIN_STATUS);
    }
}

