/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.formatters;

import [Lcom.raplix.rolloutexpress.systemmodel.userdb.Group;;
import [Lcom.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;;
import [Lcom.raplix.rolloutexpress.systemmodel.userdb.Permission;;
import [Lcom.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;;
import [Lcom.raplix.rolloutexpress.systemmodel.userdb.User;;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.userdb.formatters.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.formatters.UserUtil;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class FormatterBase
implements Formatter {
    private static final String NO_RESULT = "ui.udb.format.NO_RESULT";

    private Object convert(Object src, Class dstClass) throws Exception {
        try {
            return Context.getConverterHandler().convert(src, dstClass);
        }
        catch (ConverterNotFoundException ex) {
            return null;
        }
    }

    private void write(Object src, PrintWriter pw) throws Exception {
        if (src == null) {
            pw.println(Context.getMessageText(NO_RESULT));
            return;
        }
        Object result = this.convert(src, User.class);
        if (result != null) {
            this.write((User)result, pw);
            return;
        }
        result = this.convert(src, Group.class);
        if (result != null) {
            this.write((Group)result, pw);
            return;
        }
        result = this.convert(src, Permission.class);
        if (result != null) {
            this.write((Permission)result, pw);
            return;
        }
        result = this.convert(src, SessionVariable.class);
        if (result != null) {
            this.write((SessionVariable)result, pw);
            return;
        }
        result = this.convert(src, User;.class);
        if (result != null) {
            this.write((User[])result, pw);
            return;
        }
        result = this.convert(src, Group;.class);
        if (result != null) {
            this.write((Group[])result, pw);
            return;
        }
        result = this.convert(src, Permission;.class);
        if (result != null) {
            this.write((Permission[])result, pw);
            return;
        }
        result = this.convert(src, SessionVariable;.class);
        if (result != null) {
            this.write((SessionVariable[])result, pw);
            return;
        }
        result = this.convert(src, LoginConfiguration;.class);
        if (result != null) {
            this.write((LoginConfiguration[])result, pw);
            return;
        }
        PackageInfo.throwCannotWrite(src);
    }

    protected abstract void write(User var1, PrintWriter var2) throws Exception;

    protected abstract void write(Group var1, PrintWriter var2) throws Exception;

    protected abstract void write(Permission var1, PrintWriter var2) throws Exception;

    protected void write(SessionVariable sv, PrintWriter pw) throws Exception {
        UserUtil.detailedWrite(pw, sv, "");
    }

    protected void write(User[] ua, PrintWriter pw) throws Exception {
        UserUtil.detailedWrite(pw, ua, "");
    }

    protected void write(Group[] ga, PrintWriter pw) throws Exception {
        UserUtil.detailedWrite(pw, ga, "");
    }

    protected void write(Permission[] pa, PrintWriter pw) throws Exception {
        UserUtil.detailedWrite(pw, pa, "");
    }

    protected void write(SessionVariable[] sva, PrintWriter pw) throws Exception {
        UserUtil.detailedWrite(pw, sva, "");
    }

    protected void write(LoginConfiguration[] lc, PrintWriter pw) throws Exception {
        UserUtil.detailedWrite(pw, lc, "");
    }

    public void write(Object src, OutputStream out) throws Exception {
        PrintWriter pw = new PrintWriter(out);
        this.write(src, pw);
        pw.flush();
    }
}

