/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.userdb.converters.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.converters.PermissionDisplayNameMap;
import com.raplix.rolloutexpress.ui.userdb.converters.PermissionID2Permission;

public class String2PermissionID
implements Converter,
Prefixes {
    public static PermissionID convert(String src) throws UserDBException, RPCException, PersistenceManagerException {
        if ((src = src.trim()).startsWith("NM:")) {
            src = src.substring("NM:".length());
            return String2PermissionID.convertByName(src);
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return String2PermissionID.convertByID(src);
    }

    public static PermissionID convertByID(String ID2) throws UserDBException, RPCException {
        PermissionID result = new PermissionID(ID2);
        PermissionID2Permission.convert(result);
        return result;
    }

    public static PermissionID convertByName(String permissionName) throws UserDBException, RPCException, PersistenceManagerException {
        PermissionID result = String2PermissionID.getPermissionDisplayNameMap().getPermissionID(permissionName);
        if (result == null) {
            PackageInfo.throwNoSuchPermission(permissionName);
        }
        return result;
    }

    private static PermissionDisplayNameMap getPermissionDisplayNameMap() {
        return PermissionDisplayNameMap.getInstance();
    }
}

