/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.userdb.converters.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.converters.PermissionDisplayNameMap;
import com.raplix.rolloutexpress.ui.userdb.converters.PermissionID2Permission;
import com.raplix.rolloutexpress.ui.userdb.converters.String2PermissionID;

public class String2Permission
implements Converter,
Prefixes {
    public static Permission convert(String src) throws UserDBException, RPCException, PersistenceManagerException {
        if ((src = src.trim()).startsWith("NM:")) {
            src = src.substring("NM:".length());
            return String2Permission.convertByName(src);
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return String2Permission.convertByID(src);
    }

    public static Permission convertByID(String ID2) throws UserDBException, RPCException {
        return PermissionID2Permission.convert(String2PermissionID.convertByID(ID2));
    }

    public static Permission convertByName(String permissionName) throws UserDBException, RPCException, PersistenceManagerException {
        Permission result = String2Permission.getPermissionDisplayNameMap().getPermission(permissionName);
        if (result == null) {
            PackageInfo.throwNoSuchPermission(permissionName);
        }
        return result;
    }

    private static PermissionDisplayNameMap getPermissionDisplayNameMap() {
        return PermissionDisplayNameMap.getInstance();
    }
}

