/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.converters;

import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.TaskPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.folderdb.converters.String2Folder;
import com.raplix.rolloutexpress.ui.folderdb.converters.String2FolderID;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostSet;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostSetID;
import com.raplix.rolloutexpress.ui.userdb.converters.PermissionID2Permission;
import com.raplix.rolloutexpress.ui.userdb.converters.String2User;
import com.raplix.rolloutexpress.ui.userdb.converters.String2UserID;
import com.raplix.util.DelayedCreator;
import com.raplix.util.string.StringUtil;
import java.util.HashMap;

class PermissionDisplayNameMap
implements Prefixes {
    private static InstanceCreator sInstance = new InstanceCreator();
    private static final String PERM_SEPARATOR = ":";
    private static final String DIFF_RUN_PREFIX = "diff.run:";
    private static final String ALL_USERS = "allusers";
    private static final String OWNER_PREFIX = "owner.";
    private static final String FOLDER_PREFIX = "folder:";
    private static final String FP_HOSTSET_PREFIX = ":hostset:";
    private static final String HP_HOSTSET_PREFIX = "hostset:";
    private static final String DIFF_PERM_CLASS_NAME = DifferencePermission.class.getName();
    private static final String TASK_PERM_CLASS_NAME = TaskPermission.class.getName();
    private static final String FOLDER_PERM_CLASS_NAME = FolderPermission.class.getName();
    private HashMap mName2PermIDMap = new HashMap();
    private HashMap mPermID2NameMap = new HashMap();

    public static PermissionDisplayNameMap getInstance() {
        return (PermissionDisplayNameMap)sInstance.getValue();
    }

    private PermissionDisplayNameMap() {
        PermissionManager permMan = Context.getUserDBAdmin().getPermissionManager();
        this.addPermName("userdb.read", permMan.getUserDBReadPermissionID());
        this.addPermName("userdb.read", permMan.getUserDBReadPermissionID());
        this.addPermName("userdb.write", permMan.getUserDBWritePermissionID());
        this.addPermName("host.read", permMan.getHostReadPermissionID());
        this.addPermName("host.write", permMan.getHostWritePermissionID());
        this.addPermName("hostType.read", permMan.getHostTypeReadPermissionID());
        this.addPermName("hostType.write", permMan.getHostTypeWritePermissionID());
        this.addPermName("rule.read", permMan.getRuleReadPermissionID());
        this.addPermName("rule.write", permMan.getRuleWritePermissionID());
        this.addPermName("diff.read", permMan.getDiffReadPermissionID());
        this.addPermName("diff.write", permMan.getDiffWritePermissionID());
        this.addPermName("diff.run:allhosts", permMan.getAllHostsRunDiffPermissionID());
        this.addPermName("plugin.read", permMan.getPluginReadPermissionID());
        this.addPermName("plugin.write", permMan.getPluginWritePermissionID());
    }

    private void addPermName(String name, PermissionID perm) {
        this.mName2PermIDMap.put(name, perm);
        this.mPermID2NameMap.put(perm, name);
    }

    public String getName(Permission perm) throws UserDBException, PersistenceManagerException, RPCException {
        String name = (String)this.mPermID2NameMap.get(perm.getPermissionID());
        if (name != null) {
            return name;
        }
        return this.getNonDefaultName(perm);
    }

    public String getName(PermissionID permID) throws UserDBException, PersistenceManagerException, RPCException {
        String name = (String)this.mPermID2NameMap.get(permID);
        if (name != null) {
            return name;
        }
        Permission perm = PermissionID2Permission.convert(permID);
        return this.getNonDefaultName(perm);
    }

    private String getNonDefaultName(Permission perm) throws PersistenceManagerException, RPCException, UserDBException {
        String className = perm.getClassName();
        if (className.equals(DIFF_PERM_CLASS_NAME)) {
            return this.getDiffRunPermissionName(perm);
        }
        if (className.equals(TASK_PERM_CLASS_NAME)) {
            return this.getTaskPermissionName(perm);
        }
        if (className.equals(FOLDER_PERM_CLASS_NAME)) {
            return this.getFolderPermissionName(perm);
        }
        return null;
    }

    private String getDiffRunPermissionName(Permission perm) throws PersistenceManagerException, RPCException {
        String permName = perm.getName();
        if (!permName.startsWith(HP_HOSTSET_PREFIX)) {
            return null;
        }
        String hostSetID = permName.substring(HP_HOSTSET_PREFIX.length());
        return DIFF_RUN_PREFIX + String2HostSet.convert(hostSetID).getName();
    }

    private String getTaskPermissionName(Permission perm) throws PersistenceManagerException, RPCException, UserDBException {
        String permName = perm.getName();
        if (!permName.startsWith(OWNER_PREFIX)) {
            return null;
        }
        String userID = permName.substring(OWNER_PREFIX.length());
        String userName = userID.equals("*") ? ALL_USERS : String2User.convert(userID).getUsername();
        return OWNER_PREFIX + userName;
    }

    private String getFolderDisplayName(String folderID) throws PersistenceManagerException, RPCException {
        if (folderID.equals("*")) {
            return "*";
        }
        return String2Folder.convert(folderID).getName();
    }

    private String getFolderPermissionName(Permission perm) throws PersistenceManagerException, RPCException {
        String permName = perm.getName();
        if (!permName.startsWith(FOLDER_PREFIX)) {
            return null;
        }
        int sepNdx = permName.indexOf(FP_HOSTSET_PREFIX);
        if (sepNdx < 0) {
            String folderID = permName.substring(FOLDER_PREFIX.length());
            return FOLDER_PREFIX + this.getFolderDisplayName(folderID) + PERM_SEPARATOR + perm.getActions();
        }
        String folderID = permName.substring(0, sepNdx).substring(FOLDER_PREFIX.length());
        String hostSetID = permName.substring(sepNdx + FP_HOSTSET_PREFIX.length());
        String hostSetName = hostSetID.equals("*") ? "allhosts" : String2HostSet.convert(hostSetID).getName();
        return FOLDER_PREFIX + this.getFolderDisplayName(folderID) + PERM_SEPARATOR + perm.getActions() + PERM_SEPARATOR + hostSetName;
    }

    public PermissionID getPermissionID(String permName) throws UserDBException, PersistenceManagerException, RPCException {
        PermissionID permID = (PermissionID)this.mName2PermIDMap.get(permName);
        if (permID != null) {
            return permID;
        }
        Permission perm = this.getNonDefaultPermission(permName);
        return perm != null ? perm.getPermissionID() : null;
    }

    public Permission getPermission(String permName) throws UserDBException, PersistenceManagerException, RPCException {
        PermissionID permID = (PermissionID)this.mName2PermIDMap.get(permName);
        if (permID != null) {
            return PermissionID2Permission.convert(permID);
        }
        return this.getNonDefaultPermission(permName);
    }

    private Permission getNonDefaultPermission(String permName) throws UserDBException, PersistenceManagerException, RPCException {
        if (permName.startsWith(DIFF_RUN_PREFIX)) {
            return this.getDiffRunPermission(permName);
        }
        if (permName.startsWith(OWNER_PREFIX)) {
            return this.getTaskPermission(permName);
        }
        if (permName.startsWith(FOLDER_PREFIX)) {
            return this.getFolderPermission(permName);
        }
        return null;
    }

    private Permission getDiffRunPermission(String permName) throws UserDBException, PersistenceManagerException, RPCException {
        String hostSetName = permName.substring(DIFF_RUN_PREFIX.length());
        if (StringUtil.isEmpty(hostSetName)) {
            return null;
        }
        String name = HP_HOSTSET_PREFIX + String2HostSetID.convert("NM:" + hostSetName);
        PermissionManager permMan = Context.getUserDBAdmin().getPermissionManager();
        Permission[] perms = permMan.getPermissionsByCriteria(name, DIFF_PERM_CLASS_NAME, null);
        return perms.length != 1 ? null : perms[0];
    }

    private Permission getTaskPermission(String permName) throws UserDBException, PersistenceManagerException, RPCException {
        String userName = permName.substring(OWNER_PREFIX.length());
        if (StringUtil.isEmpty(userName)) {
            return null;
        }
        String name = OWNER_PREFIX;
        name = userName.equals(ALL_USERS) ? name + "*" : name + String2UserID.convert("NM:" + userName);
        PermissionManager permMan = Context.getUserDBAdmin().getPermissionManager();
        Permission[] perms = permMan.getPermissionsByCriteria(name, TASK_PERM_CLASS_NAME, null);
        return perms.length != 1 ? null : perms[0];
    }

    private Permission getFolderPermission(String permName) throws UserDBException, PersistenceManagerException, RPCException {
        PermissionManager permMan;
        Permission[] perms;
        if (StringUtil.isEmpty(permName = permName.substring(FOLDER_PREFIX.length()))) {
            return null;
        }
        int actionSeparator = permName.indexOf(PERM_SEPARATOR);
        if (actionSeparator < 0) {
            return null;
        }
        String folderName = permName.substring(0, actionSeparator);
        if (StringUtil.isEmpty(folderName)) {
            return null;
        }
        String action = permName.substring(actionSeparator + 1);
        if (StringUtil.isEmpty(action)) {
            return null;
        }
        String name = FOLDER_PREFIX + String2FolderID.convert("NM:" + folderName);
        int hsSeparator = action.indexOf(PERM_SEPARATOR);
        if (hsSeparator > -1) {
            String hsName = action.substring(hsSeparator + 1);
            action = action.substring(0, hsSeparator);
            name = hsName.equals("allhosts") ? name + ":hostset:*" : name + FP_HOSTSET_PREFIX + String2HostSetID.convert("NM:" + hsName);
        }
        return (perms = (permMan = Context.getUserDBAdmin().getPermissionManager()).getPermissionsByCriteria(name, FOLDER_PERM_CLASS_NAME, action)).length != 1 ? null : perms[0];
    }

    private static class InstanceCreator
    extends DelayedCreator {
        private InstanceCreator() {
        }

        protected Object create() {
            return new PermissionDisplayNameMap();
        }
    }
}

