/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.userdb.LoginConfiguration;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.UserEditBase;
import java.util.Vector;

public class UserModify
extends UserEditBase {
    private static CommandHelp sHelp = new UserModifyHelp();
    private UserID mID;
    private User mResult;
    private Boolean mHide = null;
    private Boolean mActive = null;
    private boolean mForceFlush = false;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$UserModify;

    public void setHide(Boolean hide) {
        this.mHide = hide;
    }

    public Boolean getHide() {
        return this.mHide;
    }

    public void setForceFlush(boolean forceFlush) {
        this.mForceFlush = forceFlush;
    }

    public boolean getForceFlush() {
        return this.mForceFlush;
    }

    public void setActive(Boolean active) {
        this.mActive = active;
    }

    public Boolean getActive() {
        return this.mActive;
    }

    public void setID(UserID ID2) {
        this.mID = ID2;
    }

    public UserID getID() {
        return this.mID;
    }

    protected void setResult(User result) {
        this.mResult = result;
    }

    public User getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        User u = Context.getUserDBAdmin().getUserManager().getUser(this.getID());
        this.setUser(u);
        boolean alreadyHidden = u.getVisibility().equals(Visibility.HIDDEN);
        if (this.getHide() != null && this.getHide() != alreadyHidden) {
            u.setVisibility(this.getHide() != false ? Visibility.HIDDEN : Visibility.VISIBLE);
        }
        if (this.getActive() != null && this.getActive().booleanValue() != u.getActive()) {
            u.setActive(this.getActive());
        }
        if (this.getLoginConfig() != null && !this.isUserLoginConfigurationInternal(this.getLoginConfig())) {
            u.setPassword(null);
        }
        u.save(this.getForceFlush());
        this.setResult(u);
    }

    private boolean isUserLoginConfigurationInternal(String s) throws RPCException {
        LoginConfiguration[] loginConfigurations = Context.getSessionManager().getLoginConfigurations();
        for (int i = 0; i < loginConfigurations.length; ++i) {
            if (!loginConfigurations[i].getName().equals(s)) continue;
            return loginConfigurations[i].includesInternal();
        }
        return true;
    }

    protected static class UserModifyHelp
    extends UserEditBase.UserEditBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.u.mod.";
        private static final String MSG_ID_DESC = "KEY:ui.udb.u.mod.ID_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.udb.u.mod.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.u.mod.COMMAND_DESC";
        private static final String MSG_HIDE_DESC = "KEY:ui.udb.u.mod.HIDE_DESC";
        private static final String MSG_ACTIVE_DESC = "KEY:ui.udb.u.mod.ACTIVE_DESC";
        private static final String MSG_FORCE_FLUSH_DESC = "KEY:ui.udb.u.mod.FORCE_FLUSH";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("ID", MSG_ID_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("hide", MSG_HIDE_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("active", MSG_ACTIVE_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("forceFlush", MSG_FORCE_FLUSH_DESC));
            this.addArguments(map, false);
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        UserModifyHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$UserModify == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$UserModify = UserModify.class$("com.raplix.rolloutexpress.ui.userdb.commands.UserModify")) : class$com$raplix$rolloutexpress$ui$userdb$commands$UserModify, MSG_COMMAND_DESC);
        }
    }
}

