/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.io.IOException;
import java.util.Vector;

public abstract class UserEditBase
extends SessionBase {
    private String mNewPassword = null;
    private String mLoginConfig = null;
    private Group[] mGroups;
    protected boolean mLoginConfigSet = false;

    public void setNewPlaintextPassword(String newPlaintextPassword) {
        if (this.mNewPassword == null) {
            this.mNewPassword = newPlaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getNewPassword() {
        return this.mNewPassword;
    }

    public void setNewEncodedPassword(String newEncodedPassword) throws IOException {
        this.setNewPlaintextPassword(UserEditBase.decodePassword(newEncodedPassword));
    }

    public void setGroups(Group[] groups) {
        this.mGroups = groups;
    }

    public Group[] getGroups() {
        return this.mGroups;
    }

    public void setLoginConfig(String newLoginConfiguration) {
        this.mLoginConfig = newLoginConfiguration;
        this.mLoginConfigSet = true;
    }

    public String getLoginConfig() {
        return this.mLoginConfig;
    }

    protected void setUser(User u) throws UserDBException, RPCException {
        if (this.getNewPassword() != null) {
            u.setPassword(this.getNewPassword());
        }
        if (this.getGroups() != null) {
            u.setGroups(this.getGroups());
        }
        if (this.getLoginConfig() != null) {
            u.setLoginConfiguration(this.getLoginConfig());
        }
    }

    protected static abstract class UserEditBaseHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.u.edit.";
        private static final String MSG_NEW_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.u.edit.NEW_PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_NEW_ENCODED_PASSWORD_DESC = "KEY:ui.udb.u.edit.NEW_ENCODED_PASSWORD_DESC";
        private static final String MSG_GROUPS_DESC = "KEY:ui.udb.u.edit.GROUPS_DESC";
        private static final String MSG_ADD_LOGIN_CONFIG_DESC = "KEY:ui.udb.u.edit.ADD_LOGIN_CONFIG_DESC";
        private static final String MSG_MODIFY_LOGIN_CONFIG_DESC = "KEY:ui.udb.u.edit.MODIFY_LOGIN_CONFIG_DESC";

        protected void addArguments(Vector map, boolean addLoginConfig) {
            map.addElement(new CommandHelpBase.OptionalArgInfo("newPlaintextPassword", MSG_NEW_PLAINTEXT_PASSWORD_DESC, "np"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("newEncodedPassword", MSG_NEW_ENCODED_PASSWORD_DESC, "nep"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("groups", MSG_GROUPS_DESC, "ng"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("loginConfig", addLoginConfig ? MSG_ADD_LOGIN_CONFIG_DESC : MSG_MODIFY_LOGIN_CONFIG_DESC));
        }

        UserEditBaseHelp(Class cls, String desc) {
            super(cls, desc);
        }
    }
}

