/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.UserEditBase;
import java.util.Vector;

public class UserAdd
extends UserEditBase {
    private static CommandHelp sHelp = new UserAddHelp();
    private String mNewUsername;
    private User mResult;
    private boolean mHide = false;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$UserAdd;

    public void setHide(boolean hide) {
        this.mHide = hide;
    }

    public boolean getHide() {
        return this.mHide;
    }

    public void setNewUsername(String newUsername) {
        this.mNewUsername = newUsername;
    }

    public String getNewUsername() {
        return this.mNewUsername;
    }

    protected void setResult(User result) {
        this.mResult = result;
    }

    public User getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        User user = Context.getUserDBAdmin().getUserManager().newUser(this.getNewUsername());
        user.setVisibility(this.getHide() ? Visibility.HIDDEN : Visibility.VISIBLE);
        this.setUser(user);
        if (!this.mLoginConfigSet) {
            user.setLoginConfiguration("internal");
        }
        user.save(false);
        this.setResult(user);
    }

    protected static class UserAddHelp
    extends UserEditBase.UserEditBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.u.add.";
        private static final String MSG_NEW_USERNAME_DESC = "KEY:ui.udb.u.add.NEW_USERNAME_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.udb.u.add.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.u.add.COMMAND_DESC";
        private static final String MSG_HIDE_DESC = "KEY:ui.udb.u.add.HIDE_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("newUsername", MSG_NEW_USERNAME_DESC, "nu"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("hide", MSG_HIDE_DESC));
            this.addArguments(map, true);
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        UserAddHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$UserAdd == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$UserAdd = UserAdd.class$("com.raplix.rolloutexpress.ui.userdb.commands.UserAdd")) : class$com$raplix$rolloutexpress$ui$userdb$commands$UserAdd, MSG_COMMAND_DESC);
        }
    }
}

