/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SingleSessionVarDescriptorQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionVariableEditBase;
import java.util.Vector;

public class SessionVariableView
extends SessionVariableEditBase {
    private static CommandHelp sHelp = new SessionVariableViewHelp();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableView;

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        SessionManager sm = Context.getSessionManager();
        SessionVariableSet svs = sm.getSessionVariables();
        if (svs.contains(this.getName())) {
            this.setResult(svs.getVariable(this.getName()));
            return;
        }
        try {
            SummarySessionVarDescriptor svd = SingleSessionVarDescriptorQuery.byName(this.getName()).selectSummaryView();
            SessionVariable sv = new SessionVariable(svd.getName(), "", svd.getSecure());
            this.setResult(sv);
        }
        catch (NoResultsFoundException nrfe) {
            PackageInfo.throwSessionVarNotValid(this.getName());
        }
    }

    protected static class SessionVariableViewHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.sv.lo";
        private static final String MSG_NAME_DESC = "KEY:ui.udb.sv.lo.NAME_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.udb.sv.lo.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.sv.lo.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("name", MSG_NAME_DESC));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        SessionVariableViewHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableView == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableView = SessionVariableView.class$("com.raplix.rolloutexpress.ui.userdb.commands.SessionVariableView")) : class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableView, MSG_COMMAND_DESC);
        }
    }
}

