/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandBase;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.util.string.PasswordEscape;
import java.io.IOException;
import java.util.Vector;

public class SessionVariableReEncrypt
extends CommandBase {
    private static CommandHelp sHelp = new SessionVariableReEncryptHelp();
    private String mUsername;
    private String mPassword;
    private String mOldPassword;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableReEncrypt;

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setPlaintextPassword(String plaintextPassword) {
        if (this.mPassword == null) {
            this.mPassword = plaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setOldPlaintextPassword(String oldPassword) {
        if (this.mOldPassword == null) {
            this.mOldPassword = oldPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getOldPassword() {
        return this.mOldPassword;
    }

    public void setEncodedPassword(String encodedPassword) throws IOException {
        this.setPlaintextPassword(this.getDecodedPassword(encodedPassword));
    }

    public void setOldEncodedPassword(String oldEncodedPassword) throws IOException {
        this.setOldPlaintextPassword(this.getDecodedPassword(oldEncodedPassword));
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        SessionManager sm = Context.getSessionManager();
        sm.recryptSessionVariables(false, this.getUsername(), this.getPassword(), this.getOldPassword());
    }

    private String getDecodedPassword(String encodedPassword) throws IOException {
        return PasswordEscape.decodePassword(encodedPassword);
    }

    protected static class SessionVariableReEncryptHelp
    extends CommandHelpBase {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.sv.re";
        private static final String MSG_NAME_DESC = "KEY:ui.udb.sv.re.NAME_DESC";
        private static final String MSG_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.sv.re.PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_OLD_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.sv.re.OLD_PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_ENCODED_PASSWORD_DESC = "KEY:ui.udb.sv.re.ENCODED_PASSWORD_DESC";
        private static final String MSG_OLD_ENCODED_PASSWORD_DESC = "KEY:ui.udb.sv.re.OLD_ENCODED_PASSWORD_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.sv.re.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("username", MSG_NAME_DESC, "u"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("plaintextPassword", MSG_PLAINTEXT_PASSWORD_DESC, "p"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("oldPlaintextPassword", MSG_OLD_PLAINTEXT_PASSWORD_DESC, "op"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("encodedPassword", MSG_ENCODED_PASSWORD_DESC, "ep"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("oldEncodedPassword", MSG_OLD_ENCODED_PASSWORD_DESC, "oep"));
            return map;
        }

        SessionVariableReEncryptHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableReEncrypt == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableReEncrypt = SessionVariableReEncrypt.class$("com.raplix.rolloutexpress.ui.userdb.commands.SessionVariableReEncrypt")) : class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableReEncrypt, MSG_COMMAND_DESC);
        }
    }
}

