/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandBase;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.util.string.PasswordEscape;
import java.io.IOException;
import java.util.Vector;

public class SessionVariableFlush
extends CommandBase {
    private static CommandHelp sHelp = new SessionVariableFlushHelp();
    private String mUsername;
    private String mPassword;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableFlush;

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setPlaintextPassword(String plaintextPassword) {
        if (this.mPassword == null) {
            this.mPassword = plaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setEncodedPassword(String encodedPassword) throws IOException {
        this.setPlaintextPassword(PasswordEscape.decodePassword(encodedPassword));
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        SessionManager sm = Context.getSessionManager();
        sm.recryptSessionVariables(true, this.getUsername(), this.getPassword(), null);
    }

    protected static class SessionVariableFlushHelp
    extends CommandHelpBase {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.sv.fl";
        private static final String MSG_NAME_DESC = "KEY:ui.udb.sv.fl.NAME_DESC";
        private static final String MSG_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.sv.fl.PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_ENCODED_PASSWORD_DESC = "KEY:ui.udb.sv.fl.ENCODED_PASSWORD_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.sv.fl.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("username", MSG_NAME_DESC, "u"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("plaintextPassword", MSG_PLAINTEXT_PASSWORD_DESC, "p"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("encodedPassword", MSG_ENCODED_PASSWORD_DESC, "ep"));
            return map;
        }

        SessionVariableFlushHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableFlush == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableFlush = SessionVariableFlush.class$("com.raplix.rolloutexpress.ui.userdb.commands.SessionVariableFlush")) : class$com$raplix$rolloutexpress$ui$userdb$commands$SessionVariableFlush, MSG_COMMAND_DESC);
        }
    }
}

