/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SingleSessionVarDescriptorQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;

public abstract class SessionVariableEditBase
extends SessionBase {
    private String mName;
    private String mDescription;
    private String mValue;
    private Boolean mSecure;
    private SessionVariable mResult;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setSecure(Boolean isSecure) {
        this.mSecure = isSecure;
    }

    public Boolean getSecure() {
        return this.mSecure;
    }

    public void setResult(SessionVariable result) {
        this.mResult = result;
    }

    public SessionVariable getResult() {
        return this.mResult;
    }

    protected void setSessionVariable(String oldName) throws Exception {
        String name = this.getName();
        String value = this.getValue();
        Boolean sec = this.getSecure();
        boolean secure = sec != null ? sec : false;
        SessionManager sm = Context.getSessionManager();
        SessionVariableSet svs = sm.getSessionVariables();
        if (oldName != null) {
            SessionVariable oldSV;
            if (!svs.contains(oldName)) {
                PackageInfo.throwSessionVarNotValid(this.getName());
            }
            if ((oldSV = svs.getVariable(oldName)).getValue() == value && oldSV.getSecure() == secure) {
                this.setSVDescriptor(oldSV, secure);
                this.setResult(oldSV);
                return;
            }
            if (value == null) {
                value = oldSV.getValue();
            }
            if (sec == null) {
                secure = oldSV.getSecure();
            }
            svs.remove(oldName);
        } else if (name != null && svs.contains(name)) {
            PackageInfo.throwSessionVarPresent(name);
        }
        SessionVariable sv = new SessionVariable(name, value, secure);
        svs.add(sv);
        this.setSVDescriptor(sv, secure);
        this.saveSessionVars(svs);
        this.setResult(sv);
    }

    protected void saveSessionVars(SessionVariableSet svs) throws Exception {
        block2: {
            SessionManager sm = Context.getSessionManager();
            svs.purgeNonDescriptorVars();
            sm.setSessionVariables(svs);
            try {
                sm.saveSessionVariables(this.getPassword());
            }
            catch (UserDBException udbe) {
                if (udbe.getMessage().equals("userdb.SESSION_VARS_NOT_PERSISTENT")) break block2;
                throw udbe;
            }
        }
    }

    private void setSVDescriptor(SessionVariable sv, boolean secure) throws Exception {
        try {
            SessionVarDescriptor svd = SingleSessionVarDescriptorQuery.byName(sv.getName()).select();
            if (this.getDescription() != null && !this.getDescription().equals(svd.getDescription())) {
                svd.setDescription(this.getDescription());
                svd.save();
                return;
            }
        }
        catch (NoResultsFoundException e) {
            SessionVarDescriptor svd = new SessionVarDescriptor(sv.getName());
            svd.setSecure(secure);
            if (this.getDescription() != null) {
                svd.setDescription(this.getDescription());
            }
            svd.save();
        }
    }
}

