/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandBase;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.util.string.PasswordEscape;
import java.io.IOException;
import java.util.Vector;

public abstract class SessionBase
extends CommandBase {
    private String mUsername;
    private String mPassword;
    private SessionID mSessionID;

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setPlaintextPassword(String plaintextPassword) throws ContextException, RPCException, UserDBException {
        if (this.mPassword == null) {
            this.mPassword = plaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
        Context.getUIContextServices().setSessionID(null);
        this.setSessionID(Context.getSessionManager().login(this.getUsername(), this.getPassword()));
    }

    public void setEncodedPassword(String encodedPassword) throws ContextException, RPCException, UserDBException, IOException {
        this.setPlaintextPassword(SessionBase.decodePassword(encodedPassword));
    }

    public String getPassword() {
        return this.mPassword;
    }

    protected static String decodePassword(String encodedPassword) throws IOException {
        return PasswordEscape.decodePassword(encodedPassword);
    }

    public void setSessionID(SessionID sessionID) throws ContextException {
        this.mSessionID = sessionID;
        Context.getUIContextServices().setSessionID(this.mSessionID);
    }

    public SessionID getSessionID() {
        return this.mSessionID;
    }

    public void authorize() throws Exception {
        if (Context.getSessionManager().getCurrentUserID() == null) {
            PackageInfo.throwSessionNotValid();
        }
    }

    public static class SessionBaseHelp
    extends CommandHelpBase {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.session.";
        private static final String MSG_USERNAME_DESC = "KEY:ui.udb.session.USERNAME_DESC";
        private static final String MSG_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.session.PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_ENCODED_PASSWORD_DESC = "KEY:ui.udb.session.ENCODED_PASSWORD_DESC";
        private static final String MSG_SESSIONID_DESC = "KEY:ui.udb.session.SESSIONID_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("username", MSG_USERNAME_DESC, "u"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("plaintextPassword", MSG_PLAINTEXT_PASSWORD_DESC, "p"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("encodedPassword", MSG_ENCODED_PASSWORD_DESC, "ep"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("sessionID", MSG_SESSIONID_DESC, "s"));
            return map;
        }

        public SessionBaseHelp(Class cls, String desc) {
            super(cls, desc);
        }
    }
}

