/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.ui.Context;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String PACKAGE_PREFIX = "ui.udb";
    public static final String EX_SESSION_NOT_VALID = "ui.udb.EX_SESSION_NOT_VALID";
    public static final String EX_SESSION_VAR_NOT_VALID = "ui.udb.EX_SESSION_VAR_NOT_VALID";
    public static final String EX_SESSION_VAR_PRESENT = "ui.udb.EX_SESSION_VAR_PRESENT";
    public static final String EX_DIFF_RUN_PERM_NOT_FOUND = "ui.udb.EX_DIFF_RUN_PERM_NOT_FOUND";
    public static final String EX_BOTH_EN_PT_PASS_FOUND = "ui.udb.EX_BOTH_EN_PT_PASS_FOUND";

    private PackageInfo() {
    }

    public static void throwSessionNotValid() {
        throw new IllegalStateException(Context.getMessageText(EX_SESSION_NOT_VALID));
    }

    public static void throwSessionVarNotValid(String name) {
        throw new IllegalArgumentException(Context.getMessageText(EX_SESSION_VAR_NOT_VALID, name));
    }

    public static void throwSessionVarPresent(String name) {
        throw new IllegalArgumentException(Context.getMessageText(EX_SESSION_VAR_PRESENT, name));
    }

    public static void throwDiffRunPermissionNotFound(String name) {
        throw new IllegalStateException(Context.getMessageText(EX_DIFF_RUN_PERM_NOT_FOUND, name));
    }

    public static void throwBothEnPtPasswordFound() {
        throw new IllegalStateException(Context.getMessageText(EX_BOTH_EN_PT_PASS_FOUND));
    }
}

