/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.systemmodel.userdb.SessionID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandBase;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.util.string.PasswordEscape;
import java.io.IOException;
import java.util.Vector;

public class Login
extends CommandBase {
    private static CommandHelp sHelp = new LoginHelp();
    private String mUsername;
    private String mPassword;
    private SessionID mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$Login;

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setPlaintextPassword(String plaintextPassword) {
        if (this.mPassword == null) {
            this.mPassword = plaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setEncodedPassword(String encodedPassword) throws IOException {
        this.setPlaintextPassword(PasswordEscape.decodePassword(encodedPassword));
    }

    protected void setResult(SessionID result) {
        this.mResult = result;
    }

    public SessionID getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        Context.getUIContextServices().setSessionID(null);
        this.setResult(Context.getSessionManager().login(this.getUsername(), this.getPassword()));
        Context.getUIContextServices().setSessionID(this.getResult());
    }

    protected static class LoginHelp
    extends CommandHelpBase {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.login.";
        private static final String MSG_USERNAME_DESC = "KEY:ui.udb.login.USERNAME_DESC";
        private static final String MSG_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.login.PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_ENCODED_PASSWORD_DESC = "KEY:ui.udb.login.ENCODED_PASSWORD_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.udb.login.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.login.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("username", MSG_USERNAME_DESC, "u"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("plaintextPassword", MSG_PLAINTEXT_PASSWORD_DESC, "p"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("encodedPassword", MSG_ENCODED_PASSWORD_DESC, "ep"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        LoginHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$Login == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$Login = Login.class$("com.raplix.rolloutexpress.ui.userdb.commands.Login")) : class$com$raplix$rolloutexpress$ui$userdb$commands$Login, MSG_COMMAND_DESC);
        }
    }
}

