/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostSetID;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public abstract class GroupEditBase
extends SessionBase {
    private String mName;
    private String mDescription;
    private User[] mUsers;
    private Boolean mHostWritePermission;
    private Boolean mRuleWritePermission;
    private Boolean mAdminWritePermission;
    private Boolean mDiffWritePermission;
    private String mDiffRunPermission;
    private Group[] mParentGroups;
    private Group[] mChildGroups;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setParentGroups(Group[] groups) {
        this.mParentGroups = groups;
    }

    public Group[] getParentGroups() {
        return this.mParentGroups;
    }

    public void setChildGroups(Group[] groups) {
        this.mChildGroups = groups;
    }

    public Group[] getChildGroups() {
        return this.mChildGroups;
    }

    public void setUsers(User[] users) {
        this.mUsers = users;
    }

    public User[] getUsers() {
        return this.mUsers;
    }

    public void setHostWritePermission(Boolean permission) {
        this.mHostWritePermission = permission;
    }

    public Boolean getHostWritePermission() {
        return this.mHostWritePermission;
    }

    public void setRuleWritePermission(Boolean permission) {
        this.mRuleWritePermission = permission;
    }

    public Boolean getRuleWritePermission() {
        return this.mRuleWritePermission;
    }

    public void setAdminWritePermission(Boolean permission) {
        this.mAdminWritePermission = permission;
    }

    public Boolean getAdminWritePermission() {
        return this.mAdminWritePermission;
    }

    public void setDiffWritePermission(Boolean permission) {
        this.mDiffWritePermission = permission;
    }

    public Boolean getDiffWritePermission() {
        return this.mDiffWritePermission;
    }

    public void setDiffRunPermission(String hostSetID) {
        this.mDiffRunPermission = hostSetID;
    }

    public String getDiffRunPermission() {
        return this.mDiffRunPermission;
    }

    protected void setGroup(Group g) throws PersistenceManagerException, UserDBException, RPCException {
        if (this.getName() != null) {
            g.setName(this.getName());
        }
        if (this.getDescription() != null) {
            g.setDescription(this.getDescription());
        }
        LinkedHashSet<PermissionID> permIDs = new LinkedHashSet<PermissionID>();
        PermissionManager permManager = Context.getUserDBAdmin().getPermissionManager();
        Permission[] oldPerms = g.getPermissions();
        PermissionID oldDiffRunPermID = null;
        if (oldPerms != null) {
            for (int i = 0; i < oldPerms.length; ++i) {
                PermissionID permID = oldPerms[i].getPermissionID();
                permIDs.add(permID);
                if (!oldPerms[i].getClassName().equals((class$com$raplix$rolloutexpress$difference$DifferencePermission == null ? GroupEditBase.class$("com.raplix.rolloutexpress.difference.DifferencePermission") : class$com$raplix$rolloutexpress$difference$DifferencePermission).getName())) continue;
                oldDiffRunPermID = permID;
            }
        }
        if (this.getHostWritePermission() != null) {
            if (this.getHostWritePermission().booleanValue()) {
                permIDs.add(permManager.getHostWritePermissionID());
                permIDs.add(permManager.getHostTypeWritePermissionID());
            } else {
                permIDs.remove(permManager.getHostWritePermissionID());
                permIDs.remove(permManager.getHostTypeWritePermissionID());
            }
        }
        if (this.getRuleWritePermission() != null) {
            if (this.getRuleWritePermission().booleanValue()) {
                permIDs.add(permManager.getRuleWritePermissionID());
            } else {
                permIDs.remove(permManager.getRuleWritePermissionID());
            }
        }
        if (this.getAdminWritePermission() != null) {
            if (this.getAdminWritePermission().booleanValue()) {
                permIDs.add(permManager.getUserDBWritePermissionID());
            } else {
                permIDs.remove(permManager.getUserDBWritePermissionID());
            }
        }
        if (this.getDiffWritePermission() != null) {
            if (this.getDiffWritePermission().booleanValue()) {
                permIDs.add(permManager.getDiffWritePermissionID());
            } else {
                permIDs.remove(permManager.getDiffWritePermissionID());
            }
        }
        if (this.getDiffRunPermission() != null) {
            permIDs.remove(oldDiffRunPermID);
            if (this.getDiffRunPermission().equals("allhosts")) {
                permIDs.add(permManager.getAllHostsRunDiffPermissionID());
            } else if (!this.getDiffRunPermission().equals("")) {
                String hostSetID = String2HostSetID.convert(this.getDiffRunPermission()).toString();
                String permName = "hostset:" + hostSetID;
                Permission[] pa = permManager.getPermissionsByCriteria(permName, DifferencePermission.class.getName(), null);
                if (pa.length == 0) {
                    PackageInfo.throwDiffRunPermissionNotFound(this.getDiffRunPermission());
                }
                permIDs.add(pa[0].getPermissionID());
            }
        }
        Permission[] perms = new Permission[permIDs.size()];
        Iterator ids = permIDs.iterator();
        int i = 0;
        while (ids.hasNext()) {
            perms[i] = permManager.getPermission((PermissionID)ids.next());
            ++i;
        }
        g.setPermissions(perms);
        if (this.getUsers() != null) {
            g.setUsers(this.getUsers());
        }
        if (this.getParentGroups() != null) {
            g.setParentGroups(this.getParentGroups());
        }
        if (this.getChildGroups() != null) {
            g.setChildGroups(this.getChildGroups());
        }
    }

    protected static abstract class GroupEditBaseHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.g.edit.";
        private static final String MSG_NAME_DESC = "KEY:ui.udb.g.edit.NAME_DESC";
        private static final String MSG_DESCRIPTION_DESC = "KEY:ui.udb.g.edit.DESCRIPTION_DESC";
        private static final String MSG_USERS_DESC = "KEY:ui.udb.g.edit.USERS_DESC";
        private static final String MSG_PARENT_GROUPS_DESC = "KEY:ui.udb.g.edit.PARENT_GROUPS_DESC";
        private static final String MSG_CHILD_GROUPS_DESC = "KEY:ui.udb.g.edit.CHILD_GROUPS_DESC";

        protected void addArguments(Vector map, boolean nameOptional) {
            if (nameOptional) {
                map.addElement(new CommandHelpBase.OptionalArgInfo("name", MSG_NAME_DESC, "n"));
            } else {
                map.addElement(new CommandHelpBase.RequiredArgInfo("name", MSG_NAME_DESC, "n"));
            }
            map.addElement(new CommandHelpBase.OptionalArgInfo("description", MSG_DESCRIPTION_DESC, "d"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("users", MSG_USERS_DESC, "ua"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("parentGroups", MSG_PARENT_GROUPS_DESC, "pga"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("childGroups", MSG_CHILD_GROUPS_DESC, "cga"));
        }

        GroupEditBaseHelp(Class cls, String desc) {
            super(cls, desc);
        }
    }
}

