/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.userdb.commands;

import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.io.IOException;
import java.util.Vector;

public class ChangePassword
extends SessionBase {
    private static CommandHelp sHelp = new ChangePasswordHelp();
    private String mUsername;
    private String mOldPassword;
    private String mNewPassword;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$userdb$commands$ChangePassword;

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setOldPlaintextPassword(String oldPlaintextPassword) {
        if (this.mOldPassword == null) {
            this.mOldPassword = oldPlaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getOldPassword() {
        return this.mOldPassword;
    }

    public void setNewPlaintextPassword(String newPlaintextPassword) {
        if (this.mNewPassword == null) {
            this.mNewPassword = newPlaintextPassword;
        } else {
            PackageInfo.throwBothEnPtPasswordFound();
        }
    }

    public String getNewPassword() {
        return this.mNewPassword;
    }

    public void setOldEncodedPassword(String oldEncodedPassword) throws IOException {
        this.setOldPlaintextPassword(ChangePassword.decodePassword(oldEncodedPassword));
    }

    public void setNewEncodedPassword(String newEncodedPassword) throws IOException {
        this.setNewPlaintextPassword(ChangePassword.decodePassword(newEncodedPassword));
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        UserManager userManager = Context.getUserDBAdmin().getUserManager();
        userManager.changePassword(this.getUsername(), this.getOldPassword(), this.getNewPassword());
    }

    protected static class ChangePasswordHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.udb.u.cp.";
        private static final String MSG_USERNAME_DESC = "KEY:ui.udb.u.cp.USERNAME_DESC";
        private static final String MSG_OLD_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.u.cp.OLD_PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_NEW_ENCODED_PASSWORD_DESC = "KEY:ui.udb.u.cp.NEW_ENCODED_PASSWORD_DESC";
        private static final String MSG_OLD_ENCODED_PASSWORD_DESC = "KEY:ui.udb.u.cp.OLD_ENCODED_PASSWORD_DESC";
        private static final String MSG_NEW_PLAINTEXT_PASSWORD_DESC = "KEY:ui.udb.u.cp.NEW_PLAINTEXT_PASSWORD_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.udb.u.cp.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("username", MSG_USERNAME_DESC, "un"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("oldPlaintextPassword", MSG_OLD_PLAINTEXT_PASSWORD_DESC, "op"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("newPlaintextPassword", MSG_NEW_PLAINTEXT_PASSWORD_DESC, "np"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("oldEncodedPassword", MSG_OLD_ENCODED_PASSWORD_DESC, "oep"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("newEncodedPassword", MSG_NEW_ENCODED_PASSWORD_DESC, "nep"));
            return map;
        }

        ChangePasswordHelp() {
            super(class$com$raplix$rolloutexpress$ui$userdb$commands$ChangePassword == null ? (class$com$raplix$rolloutexpress$ui$userdb$commands$ChangePassword = ChangePassword.class$("com.raplix.rolloutexpress.ui.userdb.commands.ChangePassword")) : class$com$raplix$rolloutexpress$ui$userdb$commands$ChangePassword, MSG_COMMAND_DESC);
        }
    }
}

