/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.serializers;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.ui.serializers.PackageInfo;

public class RPCWrapper
implements RPCSerializable {
    private static final int TYPE_BOOLEAN = 0;
    private static final int TYPE_BYTE = 1;
    private static final int TYPE_CHARACTER = 2;
    private static final int TYPE_DOUBLE = 3;
    private static final int TYPE_FLOAT = 4;
    private static final int TYPE_INTEGER = 5;
    private static final int TYPE_LONG = 6;
    private static final int TYPE_NULL = 7;
    private static final int TYPE_SHORT = 8;
    private static final int TYPE_STRING = 9;
    private static final int TYPE_UNKNOWN = 10;
    private int mType = 10;
    private String mString;
    private boolean mBoolean;
    private byte mByte;
    private double mDouble;
    private char mCharacter = (char)60;
    private float mFloat;
    private int mInteger;
    private long mLong;
    private short mShort;

    public RPCWrapper() {
    }

    public RPCWrapper(Object value) {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.mType = 7;
            return;
        }
        if (value instanceof Boolean) {
            this.mType = 0;
            this.mBoolean = (Boolean)value;
            return;
        }
        if (value instanceof Byte) {
            this.mType = 1;
            this.mByte = (Byte)value;
            return;
        }
        if (value instanceof Character) {
            this.mType = 2;
            this.mCharacter = ((Character)value).charValue();
            return;
        }
        if (value instanceof Double) {
            this.mType = 3;
            this.mDouble = (Double)value;
            return;
        }
        if (value instanceof Float) {
            this.mType = 4;
            this.mFloat = ((Float)value).floatValue();
            return;
        }
        if (value instanceof Integer) {
            this.mType = 5;
            this.mInteger = (Integer)value;
            return;
        }
        if (value instanceof Long) {
            this.mType = 6;
            this.mLong = (Long)value;
            return;
        }
        if (value instanceof Short) {
            this.mType = 8;
            this.mShort = (Short)value;
            return;
        }
        if (value instanceof String) {
            this.mType = 9;
            this.mString = (String)value;
            return;
        }
        PackageInfo.throwInvalidType(value.getClass());
    }

    public Object getValue() {
        switch (this.mType) {
            case 0: {
                return new Boolean(this.mBoolean);
            }
            case 1: {
                return new Byte(this.mByte);
            }
            case 2: {
                return new Character(this.mCharacter);
            }
            case 3: {
                return new Double(this.mDouble);
            }
            case 4: {
                return new Float(this.mFloat);
            }
            case 5: {
                return new Integer(this.mInteger);
            }
            case 6: {
                return new Long(this.mLong);
            }
            case 7: {
                return null;
            }
            case 8: {
                return new Short(this.mShort);
            }
            case 9: {
                return this.mString;
            }
        }
        PackageInfo.throwInvalidType(this.mType);
        return null;
    }
}

