/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.serializers;

import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.Serializer;
import com.raplix.rolloutexpress.ui.serializers.RPCWrapper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class RPCSerializer
implements Serializer {
    private static final String VERSION = "1.0";

    public Object read(InputStream in) throws Exception {
        Object value = Context.getNetSubsystem().getRPC().deSerializeObject(VERSION, new InputStreamReader(in));
        if (value instanceof RPCWrapper) {
            return ((RPCWrapper)value).getValue();
        }
        return value;
    }

    public void write(Object value, OutputStream out) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        RPCManager manager = Context.getNetSubsystem().getRPC();
        try {
            manager.serializeObject(VERSION, value, writer);
        }
        catch (Exception ex) {
            manager.serializeObject(VERSION, new RPCWrapper(value), writer);
        }
    }
}

