/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.rule.formatters;

import [Lcom.raplix.rolloutexpress.systemmodel.hostdbx.Host;;
import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaShorthand;
import com.raplix.rolloutexpress.event.rule.CriteriaShorthandManager;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.hostdbx.formatters.HostUtil;
import com.raplix.rolloutexpress.ui.rule.converters.SeverityArray2String;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;

public final class RuleUtil {
    private static final String RULE_FORMAT_PREFIX = "ui.rule.format.r.";
    private static final String RULE_ID_HEADER = "ui.rule.format.r.ID_HEADER";
    private static final String RULE_NAME_HEADER = "ui.rule.format.r.NAME_HEADER";
    private static final String RULE_DESCRIPTION_HEADER = "ui.rule.format.r.DESCRIPTION_HEADER";
    private static final String CRITERIA_FORMAT_PREFIX = "ui.rule.format.c.";
    private static final String CRITERIA_EVENT_TYPES_HEADER = "ui.rule.format.c.EVENT_TYPES_HEADER";
    private static final String CRITERIA_MESSAGE_PATTERN_HEADER = "ui.rule.format.c.MESSAGE_PATTERN_HEADER";
    private static final String CRITERIA_HOSTS_HEADER = "ui.rule.format.c.HOSTS_HEADER";
    private static final String CRITERIA_HOST_SET_HEADER = "ui.rule.format.c.HOST_SET_HEADER";
    private static final String CRITERIA_SEVERITIES_HEADER = "ui.rule.format.c.SEVERITIES_HEADER";
    private static final String ACTION_FORMAT_PREFIX = "ui.rule.format.a.";
    private static final String ACTION_TYPE_HEADER = "ui.rule.format.a.TYPE_HEADER";
    private static final String ACTION_EMAIL_ADDRESS_HEADER = "ui.rule.format.a.EMAIL_ADDRESS_HEADER";

    private RuleUtil() {
    }

    public static void detailedWrite(PrintWriter pw, RuleMetaData r, String prefix) throws Exception {
        ActionMetaData[] actions;
        pw.print(prefix);
        pw.println(RuleUtil.toText(RULE_ID_HEADER) + ": " + r.getRuleID());
        RuleUtil.summaryWrite(pw, r, prefix);
        pw.print(prefix);
        pw.println(RuleUtil.toText(RULE_DESCRIPTION_HEADER) + ": " + r.getDescription());
        CriteriaMetaData[] criteria = r.getCriteria();
        if (criteria != null && criteria.length > 0) {
            RuleUtil.detailedWrite(pw, criteria[0], prefix);
        }
        if ((actions = r.getActions()) != null && actions.length > 0) {
            RuleUtil.detailedWrite(pw, actions[0], prefix);
        }
    }

    public static void summaryWrite(PrintWriter pw, RuleMetaData r, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(RuleUtil.toText(RULE_NAME_HEADER) + ": " + r.getName());
    }

    public static void detailedWrite(PrintWriter pw, CriteriaMetaData c, String prefix) throws Exception {
        int[] severities;
        HostSetID hostSet;
        HostID[] hosts;
        String message;
        CriteriaShorthand shorthand = RuleUtil.getShorthand(c);
        if (shorthand != null) {
            pw.print(prefix);
            pw.println(RuleUtil.toText(CRITERIA_EVENT_TYPES_HEADER) + ": " + shorthand.getDisplayName());
        }
        if ((message = c.getMessagePattern()) != null && message.length() > 0) {
            pw.print(prefix);
            pw.println(RuleUtil.toText(CRITERIA_MESSAGE_PATTERN_HEADER) + ": " + message);
        }
        if ((hosts = c.getHosts()) != null && hosts.length > 0) {
            pw.print(prefix);
            pw.println(RuleUtil.toText(CRITERIA_HOSTS_HEADER) + ":");
            SummaryHost[] hostObjs = (Host[])Context.getConverterHandler().convert(hosts, Host;.class);
            HostUtil.write(pw, hostObjs, prefix + " ");
        }
        if ((hostSet = c.getHostSet()) != null) {
            pw.print(prefix);
            pw.println(RuleUtil.toText(CRITERIA_HOST_SET_HEADER) + ":");
            HostSet hostSetObj = (HostSet)Context.getConverterHandler().convert(hostSet, HostSet.class);
            HostUtil.write(pw, new HostSet[]{hostSetObj}, prefix + " ");
        }
        if ((severities = c.getSeverities()) != null && severities.length > 0) {
            pw.print(prefix);
            pw.println(RuleUtil.toText(CRITERIA_SEVERITIES_HEADER) + ": " + RuleUtil.severityArray2String(severities));
        }
    }

    public static CriteriaShorthand getShorthand(CriteriaMetaData criteria) {
        return CriteriaShorthandManager.INST.getShorthand(criteria);
    }

    private static String severityArray2String(int[] severities) {
        return SeverityArray2String.convert(severities);
    }

    private static void writeArray(PrintWriter pw, Object[] a, String prefix, String headerKey, int width) throws Exception {
        Column[] columns = new Column[]{new Column(width, 0, RuleUtil.toText(headerKey))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].toString();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void detailedWrite(PrintWriter pw, ActionMetaData a, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(RuleUtil.toText(ACTION_TYPE_HEADER) + ": " + a.getActionType());
        pw.print(prefix);
        pw.println(RuleUtil.toText(ACTION_EMAIL_ADDRESS_HEADER) + ": " + a.getEmailAddress());
    }

    public static void detailedWrite(PrintWriter pw, RuleMetaData[] ra, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, RuleUtil.toText(RULE_ID_HEADER)), new Column(15, 0, RuleUtil.toText(RULE_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < ra.length; ++i) {
            data[0] = ra[i].getRuleID().toString();
            data[1] = ra[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

