/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.rule.formatters;

import [Lcom.raplix.rolloutexpress.event.rule.RuleMetaData;;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.rule.formatters.PackageInfo;
import com.raplix.rolloutexpress.ui.rule.formatters.RuleUtil;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class FormatterBase
implements Formatter {
    private static final String NO_RESULT = "ui.rule.format.NO_RESULT";

    private Object convert(Object src, Class dstClass) throws Exception {
        try {
            return Context.getConverterHandler().convert(src, dstClass);
        }
        catch (ConverterNotFoundException ex) {
            return null;
        }
    }

    private void write(Object src, PrintWriter pw) throws Exception {
        if (src == null) {
            pw.println(Context.getMessageText(NO_RESULT));
            return;
        }
        Object result = this.convert(src, RuleMetaData.class);
        if (result != null) {
            this.write((RuleMetaData)result, pw);
            return;
        }
        result = this.convert(src, RuleMetaData;.class);
        if (result != null) {
            this.write((RuleMetaData[])result, pw);
            return;
        }
        PackageInfo.throwCannotWrite(src);
    }

    protected abstract void write(RuleMetaData var1, PrintWriter var2) throws Exception;

    protected void write(RuleMetaData[] ra, PrintWriter pw) throws Exception {
        RuleUtil.detailedWrite(pw, ra, "");
    }

    public void write(Object src, OutputStream out) throws Exception {
        PrintWriter pw = new PrintWriter(out);
        this.write(src, pw);
        pw.flush();
    }
}

