/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.rule.converters;

import com.raplix.rolloutexpress.ui.Context;
import java.util.Vector;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String PACKAGE_PREFIX = "ui.rule.convert";
    public static final String MSG_EX_INVALID_SEVERITY_ARRAY = "ui.rule.convert.EX_INVALID_SEVERITY_ARRAY";
    public static final String MSG_EX_INVALID_SEVERITY_STRING = "ui.rule.convert.EX_INVALID_SEVERITY_STRING";
    public static final String MSG_EX_INVALID_HOST_STATUS = "ui.rule.convert.EX_INVALID_HOST_STATUS";
    public static final String MSG_UNKNOWN_HOST_STATUS = "ui.rule.convert.UNKNOWN_HOST_STATUS";
    public static final String MSG_EX_NO_SUCH_SHORTHAND = "ui.rule.convert.EX_NO_SUCH_SHORTHAND";

    private PackageInfo() {
    }

    public static void throwInvalidSeverity(String severity) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_INVALID_SEVERITY_STRING, severity));
    }

    public static void throwInvalidSeverity(int[] severities) {
        Vector<Integer> sevs = new Vector<Integer>();
        for (int i = 0; i < severities.length; ++i) {
            sevs.addElement(new Integer(severities[i]));
        }
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_INVALID_SEVERITY_ARRAY, sevs));
    }

    public static void throwInvalidHostStatus(String hostStatus) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_INVALID_HOST_STATUS, hostStatus));
    }

    public static String unknownHostStatus(int hostStatus) {
        return PackageInfo.toText(MSG_UNKNOWN_HOST_STATUS, new Integer(hostStatus));
    }

    public static void throwNoSuchShorthand(String shorthandName) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_NO_SUCH_SHORTHAND, shorthandName));
    }

    public static String toText(String messageKey, Object arg) {
        return Context.getMessageText(messageKey, arg);
    }
}

