/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.rule.commands;

import com.raplix.rolloutexpress.event.rule.ActionMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaMetaData;
import com.raplix.rolloutexpress.event.rule.CriteriaShorthand;
import com.raplix.rolloutexpress.event.rule.RuleMetaData;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.rule.converters.String2SeverityArray;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public abstract class RuleEditBase
extends SessionBase {
    private String mName;
    private String mDescription;
    private Boolean mIsActive;
    private CriteriaShorthand mCriteriaShorthand;
    private String mCriteriaMessagePattern;
    private HostID[] mCriteriaHosts;
    private HostSetID mCriteriaHostSet;
    private String mCriteriaSeverities;
    private String mActionEmailAddress;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setIsActive(Boolean isActive) {
        this.mIsActive = isActive;
    }

    public Boolean getIsActive() {
        return this.mIsActive;
    }

    public CriteriaShorthand getCriteriaShorthand() {
        return this.mCriteriaShorthand;
    }

    public void setCriteriaShorthand(CriteriaShorthand criteriaShorthand) {
        this.mCriteriaShorthand = criteriaShorthand;
    }

    public void setCriteriaMessagePattern(String criteriaMessagePattern) {
        this.mCriteriaMessagePattern = criteriaMessagePattern;
    }

    public String getCriteriaMessagePattern() {
        return this.mCriteriaMessagePattern;
    }

    public void setCriteriaHosts(HostID[] criteriaHosts) {
        this.mCriteriaHosts = criteriaHosts;
    }

    public HostID[] getCriteriaHosts() {
        return this.mCriteriaHosts;
    }

    public void setCriteriaHostSet(HostSetID criteriaHostSet) {
        this.mCriteriaHostSet = criteriaHostSet;
    }

    public HostSetID getCriteriaHostSet() {
        return this.mCriteriaHostSet;
    }

    public void setCriteriaSeverities(String criteriaSeverities) {
        this.mCriteriaSeverities = criteriaSeverities;
    }

    public String getCriteriaSeverities() {
        return this.mCriteriaSeverities;
    }

    public void setActionEmailAddress(String actionEmailAddress) {
        this.mActionEmailAddress = actionEmailAddress;
    }

    public String getActionEmailAddress() {
        return this.mActionEmailAddress;
    }

    protected void setRule(RuleMetaData r) throws Exception {
        if (this.getName() != null) {
            r.setName(this.getName());
        }
        if (this.getDescription() != null) {
            r.setDescription(this.getDescription());
        }
        if (this.getIsActive() != null) {
            r.setIsActive(this.getIsActive());
        }
        this.setCriteria(r.getCriteria()[0]);
        this.setAction(r.getActions()[0]);
    }

    private void setCriteria(CriteriaMetaData c) throws Exception {
        String severities;
        HostSetID hostSet;
        if (this.getCriteriaShorthand() != null) {
            this.getCriteriaShorthand().apply(c);
        }
        if (this.getCriteriaMessagePattern() != null) {
            c.setMessagePattern(this.getCriteriaMessagePattern());
        }
        if (this.getCriteriaHosts() != null) {
            c.setHosts(this.getCriteriaHosts());
        }
        if ((hostSet = this.getCriteriaHostSet()) != null) {
            if (hostSet.toString().length() == 0) {
                hostSet = null;
            }
            c.setHostSet(hostSet);
        }
        if ((severities = this.getCriteriaSeverities()) != null) {
            c.setSeverities(this.string2SeverityArray(severities));
        }
    }

    private int[] string2SeverityArray(String src) throws Exception {
        return String2SeverityArray.convert(src);
    }

    private void setAction(ActionMetaData a) {
        if (this.getActionEmailAddress() != null) {
            a.setEmailAddress(this.getActionEmailAddress());
        }
    }

    protected static abstract class RuleEditBaseHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.rule.edit.";
        private static final String MSG_NAME_DESC = "KEY:ui.rule.edit.NAME_DESC";
        private static final String MSG_DESCRIPTION_DESC = "KEY:ui.rule.edit.DESCRIPTION_DESC";
        private static final String MSG_IS_ACTIVE_DESC = "KEY:ui.rule.edit.IS_ACTIVE_DESC";
        private static final String MSG_CRITERIA_SHORTHAND_DESC = "KEY:ui.rule.edit.c.SHORTHAND_DESC";
        private static final String MSG_CRITERIA_MESSAGE_PATTERN_DESC = "KEY:ui.rule.edit.c.MESSAGE_PATTERN_DESC";
        private static final String MSG_CRITERIA_HOSTS_DESC = "KEY:ui.rule.edit.c.HOSTS_DESC";
        private static final String MSG_CRITERIA_HOST_SET_DESC = "KEY:ui.rule.edit.c.HOST_SET_DESC";
        private static final String MSG_CRITERIA_SEVERITIES_DESC = "KEY:ui.rule.edit.c.SEVERITIES_DESC";
        private static final String MSG_ACTION_EMAIL_ADDRESS_DESC = "KEY:ui.rule.edit.a.EMAIL_ADDRESS_DESC";

        protected void addArguments(Vector map, boolean nameOptional, boolean emailOptional) {
            if (nameOptional) {
                map.addElement(new CommandHelpBase.OptionalArgInfo("name", MSG_NAME_DESC, "n"));
            } else {
                map.addElement(new CommandHelpBase.RequiredArgInfo("name", MSG_NAME_DESC, "n"));
            }
            map.addElement(new CommandHelpBase.OptionalArgInfo("description", MSG_DESCRIPTION_DESC, "d"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("criteriaShorthand", MSG_CRITERIA_SHORTHAND_DESC, "tf"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("criteriaMessagePattern", MSG_CRITERIA_MESSAGE_PATTERN_DESC, "mf"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("criteriaHosts", MSG_CRITERIA_HOSTS_DESC, "haf"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("criteriaHostSet", MSG_CRITERIA_HOST_SET_DESC, "hsf"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("criteriaSeverities", MSG_CRITERIA_SEVERITIES_DESC, "sf"));
            if (emailOptional) {
                map.addElement(new CommandHelpBase.OptionalArgInfo("actionEmailAddress", MSG_ACTION_EMAIL_ADDRESS_DESC, "ea"));
            } else {
                map.addElement(new CommandHelpBase.RequiredArgInfo("actionEmailAddress", MSG_ACTION_EMAIL_ADDRESS_DESC, "ea"));
            }
        }

        RuleEditBaseHelp(Class cls, String desc) {
            super(cls, desc);
        }
    }
}

