/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.resource.formatters;

import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCancelled;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompWasRedundant;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.plandb.formatters.PlanDBUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import java.io.PrintWriter;
import java.util.Date;

public final class ResourceUtil {
    private static final String RESOURCE_FORMAT_PREFIX = "ui.rsrc.format.ri.";
    private static final String RESOURCE_NONE = "ui.rsrc.format.ri.NONE";
    private static final String CJ_FORMAT_PREFIX = "ui.rsrc.format.cj.";
    private static final String CJ_ID_HEADER = "ui.rsrc.format.cj.ID_HEADER";
    private static final String CJ_HOST_HEADER = "ui.rsrc.format.cj.HOST_HEADER";
    private static final String CJ_RESOURCE_HEADER = "ui.rsrc.format.cj.RESOURCE_HEADER";
    private static final String CJ_TYPE_HEADER = "ui.rsrc.format.cj.TYPE_HEADER";
    private static final String CJ_CHECKED_IN_HEADER = "ui.rsrc.format.cj.CHECKED_IN_HEADER";
    private static final String CJ_STATUS_HEADER = "ui.rsrc.format.cj.STATUS_HEADER";
    private static final String CJ_STATUS_CANCELLED = "ui.rsrc.format.cj.cancelled";
    private static final String CJ_STATUS_FAILED = "ui.rsrc.format.cj.failed";
    private static final String CJ_STATUS_IN_PROGRESS = "ui.rsrc.format.cj.inprogress";
    private static final String CJ_STATUS_SUCCEEDED = "ui.rsrc.format.cj.succeeded";
    private static final String CJ_STATUS_WAS_REDUNDANT = "ui.rsrc.format.cj.currentasis";
    private static final String BI_FORMAT_PREFIX = "ui.rsrc.format.bi.";
    private static final String BI_INDEX_HEADER = "ui.rsrc.format.bi.INDEX_HEADER";
    private static final String BI_PICKER_NAME_HEADER = "ui.rsrc.format.bi.PICKER_NAME_HEADER";
    private static final String BI_OPTIONS_HEADER = "ui.rsrc.format.bi.OPTIONS_HEADER";

    private ResourceUtil() {
    }

    public static void write(PrintWriter pw, CompCheckInInfo info, String prefix) throws Exception {
        String hostName = info.getHostName();
        if (hostName == null) {
            hostName = ResourceUtil.toText(RESOURCE_NONE);
        }
        pw.print(prefix);
        pw.println(ResourceUtil.toText(CJ_ID_HEADER) + ": " + info.getID());
        pw.print(prefix);
        pw.println(ResourceUtil.toText(CJ_HOST_HEADER) + ": " + hostName);
        pw.print(prefix);
        pw.println(ResourceUtil.toText(CJ_RESOURCE_HEADER) + ": " + info.getComponentName());
        pw.print(prefix);
        pw.println(ResourceUtil.toText(CJ_TYPE_HEADER) + ": " + info.getComponentType());
        pw.print(prefix);
        ResourceUtil.write(pw, info.getStatus(), prefix);
    }

    public static void write(PrintWriter pw, CompStatus status, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ResourceUtil.toText(CJ_CHECKED_IN_HEADER) + ": " + (status instanceof CompPending ? "" : Util.formatDate(new Date(status.getEndTime()))));
        pw.print(prefix);
        pw.println(ResourceUtil.toText(CJ_STATUS_HEADER) + ": " + ResourceUtil.getStatusAsString(status));
    }

    public static void write(PrintWriter pw, CompCheckInInfo[] a, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, ResourceUtil.toText(CJ_ID_HEADER)), new Column(20, 0, ResourceUtil.toText(CJ_RESOURCE_HEADER)), new Column(10, 0, ResourceUtil.toText(CJ_TYPE_HEADER)), new Column(7, 0, ResourceUtil.toText(CJ_STATUS_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[4];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].getID().toString();
            data[1] = a[i].getComponentName();
            data[2] = a[i].getComponentType();
            data[3] = ResourceUtil.getStatusAsString(a[i].getStatus());
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, BrowserInfo[] a, String prefix) throws Exception {
        for (int i = 0; i < a.length; ++i) {
            pw.print(prefix);
            pw.println(ResourceUtil.toText(BI_INDEX_HEADER) + ": " + (i + 1));
            ResourceUtil.write(pw, a[i], prefix + " ");
        }
    }

    public static void write(PrintWriter pw, BrowserInfo browserInfo, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ResourceUtil.toText(BI_PICKER_NAME_HEADER) + ": " + browserInfo.getBrowserType());
        pw.print(prefix);
        pw.println(ResourceUtil.toText(BI_OPTIONS_HEADER) + ":");
        PlanDBUtil.write(pw, browserInfo.getCheckinOptions(), prefix);
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }

    public static String getStatusAsString(CompStatus status) {
        String statusStr = "";
        if (status instanceof CompError) {
            statusStr = ResourceUtil.toText(CJ_STATUS_FAILED);
        } else if (status instanceof CompPending) {
            statusStr = ResourceUtil.toText(CJ_STATUS_IN_PROGRESS);
        } else if (status instanceof CompCancelled) {
            statusStr = ResourceUtil.toText(CJ_STATUS_CANCELLED);
        } else if (status instanceof CompComplete) {
            statusStr = ResourceUtil.toText(CJ_STATUS_SUCCEEDED);
        } else if (status instanceof CompWasRedundant) {
            statusStr = ResourceUtil.toText(CJ_STATUS_WAS_REDUNDANT);
        }
        return statusStr;
    }
}

