/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.resource.commands;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.converters.String2Hashtable;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostID;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostSetID;
import com.raplix.rolloutexpress.ui.resource.commands.CheckIn;
import com.raplix.rolloutexpress.ui.resource.commands.ResourceLineParseException;
import com.raplix.rolloutexpress.ui.resource.commands.StringParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class ParsedBatchEntry {
    private String mSrcString;
    private String mDstString;
    private String mType = null;
    private HostSetID mPlatform = null;
    private String mDescription = null;
    private boolean mIsConfig = false;
    private boolean mIsMajor = false;
    private boolean mIsHidePrev = true;
    private boolean mIncludeOwners = true;
    private boolean mIncludeGroups = true;
    private boolean mAddTo = false;
    private HostID mHostID = null;
    private boolean mRedun = true;
    private String mPickerName = null;
    private Hashtable mExtraOpts = null;

    public ParsedBatchEntry(String inSrcString, String inDstString, String inType, HostSetID inPlatform, String inDescription, boolean inIsConfig, boolean inIsMajor, boolean inIsHidePrev, boolean inIncludeOwners, boolean inIncludeGroups, boolean inAddTo, HostID inHostID, boolean inRedun, String pickerName, Hashtable extraOpts) {
        this.mSrcString = FileSpec.convertPathSeparatorToLocal(inSrcString);
        this.mDstString = inDstString;
        this.mType = inType;
        this.mPlatform = inPlatform;
        this.mDescription = inDescription;
        this.mIsConfig = inIsConfig;
        this.mIsMajor = inIsMajor;
        this.mIsHidePrev = inIsHidePrev;
        this.mIncludeOwners = inIncludeOwners;
        this.mIncludeGroups = inIncludeGroups;
        this.mAddTo = inAddTo;
        this.mHostID = inHostID;
        this.mRedun = inRedun;
        this.mPickerName = pickerName;
        this.mExtraOpts = extraOpts;
    }

    public boolean equals(ParsedBatchEntry inOther) {
        if (!this.mSrcString.equals(inOther.mSrcString)) {
            return false;
        }
        if (!this.mDstString.equals(inOther.mDstString)) {
            return false;
        }
        if (!this.possiblyNullEquals(this.mType, inOther.mType)) {
            return false;
        }
        if (!this.possiblyNullEquals(this.mPlatform, inOther.mPlatform)) {
            return false;
        }
        if (!this.possiblyNullEquals(this.mDescription, inOther.mDescription)) {
            return false;
        }
        if (this.mIsConfig != inOther.mIsConfig) {
            return false;
        }
        if (this.mIsMajor != inOther.mIsMajor) {
            return false;
        }
        if (this.mIsHidePrev != inOther.mIsHidePrev) {
            return false;
        }
        if (this.mIncludeOwners != inOther.mIncludeOwners) {
            return false;
        }
        if (this.mIncludeGroups != inOther.mIncludeGroups) {
            return false;
        }
        if (this.mAddTo != inOther.mAddTo) {
            return false;
        }
        if (!this.possiblyNullEquals(this.mHostID, inOther.mHostID)) {
            return false;
        }
        if (this.mRedun != inOther.mRedun) {
            return false;
        }
        if (!this.possiblyNullEquals(this.mPickerName, inOther.mPickerName)) {
            return false;
        }
        return this.possiblyNullEquals(this.mExtraOpts, inOther.mExtraOpts);
    }

    boolean possiblyNullEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String getSrc() {
        return this.mSrcString;
    }

    public String getURL() {
        return this.mDstString;
    }

    CompCheckInID doCheckIn() throws Exception {
        return CheckIn.doCheckIn(this.mSrcString, this.mDstString, this.mType, this.mPlatform, this.mDescription, this.mIsConfig, this.mIsMajor, this.mIsHidePrev, this.mIncludeOwners, this.mIncludeGroups, this.mAddTo, this.mHostID, this.mRedun, this.mPickerName, this.mExtraOpts);
    }

    static void ensureReadAccessible(File inFile) throws Exception {
        if (inFile.isFile()) {
            FileInputStream theFileInputStream = new FileInputStream(inFile);
            theFileInputStream.close();
        } else {
            File[] theSubFiles = inFile.listFiles();
            if (theSubFiles != null) {
                for (int i = 0; i < theSubFiles.length; ++i) {
                    ParsedBatchEntry.ensureReadAccessible(theSubFiles[i]);
                }
            }
        }
    }

    private static boolean parseBoolean(String inString, boolean inDefault) throws Exception {
        if (inString == null) {
            return inDefault;
        }
        if (inString.toLowerCase().equals(Context.getMessageText("ui.cdb.rsrc.cib.TRUE"))) {
            return true;
        }
        if (inString.toLowerCase().equals(Context.getMessageText("ui.cdb.rsrc.cib.FALSE"))) {
            return false;
        }
        if (inString.trim().toLowerCase().equals(Context.getMessageText("ui.cdb.rsrc.cib.TRUE")) || inString.trim().toLowerCase().equals(Context.getMessageText("ui.cdb.rsrc.cib.FALSE"))) {
            throw new ResourceLineParseException("rsrc.msg0240", new Object[]{inString});
        }
        throw new ResourceLineParseException("rsrc.msg0241", new Object[]{inString});
    }

    private static Hashtable parseHashtable(String s) throws Exception {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return String2Hashtable.convert(s);
    }

    private static HostID parseHostID(String s) throws Exception {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return String2HostID.convert(s);
    }

    private static HostSetID parseHostSetID(String s) throws Exception {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return String2HostSetID.convert(s);
    }

    public static ParsedBatchEntry[] parseEntries(InputStream inStream, boolean inVerifyExistence, File inBaseDir) throws Exception {
        String theLineText;
        ArrayList<ParsedBatchEntry> theEntryArrayList = new ArrayList<ParsedBatchEntry>();
        theEntryArrayList.ensureCapacity(20);
        BufferedReader theBufferedReader = new BufferedReader(new InputStreamReader(inStream));
        int theLineNumber = 1;
        while ((theLineText = theBufferedReader.readLine()) != null) {
            if (theLineText.trim().length() != 0 && theLineText.charAt(0) != '#') {
                ParsedBatchEntry theEntry = ParsedBatchEntry.parseOneLine(theLineText, theLineNumber, inVerifyExistence, inBaseDir);
                theEntryArrayList.add(theEntry);
            }
            ++theLineNumber;
        }
        ParsedBatchEntry[] theResults = theEntryArrayList.toArray(new ParsedBatchEntry[0]);
        return theResults;
    }

    private static ParsedBatchEntry parseOneLine(String inTextLine, int inLineNumber, boolean inVerifyExistence, File inBaseDir) throws Exception {
        String theType;
        String theDstString;
        String theSrcString;
        HostSetID thePlatform = null;
        String theDescription = null;
        boolean isConfig = false;
        boolean isMajor = false;
        boolean isHidePrev = true;
        boolean includeOwners = true;
        boolean includeGroups = true;
        boolean addTo = false;
        HostID hostID = null;
        boolean redun = true;
        String pickerName = null;
        Hashtable extraOpts = null;
        StringParser theLineTokenizer = new StringParser(inTextLine, '|');
        String theLineNumberString = "" + inLineNumber;
        try {
            if (!theLineTokenizer.hasMoreTokens()) {
                throw new ResourceLineParseException("rsrc.msg0224");
            }
            theSrcString = theLineTokenizer.nextToken();
            if (theSrcString == null) {
                throw new ResourceLineParseException("rsrc.msg0225");
            }
            theSrcString = FileSpec.convertPathSeparatorToLocal(theSrcString);
            if (!theLineTokenizer.hasMoreTokens()) {
                throw new ResourceLineParseException("rsrc.msg0228");
            }
            theDstString = theLineTokenizer.nextToken();
            if (theDstString == null) {
                throw new ResourceLineParseException("rsrc.msg0229");
            }
            if (!theLineTokenizer.hasMoreTokens()) {
                throw new ResourceLineParseException("rsrc.msg0405");
            }
            theType = theLineTokenizer.nextToken();
            if (theType == null) {
                throw new ResourceLineParseException("rsrc.msg0405");
            }
            if (theLineTokenizer.hasMoreTokens()) {
                thePlatform = ParsedBatchEntry.parseHostSetID(theLineTokenizer.nextToken());
            }
            if (theLineTokenizer.hasMoreTokens()) {
                theDescription = theLineTokenizer.nextToken();
            }
            if (theLineTokenizer.hasMoreTokens()) {
                isConfig = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), isConfig);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                isMajor = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), isMajor);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                isHidePrev = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), isHidePrev);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                includeOwners = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), includeOwners);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                includeGroups = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), includeGroups);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                addTo = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), addTo);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                hostID = ParsedBatchEntry.parseHostID(theLineTokenizer.nextToken());
            }
            if (theLineTokenizer.hasMoreTokens()) {
                redun = ParsedBatchEntry.parseBoolean(theLineTokenizer.nextToken(), redun);
            }
            if (theLineTokenizer.hasMoreTokens()) {
                pickerName = theLineTokenizer.nextToken();
            }
            if (theLineTokenizer.hasMoreTokens()) {
                extraOpts = ParsedBatchEntry.parseHashtable(theLineTokenizer.nextToken());
            }
            if (theLineTokenizer.hasMoreTokens()) {
                throw new ResourceLineParseException("rsrc.msg0230");
            }
            if (hostID == null) {
                File theFile = new File(theSrcString);
                if (!theFile.isAbsolute()) {
                    theFile = new File(ResourceStringUtils.toNativePath(inBaseDir.getCanonicalPath() + File.separator + theSrcString));
                }
                theSrcString = theFile.getAbsolutePath();
                if (inVerifyExistence) {
                    if (!theFile.exists()) {
                        throw new ResourceLineParseException("rsrc.msg0227", new Object[]{theFile.getAbsoluteFile()});
                    }
                    ParsedBatchEntry.ensureReadAccessible(theFile);
                }
            }
        }
        catch (ResourceLineParseException e) {
            throw new ResourceException("rsrc.msg0231", new Object[]{theLineNumberString, e.getLocalizedMessage()});
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0232", (Throwable)e, new Object[]{theLineNumberString});
        }
        return new ParsedBatchEntry(theSrcString, theDstString, theType, thePlatform, theDescription, isConfig, isMajor, isHidePrev, includeOwners, includeGroups, addTo, hostID, redun, pickerName, extraOpts);
    }
}

