/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.resource.commands;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.CliRsrcData;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourcePersistenceException;
import com.raplix.rolloutexpress.resource.packageformat.ZipFileExpander;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.util.Vector;

public class GetResource
extends SessionBase {
    private static CommandHelp sHelp = new GetResourceHelp();
    private CliRsrcData mRsrcData = null;
    private String mSrcFileStr = null;
    private String mVersStr = null;
    private String mDstStr = null;
    private String mResult = null;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$resource$commands$GetResource;

    public void setsrc(String inFileStr) {
        this.mSrcFileStr = inFileStr;
    }

    public String getsrc() {
        return this.mSrcFileStr;
    }

    public void setv(String inFileStr) {
        this.mVersStr = inFileStr;
    }

    public String getv() {
        return this.mVersStr;
    }

    public void setdst(String inFileStr) {
        this.mDstStr = inFileStr;
    }

    public String getdst() {
        return this.mDstStr;
    }

    protected void setResult(String inResult) {
        this.mResult = inResult;
    }

    public String getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        CliRsrcData theRsrcData = Context.getCliRsrcData();
        if (this.mVersStr == null) {
            throw new ResourceException("rsrc.msg0235");
        }
        if (this.mDstStr == null) {
            throw new ResourceException("rsrc.msg0236");
        }
        File theDstFile = new File(this.mDstStr);
        if (theDstFile.exists()) {
            throw new ResourceException("rsrc.msg0237");
        }
        File theLocalTmpFile = new File(theDstFile.getAbsolutePath() + "_tmp");
        theLocalTmpFile.delete();
        FolderID folderID = SingleFolderQuery.byPath(Util.fullNameToPath(this.mSrcFileStr)).selectSummaryView().getID();
        Component c = SingleComponentQuery.byName(folderID, Util.fullNameToShortName(this.mSrcFileStr), this.mVersStr).select();
        RsrcInfo theRsrcInfo = c.getResource();
        if (theRsrcInfo == null) {
            throw new ResourceException("ui.cdb.rsrc.co.EX_UNABLE_TO_DOWNLOAD");
        }
        ResourceSpec theResourceSpec = theRsrcInfo.getResourceSpec();
        VersionNumber theVersionNumber = theRsrcInfo.getVersionNumber();
        try {
            theRsrcInfo = theRsrcData.getRemoteResourceMgr().sendResourceAsZipFile(theResourceSpec, theVersionNumber, new AbsoluteFileSpec(theLocalTmpFile));
        }
        catch (ResourcePersistenceException e) {
            this.setResult("ERROR: resource not found: " + theResourceSpec + StringUtil.LINE_SEPARATOR);
            return;
        }
        try {
            new ZipFileExpander(theLocalTmpFile, theDstFile, false).parse();
        }
        finally {
            theLocalTmpFile.delete();
        }
        this.setResult("The operation is complete" + StringUtil.LINE_SEPARATOR);
    }

    protected static class GetResourceHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.rsrc.co.";

        GetResourceHelp() {
            super(class$com$raplix$rolloutexpress$ui$resource$commands$GetResource == null ? (class$com$raplix$rolloutexpress$ui$resource$commands$GetResource = GetResource.class$("com.raplix.rolloutexpress.ui.resource.commands.GetResource")) : class$com$raplix$rolloutexpress$ui$resource$commands$GetResource, "KEY:ui.cdb.rsrc.co.COMMAND_DESC");
        }

        protected Vector getArgumentMap() {
            Vector theMap = super.getArgumentMap();
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("src", "KEY:ui.cdb.rsrc.co.SRC_DESC"));
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("v", "KEY:ui.cdb.rsrc.co.VERS_DESC"));
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("dst", "KEY:ui.cdb.rsrc.co.DST_DESC"));
            return theMap;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", "KEY:ui.cdb.rsrc.co.RESULT_DESC");
        }
    }
}

