/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.resource.commands;

import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.resource.commands.CheckIn;
import com.raplix.rolloutexpress.ui.resource.commands.ParsedBatchEntry;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class CheckInBatch
extends SessionBase {
    static final String MSG_PREFIX = "ui.cdb.rsrc.cib.";
    static final String MSG_TRUE = "ui.cdb.rsrc.cib.TRUE";
    static final String MSG_FALSE = "ui.cdb.rsrc.cib.FALSE";
    private static final String MSG_CHECKING_IN = "ui.cdb.rsrc.cib.CHECKING_IN";
    private static final String MSG_ELIPSIS = "ui.cdb.rsrc.cib.ELIPSIS";
    private static final String MSG_WAS_CHECKED_IN_AS = "ui.cdb.rsrc.cib.WAS_CHECKED_IN_AS";
    private static final String MSG_VERSION = "ui.cdb.rsrc.cib.VERSION";
    private static final String MSG_CONTINUING = "ui.cdb.rsrc.cib.CONTINUING";
    private static final String MSG_ERR_HALTING = "ui.cdb.rsrc.cib.ERR_HALTING";
    private static final String MSG_COMPLETE = "ui.cdb.rsrc.cib.COMPLETE";
    private static final String MSG_HAD_ERRORS = "ui.cdb.rsrc.cib.HAD_ERRORS";
    private static final String MSG_ERRORS = "ui.cdb.rsrc.cib.ERRORS";
    private static CommandHelp sHelp = new CheckInBatchHelp();
    private String mBatchFile = null;
    private boolean mHaltOnError = true;
    private boolean mPwdRelative = false;
    private String mResult = null;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$resource$commands$CheckInBatch;

    public void setbatchfile(String inBatchFile) {
        this.mBatchFile = inBatchFile;
    }

    public String getbatchfile() {
        return this.mBatchFile;
    }

    public void sethaltonerror(boolean inHaltOnError) {
        this.mHaltOnError = inHaltOnError;
    }

    public boolean gethaltonerror() {
        return this.mHaltOnError;
    }

    public void setpwdrelative(boolean inPwdRelative) {
        this.mPwdRelative = inPwdRelative;
    }

    public boolean getpwdrelative() {
        return this.mPwdRelative;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    protected void setResult(String inResult) {
        this.mResult = inResult;
    }

    public String getResult() {
        return this.mResult;
    }

    private void infoPrintln(String inInfoString) {
        if (Logger.isInfoEnabled(this)) {
            Logger.info(inInfoString, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        File theBatchFile = new File(this.mBatchFile);
        if (!theBatchFile.exists()) {
            throw new ResourceException("rsrc.msg0222", new Object[]{theBatchFile.getAbsoluteFile()});
        }
        if (!theBatchFile.isFile()) {
            throw new ResourceException("rsrc.msg0223", new Object[]{theBatchFile.getAbsoluteFile()});
        }
        FileInputStream theBatchInput = new FileInputStream(theBatchFile);
        ParsedBatchEntry[] theEntries = null;
        try {
            File theBaseDir = this.mPwdRelative ? new File("").getAbsoluteFile() : theBatchFile.getAbsoluteFile().getParentFile();
            theEntries = ParsedBatchEntry.parseEntries(theBatchInput, true, theBaseDir);
        }
        finally {
            theBatchInput.close();
        }
        int theErrCount = 0;
        for (int i = 0; i < theEntries.length; ++i) {
            ParsedBatchEntry theEntry = theEntries[i];
            this.infoPrintln(Context.getMessageText(MSG_CHECKING_IN) + " " + theEntry.getSrc() + Context.getMessageText(MSG_ELIPSIS));
            try {
                CompCheckInInfo theCheckInInfo = CheckIn.getCompCheckInInfo(theEntry.doCheckIn());
                this.infoPrintln(theEntry.getSrc() + " " + Context.getMessageText(MSG_WAS_CHECKED_IN_AS) + " " + theCheckInInfo.getComponentName() + " " + Context.getMessageText(MSG_VERSION) + " " + theCheckInInfo.getComponentVersion().getAsString());
                continue;
            }
            catch (Exception e) {
                ++theErrCount;
                if (!this.mHaltOnError) {
                    String theMessage = e.toString();
                    if (theMessage != null) {
                        this.infoPrintln(theMessage);
                    }
                    this.infoPrintln("");
                    this.infoPrintln(Context.getMessageText(MSG_CONTINUING));
                    continue;
                }
                throw new Exception(Context.getMessageText(MSG_ERR_HALTING) + ": " + e.getMessage());
            }
        }
        this.infoPrintln("");
        String theResult = null;
        theResult = theErrCount == 0 ? Context.getMessageText(MSG_COMPLETE) : Context.getMessageText(MSG_HAD_ERRORS) + " " + theErrCount + " " + Context.getMessageText(MSG_ERRORS);
        this.infoPrintln(theResult);
        this.setResult(theResult);
    }

    protected static class CheckInBatchHelp
    extends SessionBase.SessionBaseHelp {
        static final String COMMAND_PREFIX = "KEY:ui.cdb.rsrc.cib.";

        CheckInBatchHelp() {
            super(class$com$raplix$rolloutexpress$ui$resource$commands$CheckInBatch == null ? (class$com$raplix$rolloutexpress$ui$resource$commands$CheckInBatch = CheckInBatch.class$("com.raplix.rolloutexpress.ui.resource.commands.CheckInBatch")) : class$com$raplix$rolloutexpress$ui$resource$commands$CheckInBatch, "KEY:ui.cdb.rsrc.cib.COMMAND_DESC");
        }

        protected Vector getArgumentMap() {
            Vector theMap = super.getArgumentMap();
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("batchfile", "KEY:ui.cdb.rsrc.cib.BATCHFILE_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("haltonerror", "KEY:ui.cdb.rsrc.cib.HALT_ON_ERR_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("pwdrelative", "KEY:ui.cdb.rsrc.cib.PWD_RELATIVE_DESC"));
            return theMap;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", "KEY:ui.cdb.rsrc.cib.RESULT_DESC");
        }
    }
}

