/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.resource.commands;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentExportServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ExportContext;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.CliRsrcData;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import com.sun.n1.util.vars.PromptParamList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class CheckIn
extends SessionBase {
    private static CommandHelp sHelp = new CheckInHelp();
    private CliRsrcData mRsrcData = null;
    private String mSrcFileStr = null;
    private String mDstCheckinStr = null;
    private String mType = null;
    private HostSetID mPlatform = null;
    private String mDescriptionStr = null;
    private boolean mIsMajor = false;
    private boolean mIsConfig = false;
    private boolean mIsHidePrev = true;
    private boolean mIsIncludeOwners = true;
    private boolean mIsIncludeGroups = true;
    private boolean mAddTo = false;
    private HostID mHostID = null;
    private boolean mRedun = true;
    private String mPickerName = null;
    private Hashtable mExtraOpts = null;
    private CompCheckInID mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$resource$commands$CheckIn;

    public String getSrc() {
        return this.mSrcFileStr;
    }

    public String getDst() {
        return this.mDstCheckinStr;
    }

    public String getType() {
        return this.mType;
    }

    public HostSetID getPlatform() {
        return this.mPlatform;
    }

    public String getDesc() {
        return this.mDescriptionStr;
    }

    public boolean getMajor() {
        return this.mIsMajor;
    }

    public boolean getConfig() {
        return this.mIsConfig;
    }

    public boolean getHideprev() {
        return this.mIsHidePrev;
    }

    public boolean getIncludeOwners() {
        return this.mIsIncludeOwners;
    }

    public boolean getIncludeGroups() {
        return this.mIsIncludeGroups;
    }

    public boolean getAddTo() {
        return this.mAddTo;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public boolean getRedun() {
        return this.mRedun;
    }

    public String getPickerName() {
        return this.mPickerName;
    }

    public Hashtable getExtraOpts() {
        return this.mExtraOpts;
    }

    public void setSrc(String inFileStr) {
        this.mSrcFileStr = inFileStr;
    }

    public void setDst(String inDstCheckinStr) {
        this.mDstCheckinStr = inDstCheckinStr;
    }

    public void setType(String inValue) {
        this.mType = inValue;
    }

    public void setPlatform(HostSetID inValue) {
        this.mPlatform = inValue;
    }

    public void setDesc(String inDescriptionStr) {
        this.mDescriptionStr = inDescriptionStr;
    }

    public void setMajor(boolean inIsMajor) {
        this.mIsMajor = inIsMajor;
    }

    public void setConfig(boolean inIsConfig) {
        this.mIsConfig = inIsConfig;
    }

    public void setHideprev(boolean inIsHidePrev) {
        this.mIsHidePrev = inIsHidePrev;
    }

    public void setIncludeOwners(boolean inIsIncludeOwners) {
        this.mIsIncludeOwners = inIsIncludeOwners;
    }

    public void setIncludeGroups(boolean inIsIncludeGroups) {
        this.mIsIncludeGroups = inIsIncludeGroups;
    }

    public void setAddTo(boolean inValue) {
        this.mAddTo = inValue;
    }

    public void setHostID(HostID inValue) {
        this.mHostID = inValue;
    }

    public void setRedun(boolean inValue) {
        this.mRedun = inValue;
    }

    public void setPickerName(String inValue) {
        this.mPickerName = inValue;
    }

    public void setExtraOpts(Hashtable inValue) {
        this.mExtraOpts = inValue;
    }

    public CompCheckInID getResult() {
        return this.mResult;
    }

    protected void setResult(CompCheckInID inResult) {
        this.mResult = inResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        if (this.mHostID == null) {
            File theSrcFile = new File(this.mSrcFileStr);
            if (!theSrcFile.exists()) {
                throw new ResourceException("rsrc.msg0216", new Object[]{this.mSrcFileStr});
            }
            this.mSrcFileStr = theSrcFile.getAbsolutePath();
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Checking in " + this.mSrcFileStr + "...", this);
        }
        this.setResult(CheckIn.doCheckIn(this.mSrcFileStr, this.mDstCheckinStr, this.mType, this.mPlatform, this.mDescriptionStr, this.mIsConfig, this.mIsMajor, this.mIsHidePrev, this.mIsIncludeOwners, this.mIsIncludeGroups, this.mAddTo, this.mHostID, this.mRedun, this.mPickerName, this.mExtraOpts));
    }

    static CompCheckInID doCheckIn(String src, String dst, String type, HostSetID platform, String description, boolean isConfig, boolean isMajor, boolean isHidePrev, boolean includeOwners, boolean includeGroups, boolean addTo, HostID hostID, boolean redun, String pickerName, Hashtable extraOpts) throws ResourceException, FileNotFoundException, InterruptedException, IOException, RPCException, RaplixException, Exception {
        ResourceSpec resourceSpec = new ResourceSpec(dst);
        String componentName = Util.fullNameToShortName(resourceSpec.getName());
        SingleFolderQuery sfq = SingleFolderQuery.byPath(Util.fullNameToPath(resourceSpec.getName()));
        FolderID folderID = sfq.selectSummaryView().getID();
        VersionNumber latestVersion = null;
        try {
            SingleComponentQuery scq = SingleComponentQuery.byName(folderID, componentName, null);
            latestVersion = scq.selectSummaryView().getVersionNumber();
        }
        catch (NoResultsFoundException nrfe) {
            latestVersion = null;
        }
        ComponentSaveContext csc = new ComponentSaveContext();
        csc.setLatestVersion(latestVersion);
        csc.setSaveAsNewMajor(isMajor);
        csc.setHideLatest(isHidePrev);
        ComponentExportServices ces = Context.getComponentExportServices();
        ExportContext exportCtx = new ExportContext();
        SourceInfo srcInfo = new SourceInfo(hostID, pickerName, src, src);
        BrowserInfo browser = null;
        BrowserInfo[] browserInfos = ces.getAvailableBrowsers(type);
        for (int i = 0; i < browserInfos.length; ++i) {
            String t = browserInfos[i].getBrowserType();
            if (pickerName != null && (t == null || !t.equals(pickerName))) continue;
            browser = browserInfos[i];
            break;
        }
        if (browser != null) {
            PromptParamList ppl = browser.getCheckinOptions();
            String[] varNames = ppl.getVarNames();
            for (int i = 0; i < varNames.length; ++i) {
                String name = varNames[i];
                String value = null;
                value = extraOpts != null && extraOpts.containsKey(name) ? (String)extraOpts.get(name) : ppl.getVarValue(name);
                srcInfo.addParameter(name, value, "");
            }
        }
        srcInfo.addParameter("force", new Boolean(!redun).toString(), "");
        srcInfo.addParameter("include owner", new Boolean(includeOwners).toString(), "");
        srcInfo.addParameter("include group", new Boolean(includeGroups).toString(), "");
        srcInfo.addParameter("configTemplate", new Boolean(isConfig).toString(), "");
        srcInfo.addParameter("add to checkin", new Boolean(addTo).toString(), "");
        exportCtx.setSourceInfo(srcInfo);
        exportCtx.setComponentSaveContext(csc);
        exportCtx.setDescription(description != null ? description : "");
        exportCtx.setPlatform(platform);
        CliRsrcData cliRsrcData = Context.getCliRsrcData();
        CompCheckInID jobID = ces.checkIn(type, pickerName, folderID, componentName, exportCtx);
        CheckIn.waitForCompletion(jobID);
        return jobID;
    }

    public static ComponentID getComponentID(String jobID) throws Exception {
        return CheckIn.getComponentID(new CompCheckInID(jobID));
    }

    public static ComponentID getComponentID(CompCheckInID jobID) throws Exception {
        CompStatus status = CheckIn.getCompCheckInInfo(jobID).getStatus();
        if (status instanceof CompComplete) {
            ComponentID id = ((CompComplete)status).getComponentID();
            return id;
        }
        throw new ResourceException("ui.cdb.rsrc.ci.EX_NO_RESOURCE_INFO_FOR_JOB");
    }

    public static CompCheckInInfo getCompCheckInInfo(CompCheckInID jobID) throws Exception {
        CheckIn.waitForCompletion(jobID);
        CompCheckInServices ccis = Context.getCompCheckInServices();
        return ccis.getCompCheckInInfo(jobID);
    }

    private static CompStatus waitForCompletion(CompCheckInID id) throws Exception {
        Exception[] a;
        CompCheckInServices ccis = Context.getCompCheckInServices();
        CompStatus currStatus = ccis.getStatus(id);
        while (currStatus instanceof CompPending) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            currStatus = ccis.getStatus(id);
        }
        if (currStatus instanceof CompError && (a = ((CompError)currStatus).getExceptions()) != null && a.length > 0) {
            throw a[0];
        }
        return currStatus;
    }

    protected static class CheckInHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.rsrc.ci.";

        CheckInHelp() {
            super(class$com$raplix$rolloutexpress$ui$resource$commands$CheckIn == null ? (class$com$raplix$rolloutexpress$ui$resource$commands$CheckIn = CheckIn.class$("com.raplix.rolloutexpress.ui.resource.commands.CheckIn")) : class$com$raplix$rolloutexpress$ui$resource$commands$CheckIn, "KEY:ui.cdb.rsrc.ci.COMMAND_DESC");
        }

        protected Vector getArgumentMap() {
            Vector theMap = super.getArgumentMap();
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("src", "KEY:ui.cdb.rsrc.ci.SRC_DESC"));
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("dst", "KEY:ui.cdb.rsrc.ci.DST_DESC"));
            theMap.addElement(new CommandHelpBase.RequiredArgInfo("type", "KEY:ui.cdb.rsrc.ci.TYPE_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("platform", "KEY:ui.cdb.rsrc.ci.PLATFORM_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("desc", "KEY:ui.cdb.rsrc.ci.DESC_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("major", "KEY:ui.cdb.rsrc.ci.MAJOR_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("config", "KEY:ui.cdb.rsrc.ci.CONFIG_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("hideprev", "KEY:ui.cdb.rsrc.ci.HIDEPREV_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("includeOwners", "KEY:ui.cdb.rsrc.ci.INCL_OWNERS_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("includeGroups", "KEY:ui.cdb.rsrc.ci.INCL_GROUPS_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("addTo", "KEY:ui.cdb.rsrc.ci.ADD_TO_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("hostID", "KEY:ui.cdb.rsrc.ci.HOST_ID_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("redun", "KEY:ui.cdb.rsrc.ci.REDUN_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("pickerName", "KEY:ui.cdb.rsrc.ci.PICKERNAME_DESC"));
            theMap.addElement(new CommandHelpBase.OptionalArgInfo("extraOpts", "KEY:ui.cdb.rsrc.ci.EXTRAOPTS_DESC"));
            return theMap;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", "KEY:ui.cdb.rsrc.ci.RESULT_DESC");
        }
    }
}

