/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plugindb.formatters;

import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;

public final class PluginUtil {
    private static final String PLUGIN_FORMAT_PREFIX = "ui.plugindb.format.p.";
    private static final String ID_HEADER = "ui.plugindb.format.p.ID_HEADER";
    private static final String NAME_HEADER = "ui.plugindb.format.p.NAME_HEADER";
    private static final String VERSION_HEADER = "ui.plugindb.format.p.VERSION_HEADER";
    private static final String ORDER_HEADER = "ui.plugindb.format.p.ORDER_HEADER";
    private static final String DESCRIPTION_HEADER = "ui.plugindb.format.p.DESCRIPTION_HEADER";
    private static final String VENDOR_HEADER = "ui.plugindb.format.p.VENDOR_HEADER";
    private static final String CERTIFICATE_HEADER = "ui.plugindb.format.p.CERTIFICATE_HEADER";
    private static final String CUSTOM_UI_HEADER = "ui.plugindb.format.p.CUSTOM_UI_HEADER";
    private static final String DEPENDENCIES_HEADER = "ui.plugindb.format.p.DEPENDENCIES_HEADER";
    private static final String CONTENTS_HEADER = "ui.plugindb.format.p.CONTENTS_HEADER";
    private static final String OBJECT_HEADER = "ui.plugindb.format.p.OBJECT_HEADER";
    private static final String OBJECT_TYPE_HEADER = "ui.plugindb.format.p.OBJECT_TYPE_HEADER";
    private static final String HOSTSET_OBJECT = "ui.plugindb.format.p.HOSTSET_OBJECT";
    private static final String HOSTSEARCH_OBJECT = "ui.plugindb.format.p.HOSTSEARCH_OBJECT";
    private static final String COMPONENT_OBJECT = "ui.plugindb.format.p.COMPONENT_OBJECT";
    private static final String PLAN_OBJECT = "ui.plugindb.format.p.PLAN_OBJECT";
    private static final String FOLDER_OBJECT = "ui.plugindb.format.p.FOLDER_OBJECT";
    private static final String HOSTTYPE_OBJECT = "ui.plugindb.format.p.HOSTTYPE_OBJECT";
    private static final String COMPONENTTYPE_OBJECT = "ui.plugindb.format.p.COMPONENTTYPE_OBJECT";
    private static final String SYSTEMSERVICE_OBJECT = "ui.plugindb.format.p.SYSTEMSERVICE_OBJECT";

    private PluginUtil() {
    }

    public static void detailedWrite(PrintWriter pw, Plugin plg, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(PluginUtil.toText(ID_HEADER) + ": " + plg.getID());
        pw.print(prefix);
        pw.println(PluginUtil.toText(NAME_HEADER) + ": " + plg.getName());
        pw.print(prefix);
        pw.println(PluginUtil.toText(VERSION_HEADER) + ": " + plg.getVersionNumber().getAsString());
        pw.print(prefix);
        pw.println(PluginUtil.toText(ORDER_HEADER) + ": " + (plg.getMenuOrder() == null ? "" : plg.getMenuOrder()));
        pw.print(prefix);
        pw.println(PluginUtil.toText(DESCRIPTION_HEADER) + ": " + (plg.getDescription() == null ? "" : plg.getDescription()));
        pw.print(prefix);
        pw.println(PluginUtil.toText(VENDOR_HEADER) + ": " + plg.getVendor());
        pw.print(prefix);
        pw.println(PluginUtil.toText(CERTIFICATE_HEADER) + ": " + (plg.getCertificateText() == null ? "" : plg.getCertificateText()));
        pw.print(prefix);
        pw.println(PluginUtil.toText(CUSTOM_UI_HEADER) + ": " + (plg.getCustomPagePath() == null ? "" : plg.getCustomPagePath()));
        pw.print(prefix);
        pw.println(PluginUtil.toText(CONTENTS_HEADER) + ": ");
        Column[] columns = new Column[]{new Column(45, 0, PluginUtil.toText(ID_HEADER)), new Column(25, 0, PluginUtil.toText(OBJECT_HEADER)), new Column(15, 0, PluginUtil.toText(OBJECT_TYPE_HEADER)), new Column(10, 0, PluginUtil.toText(VERSION_HEADER))};
        Table t = new Table(pw, columns, prefix + " ");
        String[] data = new String[columns.length];
        SummaryHostSet[] shs = plg.getHostSets().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < shs.length; ++i) {
            String cId = shs[i].getID().toString();
            String cObject = shs[i].getName();
            String cObjectType = PluginUtil.toText(HOSTSET_OBJECT);
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = "";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        SummaryHostSearch[] shsa = plg.getHostSearches().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < shsa.length; ++i) {
            String cId = shsa[i].getID().toString();
            String cObject = shsa[i].getName();
            String cObjectType = PluginUtil.toText(HOSTSEARCH_OBJECT);
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = "";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        SummaryComponent[] sc = plg.getComponents().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < sc.length; ++i) {
            String cId = sc[i].getID().toString();
            String cObject = sc[i].getName();
            String cObjectType = PluginUtil.toText(COMPONENT_OBJECT);
            String cVersion = sc[i].getVersionNumber().getAsString();
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = cVersion;
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        SummaryExecutionPlan[] sepa = plg.getPlans().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < sepa.length; ++i) {
            String cId = sepa[i].getID().toString();
            String cObject = sepa[i].getName();
            String cObjectType = PluginUtil.toText(PLAN_OBJECT);
            String cVersion = sepa[i].getVersionNumber().getAsString();
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = cVersion;
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        SummaryFolder[] sfa = plg.getFolders().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < sfa.length; ++i) {
            String cId = sfa[i].getID().toString();
            String cObject = sfa[i].getName();
            String cObjectType = PluginUtil.toText(FOLDER_OBJECT);
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = "";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        SummaryHostType[] shta = plg.getHostTypes().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < shta.length; ++i) {
            String cId = shta[i].getID().toString();
            String cObject = shta[i].getName();
            String cObjectType = PluginUtil.toText(HOSTTYPE_OBJECT);
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = "";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        ComponentTypeRef[] ctra = plg.getComponentTypes().getByIDsQuery().select();
        for (int i = 0; i < ctra.length; ++i) {
            String cId = ctra[i].getID().toString();
            String cObject = ctra[i].getName();
            String cObjectType = PluginUtil.toText(COMPONENTTYPE_OBJECT);
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = "";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        SystemServiceRef[] ssra = plg.getSystemServices().getByIDsQuery().select();
        for (int i = 0; i < ssra.length; ++i) {
            String cId = ssra[i].getID().toString();
            String cObject = ssra[i].getName();
            String cObjectType = PluginUtil.toText(SYSTEMSERVICE_OBJECT);
            data[0] = cId;
            data[1] = cObject;
            data[2] = cObjectType;
            data[3] = "";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
        pw.print(prefix);
        pw.println(PluginUtil.toText(DEPENDENCIES_HEADER) + ": ");
        Column[] columns1 = new Column[]{new Column(45, 0, PluginUtil.toText(ID_HEADER)), new Column(25, 0, PluginUtil.toText(NAME_HEADER))};
        Table t1 = new Table(pw, columns1, prefix + " ");
        String[] dependencyData = new String[columns1.length];
        SummaryPlugin[] dependencies = plg.getDependencies().getByIDsQuery().selectSummaryView();
        for (int i = 0; i < dependencies.length; ++i) {
            String id = dependencies[i].getID().toString();
            String name = dependencies[i].getName();
            dependencyData[0] = id;
            dependencyData[1] = name;
            t1.printRow(CollectionUtil.getEnumeration(dependencyData));
        }
        t1.endPrinting();
        pw.print(prefix);
    }

    public static void detailedWrite(PrintWriter pw, SummaryPlugin[] plgs, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, PluginUtil.toText(ID_HEADER)), new Column(25, 0, PluginUtil.toText(NAME_HEADER)), new Column(10, 0, PluginUtil.toText(VERSION_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[columns.length];
        for (int i = 0; i < plgs.length; ++i) {
            data[0] = plgs[i].getID().toString();
            data[1] = plgs[i].getName();
            data[2] = plgs[i].getVersionNumber().getAsString();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

