/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plugindb.formatters;

import [Lcom.raplix.rolloutexpress.systemmodel.plugindb.Plugin;;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.plugindb.formatters.PackageInfo;
import com.raplix.rolloutexpress.ui.plugindb.formatters.PluginUtil;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class FormatterBase
implements Formatter {
    private static final String NO_RESULT = "ui.plugindb.format.NO_RESULT";

    private Object convert(Object src, Class dstClass) throws Exception {
        try {
            return Context.getConverterHandler().convert(src, dstClass);
        }
        catch (ConverterNotFoundException ex) {
            return null;
        }
    }

    private void write(Object src, PrintWriter pw) throws Exception {
        if (src == null) {
            pw.println(Context.getMessageText(NO_RESULT));
            return;
        }
        Object result = this.convert(src, Plugin.class);
        if (result != null) {
            this.write((Plugin)result, pw);
            return;
        }
        result = this.convert(src, Plugin;.class);
        if (result != null) {
            this.write((Plugin[])result, pw);
            return;
        }
        PackageInfo.throwCannotWrite(src);
    }

    protected void write(Plugin plg, PrintWriter pw) throws Exception {
        PluginUtil.detailedWrite(pw, plg, "");
    }

    protected void write(Plugin[] plgs, PrintWriter pw) throws Exception {
        PluginUtil.detailedWrite(pw, plgs, "");
    }

    public void write(Object src, OutputStream out) throws Exception {
        PrintWriter pw = new PrintWriter(out);
        this.write(src, pw);
        pw.flush();
    }
}

