/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plugindb.commands;

import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import java.io.InputStream;
import java.util.Vector;

public class PluginAdd
extends SessionBase {
    private static CommandHelp sHelp = new PluginAddHelp();
    private Closer mCloser = new Closer();
    private InputStreamWrapper mPluginXMLStream;
    private PluginID mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$plugindb$commands$PluginAdd;

    public InputStreamWrapper getPluginXMLStream() {
        return this.mPluginXMLStream;
    }

    public void setPluginXMLStream(InputStreamWrapper pluginXMLStream) {
        this.mPluginXMLStream = pluginXMLStream;
        this.mCloser.register(this.mPluginXMLStream);
    }

    protected void setResult(PluginID result) {
        this.mResult = result;
    }

    public PluginID getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        InputStream in = this.getPluginXMLStream().getStream();
        PluginDescriptor pluginDescriptor = new PluginDescriptor(in, true);
        PluginID pluginID = Plugin.importPlugin(pluginDescriptor).join();
        this.setResult(pluginID);
    }

    public void cleanup() {
        super.cleanup();
        this.mCloser.closeAll();
    }

    protected static class PluginAddHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.plugindb.p.add.";
        private static final String MSG_PATH_DESC = "KEY:ui.plugindb.p.add.PATH_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.plugindb.p.add.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.plugindb.p.add.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("pluginXMLStream", MSG_PATH_DESC, "path"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        PluginAddHelp() {
            super(class$com$raplix$rolloutexpress$ui$plugindb$commands$PluginAdd == null ? (class$com$raplix$rolloutexpress$ui$plugindb$commands$PluginAdd = PluginAdd.class$("com.raplix.rolloutexpress.ui.plugindb.commands.PluginAdd")) : class$com$raplix$rolloutexpress$ui$plugindb$commands$PluginAdd, MSG_COMMAND_DESC);
        }
    }
}

