/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plandb.formatters;

import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.plugindb.formatters.PluginUtil;
import com.raplix.rolloutexpress.ui.userdb.formatters.UserUtil;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import com.sun.n1.util.vars.PromptParamList;
import java.io.PrintWriter;

public final class PlanDBUtil {
    private static final String PLAN_FORMAT_PREFIX = "ui.pdb.format.p.";
    private static final String PLAN_ID_HEADER = "ui.pdb.format.p.ID_HEADER";
    private static final String PLAN_NAME_HEADER = "ui.pdb.format.p.NAME_HEADER";
    private static final String PLAN_VERSION_HEADER = "ui.pdb.format.p.VERSION_HEADER";
    private static final String PLAN_DESCRIPTION_HEADER = "ui.pdb.format.p.DESCRIPTION_HEADER";
    private static final String PLAN_FROM_PLUGIN_HEADER = "ui.pdb.format.p.FROM_PLUGIN_HEADER";
    private static final String PLAN_CHECKIN_DATE_HEADER = "ui.pdb.format.p.CHECKIN_DATE_HEADER";
    private static final String PLAN_CHECKIN_USER_HEADER = "ui.pdb.format.p.CHECKIN_USER_HEADER";
    private static final String PLAN_NUM_STEPS_HEADER = "ui.pdb.format.p.NUM_STEPS_HEADER";
    private static final String PLAN_IS_HIDDEN_HEADER = "ui.pdb.format.p.IS_HIDDEN_HEADER";
    private static final String PLAN_CATEGORY_HEADER = "ui.pdb.format.p.CATEGORY_HEADER";
    private static final String PROMPT_FORMAT_PREFIX = "ui.pdb.format.prompt.";
    private static final String PROMPT_NAME_HEADER = "ui.pdb.format.prompt.NAME_HEADER";
    private static final String PROMPT_DEFAULT_HEADER = "ui.pdb.format.prompt.DEFAULT_HEADER";

    private PlanDBUtil() {
    }

    public static void write(PrintWriter pw, ExecutionPlan p, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_ID_HEADER) + ": " + p.getID());
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_NAME_HEADER) + ": " + p.getFullName());
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_VERSION_HEADER) + ": " + p.getVersionNumber().getAsString());
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_DESCRIPTION_HEADER) + ": " + p.getDescription());
        pw.print(prefix);
        if (p.getPluginID() != null) {
            pw.println(PlanDBUtil.toText(PLAN_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{p.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_CHECKIN_DATE_HEADER) + ": " + PlanDBUtil.convert(p.getTimeStamp(), String.class));
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_CHECKIN_USER_HEADER) + ":");
        UserUtil.write(pw, p.getUserID(), prefix + " ");
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_NUM_STEPS_HEADER) + ": " + p.getExecSteps().length);
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_CATEGORY_HEADER) + ": " + CategoriesBean.getCategoryNamesString(p.getCategories()));
        pw.print(prefix);
        pw.println(PlanDBUtil.toText(PLAN_IS_HIDDEN_HEADER) + ": " + new Boolean(p.getVisibility().equals(Visibility.HIDDEN)));
    }

    public static void write(PrintWriter pw, SummaryExecutionPlan[] a, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, PlanDBUtil.toText(PLAN_ID_HEADER)), new Column(15, 0, PlanDBUtil.toText(PLAN_NAME_HEADER)), new Column(7, 0, PlanDBUtil.toText(PLAN_VERSION_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[3];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].getID().toString();
            data[1] = a[i].getFullName();
            data[2] = a[i].getVersionNumber().getAsString();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, PromptParamList p, String prefix) throws Exception {
        String[] varNames = p.getVarNames();
        Column[] columns = new Column[]{new Column(30, 0, PlanDBUtil.toText(PROMPT_NAME_HEADER)), new Column(20, 0, PlanDBUtil.toText(PROMPT_DEFAULT_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < varNames.length; ++i) {
            data[0] = varNames[i];
            data[1] = p.getVarValue(varNames[i]);
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    private static Object convert(Object inObj, Class cls) throws Exception {
        return Context.getConverterHandler().convert(inObj, cls);
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

