/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plandb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.plandb.converters.ExecutionPlanID2ExecutionPlan;
import com.raplix.rolloutexpress.ui.plandb.converters.String2ExecutionPlanID;

public class String2ExecutionPlan
implements Converter,
Prefixes {
    public static final char VERSION_SEPARATOR = ':';

    public static ExecutionPlan convert(String src) throws PersistenceManagerException, RPCException {
        if ((src = src.trim()).startsWith("NM:")) {
            src = src.substring("NM:".length());
            return String2ExecutionPlan.convertByName(src);
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return String2ExecutionPlan.convertByID(src);
    }

    public static ExecutionPlan convertByID(String ID2) throws RPCException, PersistenceManagerException {
        ExecutionPlanID planID = String2ExecutionPlanID.convertByID(ID2);
        return ExecutionPlanID2ExecutionPlan.convert(planID);
    }

    public static ExecutionPlan convertByName(String planName) throws PersistenceManagerException, RPCException {
        FolderID folderID;
        String name;
        int sepNdx = planName.indexOf(58);
        String version = null;
        if (sepNdx == -1) {
            name = planName;
        } else {
            version = planName.substring(sepNdx + 1);
            name = planName.substring(0, sepNdx);
        }
        sepNdx = name.lastIndexOf("/");
        if (sepNdx == -1) {
            folderID = null;
        } else {
            folderID = SingleFolderQuery.byPath(name.substring(0, sepNdx + 1)).selectSummaryView().getID();
            name = name.substring(sepNdx + 1);
        }
        return SingleExecutionPlanQuery.byName(folderID, name, version).select();
    }
}

