/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plandb.commands;

import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanOrder;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class PlanList
extends SessionBase {
    private static CommandHelp sHelp = new PlanListHelp();
    private ExecutionPlan[] mResult;
    private boolean mShowHidden = false;
    private CategoryID mCategoryFilter = null;
    private FolderID mFolderID = FolderID.ROOT_FOLDER_ID;
    private boolean mFlatView = true;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$plandb$commands$PlanList;

    public boolean getShowHidden() {
        return this.mShowHidden;
    }

    public void setShowHidden(boolean showHidden) {
        this.mShowHidden = showHidden;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID filter) {
        this.mCategoryFilter = filter;
    }

    public FolderID getFolderID() {
        return this.mFolderID;
    }

    public void setFolderID(FolderID folderID) {
        this.mFolderID = folderID;
    }

    public boolean getFlatView() {
        return this.mFlatView;
    }

    public void setFlatView(boolean flatView) {
        this.mFlatView = flatView;
    }

    protected void setResult(ExecutionPlan[] result) {
        this.mResult = result;
    }

    public ExecutionPlan[] getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        MultiExecutionPlanQuery query = MultiExecutionPlanQuery.all();
        query.setObjectOrder(ExecutionPlanOrder.BY_ACTIVE_ASC);
        query.setVisibilityFilter(this.getShowHidden() ? null : Visibility.VISIBLE);
        query.setCategoryFilter(this.getCategoryFilter());
        FullPathFilter pathFilter = new FullPathFilter();
        pathFilter.setRecursiveMode(this.getFlatView());
        pathFilter.setSearchRoot(this.getFolderID());
        query.setFullPathFilter(pathFilter);
        this.setResult(query.select());
    }

    protected static class PlanListHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.pdb.p.la.";
        private static final String MSG_PLAN_SHOW_HIDDEN_DESC = "KEY:ui.pdb.p.la.PLAN_SHOW_HIDDEN_DESC";
        private static final String MSG_PLAN_CATEGORY_FILTER_DESC = "KEY:ui.pdb.p.la.CATEGORY_FILTER_DESC";
        private static final String MSG_PLAN_PARENT_FOLDER_DESC = "KEY:ui.pdb.p.la.PARENT_FOLDER_DESC";
        private static final String MSG_PLAN_FLATVIEW_DESC = "KEY:ui.pdb.p.la.FLATVIEW_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.pdb.p.la.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.pdb.p.la.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.OptionalArgInfo("showHidden", MSG_PLAN_SHOW_HIDDEN_DESC, "sh"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("categoryFilter", MSG_PLAN_CATEGORY_FILTER_DESC, "cat"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("folderID", MSG_PLAN_PARENT_FOLDER_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("flatView", MSG_PLAN_FLATVIEW_DESC));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        PlanListHelp() {
            super(class$com$raplix$rolloutexpress$ui$plandb$commands$PlanList == null ? (class$com$raplix$rolloutexpress$ui$plandb$commands$PlanList = PlanList.class$("com.raplix.rolloutexpress.ui.plandb.commands.PlanList")) : class$com$raplix$rolloutexpress$ui$plandb$commands$PlanList, MSG_COMMAND_DESC);
        }
    }
}

