/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plandb.commands;

import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import java.io.InputStream;
import java.util.Vector;

public class PlanCheckin
extends SessionBase {
    private static CommandHelp sHelp = new PlanCheckinHelp();
    private Closer mCloser = new Closer();
    private InputStreamWrapper mPlanXMLStream;
    private ExecutionPlan mResult;
    private boolean mIsMajor;
    private boolean mHidePrevious = true;
    private boolean mParents = false;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$plandb$commands$PlanCheckin;

    public InputStreamWrapper getPlanXMLStream() {
        return this.mPlanXMLStream;
    }

    public void setPlanXMLStream(InputStreamWrapper planXMLStream) {
        this.mPlanXMLStream = planXMLStream;
        this.mCloser.register(this.mPlanXMLStream);
    }

    public boolean getCheckinAsMajorVersion() {
        return this.mIsMajor;
    }

    public void setCheckinAsMajorVersion(boolean isMajor) {
        this.mIsMajor = isMajor;
    }

    public boolean getHidePrevious() {
        return this.mHidePrevious;
    }

    public void setHidePrevious(boolean hidePrevious) {
        this.mHidePrevious = hidePrevious;
    }

    public ExecutionPlan getResult() {
        return this.mResult;
    }

    protected void setResult(ExecutionPlan result) {
        this.mResult = result;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        InputStream in = this.getPlanXMLStream().getStream();
        VersionedSaveContext ctx = new VersionedSaveContext();
        ctx.setSaveAsNewMajor(this.getCheckinAsMajorVersion());
        ctx.setHideLatest(this.getHidePrevious());
        this.setResult(Context.getPlanIO().createNewVersionFrom(in, ctx, this.mParents));
    }

    public void cleanup() {
        super.cleanup();
        this.mCloser.closeAll();
    }

    public boolean getParents() {
        return this.mParents;
    }

    public void setParents(boolean parents) {
        this.mParents = parents;
    }

    protected static class PlanCheckinHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.pdb.p.ci.";
        private static final String MSG_PATH_DESC = "KEY:ui.pdb.p.ci.PATH_DESC";
        private static final String MSG_CHECKINASMAJOR_DESC = "KEY:ui.pdb.p.ci.CHECKINASMAJOR_DESC";
        private static final String MSG_HIDEPREV_DESC = "KEY:ui.pdb.p.ci.HIDEPREV_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.pdb.p.ci.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.pdb.p.ci.COMMAND_DESC";
        private static final String MSG_PARENTS_DESC = "KEY:ui.pdb.p.ci.PARENTS_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("planXMLStream", MSG_PATH_DESC, "path"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("checkinAsMajorVersion", MSG_CHECKINASMAJOR_DESC, "major"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("hidePrevious", MSG_HIDEPREV_DESC, "hidePrev"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("parents", MSG_PARENTS_DESC, "parents"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        PlanCheckinHelp() {
            super(class$com$raplix$rolloutexpress$ui$plandb$commands$PlanCheckin == null ? (class$com$raplix$rolloutexpress$ui$plandb$commands$PlanCheckin = PlanCheckin.class$("com.raplix.rolloutexpress.ui.plandb.commands.PlanCheckin")) : class$com$raplix$rolloutexpress$ui$plandb$commands$PlanCheckin, MSG_COMMAND_DESC);
        }
    }
}

