/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.plandb.commands;

import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class GeneratePlan
extends SessionBase
implements OutputCommand {
    private static CommandHelp sHelp = new GeneratePlanHelp();
    private ComponentID mComponentID;
    private String[] mProcedureNames;
    private NamedBlockType[] mProcedureTypes;
    private OutputStream mOutputStream;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$plandb$commands$GeneratePlan;

    public void setOutputStream(OutputStream stream) {
        this.mOutputStream = stream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public ComponentID getComponentID() {
        return this.mComponentID;
    }

    public void setComponentID(ComponentID componentID) {
        this.mComponentID = componentID;
    }

    public String[] getProcedureNames() {
        return this.mProcedureNames;
    }

    public void setProcedureNames(String[] procedureNames) {
        this.mProcedureNames = procedureNames;
    }

    public NamedBlockType[] getProcedureTypes() {
        return this.mProcedureTypes;
    }

    public void setProcedureTypes(NamedBlockType[] procedureTypes) {
        this.mProcedureTypes = procedureTypes;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        if (this.getOutputStream() == null) {
            this.setOutputStream(System.out);
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.mOutputStream, "UTF-8");
        PlanInterface pe = Context.getPlanInterface();
        NamedBlockType[] typesArray = new NamedBlockType[this.mProcedureTypes.length];
        for (int i = 0; i < this.mProcedureTypes.length; ++i) {
            typesArray[i] = this.mProcedureTypes[i].equals(NamedBlockType.INSTALL) ? NamedBlockType.INSTALL : (this.mProcedureTypes[i].equals(NamedBlockType.UNINSTALL) ? NamedBlockType.UNINSTALL : NamedBlockType.CONTROL);
        }
        writer.write(pe.generatePlanText(this.mComponentID, this.mProcedureNames, typesArray));
        writer.flush();
    }

    protected static class GeneratePlanHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.pdb.p.genplan";
        private static final String MSG_COMPONENT_ID_DESC = "KEY:ui.pdb.p.genplan.COMPONENT_ID_DESC";
        private static final String MSG_PROCEDURE_NAMES_DESC = "KEY:ui.pdb.p.genplan.PROCEDURE_NAMES_DESC";
        private static final String MSG_PROCEDURE_TYPES_DESC = "KEY:ui.pdb.p.genplan.PROCEDURE_TYPES_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.pdb.p.genplan.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("componentID", MSG_COMPONENT_ID_DESC));
            map.addElement(new CommandHelpBase.RequiredArgInfo("procedureNames", MSG_PROCEDURE_NAMES_DESC, "pn"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("procedureTypes", MSG_PROCEDURE_TYPES_DESC, "pt"));
            return map;
        }

        GeneratePlanHelp() {
            super(class$com$raplix$rolloutexpress$ui$plandb$commands$GeneratePlan == null ? (class$com$raplix$rolloutexpress$ui$plandb$commands$GeneratePlan = GeneratePlan.class$("com.raplix.rolloutexpress.ui.plandb.commands.GeneratePlan")) : class$com$raplix$rolloutexpress$ui$plandb$commands$GeneratePlan, MSG_COMMAND_DESC);
        }
    }
}

