/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.node.formatters;

import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskSummary;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;

public class UpgradeTaskUtil {
    private static final String NODE_FORMAT_PREFIX = "ui.node.format.au.";
    private static final String UPGRADE_TASK_ID = "ui.node.format.au.UPGRADE_TASK_ID";
    private static final String UPGRADE_TASK_STATE = "ui.node.format.au.UPGRADE_TASK_STATE";
    private static final String START_TIME = "ui.node.format.au.START_TIME";
    private static final String END_TIME = "ui.node.format.au.END_TIME";
    private static final String NODE_STATUS = "ui.node.format.au.NODE_STATUS";
    private static final String IN_PROGRESS = "ui.node.format.au.IN_PROGRESS";
    private static final String SUCCESSFUL = "ui.node.format.au.SUCCESSFUL";
    private static final String FAILED = "ui.node.format.au.FAILED";
    private static final String ACTIONREQUIRED = "ui.node.format.au.ACTIONREQUIRED";
    private static final String PARTIALLYCOMPLETED = "ui.node.format.au.PARTIALLYCOMPLETED";
    private static final String DEPLOYED = "ui.node.format.au.DEPLOYED";
    private static final String UNPROCESSED = "ui.node.format.au.UNPROCESSED";
    private static final String NOT_STARTED = "ui.node.format.au.NOT_STARTED";
    private static final String NODES_ALREADY_UPGRADED = "ui.node.format.au.NODES_ALREADY_UPGRADED";
    private static final String UPGRADING = "ui.node.format.au.UPGRADING";
    private static final String UPGRADED = "ui.node.format.au.UPGRADED";
    private static final String NO_END_TIME = "ui.node.format.au.NO_END_TIME";
    private static final String NO_START_TIME = "ui.node.format.au.NO_START_TIME";
    private static final String ALL_NODE_DETAILS = "ui.node.format.au.ALL_NODE_DETAILS";
    private static final String NODE_NAME = "ui.node.format.au.NODE_NAME";
    private static final String NODE_STATE = "ui.node.format.au.NODE_STATE";
    private static final String NODE_TYPE = "ui.node.format.au.NODE_TYPE";
    private static final String NODE_DETAIL = "ui.node.format.au.NODE_DETAIL";
    private static final String UPGRADE_ABORT_SUMMARY_MESSAGE = "ui.node.format.au.UPGRADE_ABORT_SUMMARY_MESSAGE";
    private static final String UPGRADE_ABORT_DETAIL_MESSAGE = "ui.node.format.au.UPGRADE_ABORT_DETAIL_MESSAGE";

    public static void detailedWrite(PrintWriter pw, UpgradeTaskStatus u, String prefix) throws Exception {
        pw.println(UpgradeTaskUtil.toText(UPGRADE_TASK_ID) + " : " + u.getTaskID().toString());
        pw.println(UpgradeTaskUtil.toText(UPGRADE_TASK_STATE) + " : " + u.getTaskState().toString());
        pw.print(UpgradeTaskUtil.toText(START_TIME) + " : ");
        if (null != u.getStartTime()) {
            pw.println(Context.getConverterHandler().convert(u.getStartTime(), String.class));
        } else {
            pw.println(UpgradeTaskUtil.toText(NO_START_TIME));
        }
        pw.print(UpgradeTaskUtil.toText(END_TIME) + " : ");
        if (null != u.getEndTime()) {
            pw.println(Context.getConverterHandler().convert(u.getEndTime(), String.class));
        } else {
            pw.println(UpgradeTaskUtil.toText(NO_END_TIME));
        }
        UpgradeTaskSummary uTaskSummary = u.computeUpgradeTaskSummary();
        UpgradeTaskUtil.printStatus(pw, uTaskSummary);
        UpgradeNodeStatus[] nodeStatus = u.getAllNodeStatus();
        if (null != nodeStatus && 0 != nodeStatus.length) {
            pw.println("");
            if (u.isAborted()) {
                pw.println(UpgradeTaskUtil.toText(UPGRADE_ABORT_DETAIL_MESSAGE));
            }
            pw.println();
            pw.println(UpgradeTaskUtil.toText(ALL_NODE_DETAILS));
            pw.println();
            Column[] columns = new Column[]{new Column(15, 0, UpgradeTaskUtil.toText(NODE_NAME)), new Column(6, 0, UpgradeTaskUtil.toText(NODE_TYPE)), new Column(20, 0, UpgradeTaskUtil.toText(NODE_STATE)), new Column(35, 0, UpgradeTaskUtil.toText(NODE_DETAIL))};
            Table t = new Table(pw, columns, prefix + " ");
            String[] data = new String[4];
            int i = 0;
            int j = 1;
            while (i < nodeStatus.length) {
                data[0] = nodeStatus[i].getName();
                data[1] = nodeStatus[i].getType().toString();
                data[2] = nodeStatus[i].getState().toString();
                data[3] = nodeStatus[i].getDetail();
                t.printRow(CollectionUtil.getEnumeration(data));
                ++i;
                ++j;
            }
            t.endPrinting();
        }
    }

    public static void convertToTaskSummaryAndWrite(PrintWriter pw, UpgradeTaskStatus u, String prefix) throws Exception {
        UpgradeTaskSummary upgradeTaskSummary = u.computeUpgradeTaskSummary();
        UpgradeTaskSummary[] taskSummaryArray = new UpgradeTaskSummary[]{upgradeTaskSummary};
        if (null != taskSummaryArray && 0 != taskSummaryArray.length) {
            UpgradeTaskUtil.summaryWrite(pw, taskSummaryArray, prefix);
        }
    }

    public static void summaryWrite(PrintWriter pw, UpgradeTaskSummary[] u, String prefix) throws Exception {
        for (int i = 0; i < u.length; ++i) {
            pw.println(prefix);
            pw.println(UpgradeTaskUtil.toText(UPGRADE_TASK_ID) + " : " + u[i].getTaskID().toString());
            pw.println(UpgradeTaskUtil.toText(UPGRADE_TASK_STATE) + " : " + u[i].getTaskState().toString());
            pw.print(UpgradeTaskUtil.toText(START_TIME) + " : ");
            if (null != u[i].getStartTime()) {
                pw.println(Context.getConverterHandler().convert(u[i].getStartTime(), class$java$lang$String == null ? UpgradeTaskUtil.class$("java.lang.String") : class$java$lang$String));
            } else {
                pw.println(UpgradeTaskUtil.toText(NO_START_TIME));
            }
            pw.print(UpgradeTaskUtil.toText(END_TIME) + " : ");
            if (null != u[i].getEndTime()) {
                pw.println(Context.getConverterHandler().convert(u[i].getEndTime(), class$java$lang$String == null ? UpgradeTaskUtil.class$("java.lang.String") : class$java$lang$String));
            } else {
                pw.println(UpgradeTaskUtil.toText(NO_END_TIME));
            }
            UpgradeTaskUtil.printStatus(pw, u[i]);
            if (!u[i].isAborted()) continue;
            pw.println(UpgradeTaskUtil.toText(UPGRADE_ABORT_SUMMARY_MESSAGE));
        }
    }

    private static boolean printNodeStateCount(PrintWriter pw, String state, int nodeStateCount, boolean bDisplayedStatus) {
        if (nodeStateCount != 0) {
            if (bDisplayedStatus) {
                pw.print(", ");
            }
            pw.print(nodeStateCount + " " + UpgradeTaskUtil.toText(state));
            return true;
        }
        return false;
    }

    private static void printStatus(PrintWriter pw, UpgradeTaskSummary u) {
        boolean bDisplayedStatus = false;
        pw.print(UpgradeTaskUtil.toText(NODE_STATUS) + " : ");
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, SUCCESSFUL, u.getSuccessfulNodeCount(), bDisplayedStatus);
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, DEPLOYED, u.getDeployedNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, UPGRADED, u.getUpgradedNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, PARTIALLYCOMPLETED, u.getPartiallyCompletedNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, UNPROCESSED, u.getUnprocessedNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, IN_PROGRESS, u.getInProgressNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, UPGRADING, u.getUpgradingNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, NOT_STARTED, u.getNotStartedNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, ACTIONREQUIRED, u.getActionRequiredNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        boolean bl = bDisplayedStatus = UpgradeTaskUtil.printNodeStateCount(pw, FAILED, u.getFailedNodeCount(), bDisplayedStatus) || bDisplayedStatus;
        if (!bDisplayedStatus) {
            pw.println(UpgradeTaskUtil.toText(NODES_ALREADY_UPGRADED));
        } else {
            pw.println("");
        }
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

